/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERUnknownTag
extends DERObject {
    int tag;
    byte[] data;

    public DERUnknownTag(int n, byte[] byArray) {
        this.tag = n;
        this.data = byArray;
    }

    public int getTag() {
        return this.tag;
    }

    public byte[] getData() {
        return this.data;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(this.tag, this.data);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DERUnknownTag)) {
            return false;
        }
        DERUnknownTag dERUnknownTag = (DERUnknownTag)object;
        if (this.tag != dERUnknownTag.tag) {
            return false;
        }
        if (this.data.length != dERUnknownTag.data.length) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == dERUnknownTag.data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        byte[] byArray = this.getData();
        int n = 0;
        for (int i = 0; i != byArray.length; ++i) {
            n ^= (byArray[i] & 0xFF) << i % 4;
        }
        return n ^ this.getTag();
    }
}

