/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.ssi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ssiitem.GroupItem;
import net.kano.joustsim.oscar.oscar.service.ssi.AbstractGroup;
import net.kano.joustsim.oscar.oscar.service.ssi.SimpleBuddy;
import net.kano.joustsim.oscar.oscar.service.ssi.SimpleBuddyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleBuddyGroup
extends AbstractGroup {
    private GroupItem item;
    private final int itemId;
    private boolean active = true;

    public SimpleBuddyGroup(SimpleBuddyList list, GroupItem item) {
        super(list);
        this.itemId = item.getId();
        this.setItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItem(GroupItem item) {
        DefensiveTools.checkNull((Object)item, (String)"item");
        Object object = this.getBuddyListLock();
        synchronized (object) {
            GroupItem oldItem = this.item;
            if (item == oldItem) {
                return;
            }
            if (item.getId() != this.itemId) {
                throw new IllegalArgumentException("item ID " + item.getId() + " does not match this group's ID " + this.itemId);
            }
            this.item = item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupItem getItem() {
        Object object = this.getBuddyListLock();
        synchronized (object) {
            return this.item;
        }
    }

    @Override
    protected List<SimpleBuddy> getSortedBuddies() {
        HashMap<Integer, SimpleBuddy> id2buddy = new HashMap<Integer, SimpleBuddy>();
        for (SimpleBuddy buddy : this.getBuddies()) {
            id2buddy.put(buddy.getItem().getId(), buddy);
        }
        ArrayList<SimpleBuddy> newBuddies = new ArrayList<SimpleBuddy>();
        GroupItem item = this.getItem();
        int[] buddies = item.getBuddies();
        if (buddies != null) {
            for (int buddyId : buddies) {
                SimpleBuddy buddy = (SimpleBuddy)id2buddy.remove(buddyId);
                if (buddy == null) continue;
                newBuddies.add(buddy);
            }
        }
        ArrayList leftover = new ArrayList(id2buddy.values());
        Collections.sort(leftover, SimpleBuddyList.COMPARATOR_SN);
        newBuddies.addAll(leftover);
        return newBuddies;
    }

    @Override
    protected boolean isGroupValid() {
        if (!super.isGroupValid()) {
            return false;
        }
        for (SimpleBuddy buddy : this.getBuddies()) {
            if (buddy.getItem().getGroupId() == this.itemId) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return this.getItem().getGroupName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.getBuddyListLock();
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean active) {
        Object object = this.getBuddyListLock();
        synchronized (object) {
            this.active = active;
        }
    }
}

