/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TypeHintContext {
    private String cachedToString = null;
    private final Method method;
    private final int parameterNumber;
    private final List genericParameterTree;

    public TypeHintContext(Method method, int parameterNumber) {
        this.method = method;
        this.parameterNumber = parameterNumber;
        this.genericParameterTree = new ArrayList();
    }

    public TypeHintContext createChildContext(int genericParameterNumber) {
        TypeHintContext child = new TypeHintContext(this.getMethod(), this.getParameterNumber());
        child.genericParameterTree.addAll(this.getGenericParameterTree());
        child.genericParameterTree.add(new Integer(genericParameterNumber));
        return child;
    }

    public Method getMethod() {
        return this.method;
    }

    public int getParameterNumber() {
        return this.parameterNumber;
    }

    public List getGenericParameterTree() {
        return this.genericParameterTree;
    }

    public int hashCode() {
        return this.method.hashCode() + this.parameterNumber + this.genericParameterTree.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TypeHintContext that = (TypeHintContext)obj;
        if (!this.method.equals(that.method)) {
            return false;
        }
        if (this.parameterNumber != that.parameterNumber) {
            return false;
        }
        return this.genericParameterTree.equals(that.genericParameterTree);
    }

    public String toString() {
        if (this.cachedToString == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.method.getName());
            buffer.append('(');
            buffer.append(this.parameterNumber);
            Iterator it = this.genericParameterTree.iterator();
            while (it.hasNext()) {
                buffer.append('<');
                buffer.append(it.next());
            }
            it = this.genericParameterTree.iterator();
            while (it.hasNext()) {
                buffer.append('>');
                it.next();
            }
            buffer.append(')');
            this.cachedToString = buffer.toString();
        }
        return this.cachedToString;
    }
}

