/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JInternalFrame;

public class Concat
extends AbstractTool {
    static {
        Concat.addVersion("$Id: Concat.java,v 1.8 2006/10/27 17:23:25 xlv Exp $");
    }

    public Concat() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcfile1", "The first PDF file", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "srcfile2", "The second PDF file", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the concatenated PDF has to be written", true, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Concatenate 2 PDF files", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Concat OPENED ===");
    }

    public void execute() {
        try {
            String[] files = new String[2];
            if (this.getValue("srcfile1") == null) {
                throw new InstantiationException("You need to choose a first sourcefile");
            }
            files[0] = ((File)this.getValue("srcfile1")).getAbsolutePath();
            if (this.getValue("srcfile2") == null) {
                throw new InstantiationException("You need to choose a second sourcefile");
            }
            files[1] = ((File)this.getValue("srcfile2")).getAbsolutePath();
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File pdf_file = (File)this.getValue("destfile");
            int pageOffset = 0;
            ArrayList master = new ArrayList();
            Document document = null;
            PdfCopy writer = null;
            int i = 0;
            while (i < 2) {
                PdfReader reader = new PdfReader(files[i]);
                reader.consolidateNamedDestinations();
                int n = reader.getNumberOfPages();
                List bookmarks = SimpleBookmark.getBookmark(reader);
                if (bookmarks != null) {
                    if (pageOffset != 0) {
                        SimpleBookmark.shiftPageNumbers(bookmarks, pageOffset, null);
                    }
                    master.addAll(bookmarks);
                }
                pageOffset += n;
                System.out.println("There are " + n + " pages in " + files[i]);
                if (i == 0) {
                    document = new Document(reader.getPageSizeWithRotation(1));
                    writer = new PdfCopy(document, (OutputStream)new FileOutputStream(pdf_file));
                    document.open();
                }
                int p = 0;
                while (p < n) {
                    PdfImportedPage page = writer.getImportedPage(reader, ++p);
                    writer.addPage(page);
                    System.out.println("Processed page " + p);
                }
                ++i;
            }
            if (!master.isEmpty()) {
                writer.setOutlines(master);
            }
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        Concat tool = new Concat();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

