/*
 * Decompiled with CFR 0.152.
 */
package org.hn.sleek.jmml;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import org.hn.sleek.jmml.Capabilities;
import org.hn.sleek.jmml.Contact;
import org.hn.sleek.jmml.ContactList;
import org.hn.sleek.jmml.ContactStatus;
import org.hn.sleek.jmml.DispatchServerConnector;
import org.hn.sleek.jmml.IncomingMessage;
import org.hn.sleek.jmml.MSNException;
import org.hn.sleek.jmml.MSNPListener;
import org.hn.sleek.jmml.Message;
import org.hn.sleek.jmml.MessengerServerManager;
import org.hn.sleek.jmml.OutgoingMessage;
import org.hn.sleek.jmml.Profile;
import org.hn.sleek.jmml.SSLServerConnection;
import org.hn.sleek.jmml.ServerConnection;
import org.hn.sleek.jmml.SwitchboardSessionConnector;

class NotificationServerConnector
implements MSNPListener,
Runnable {
    static final String MESSENGER_CHALLENGE_STRING = "VT6PX?UQTM4WM%YR";
    static final String SDC_STRING = "0x0409 MSMSGS JMML X X";
    static final int CLIENT_ID = 0;
    static final int MAX_PING_COUNT = 6;
    static final int PING_THREAD_WAIT_TIME = 10000;
    String serverIP;
    Integer serverPort;
    String userName;
    String password;
    int transactionID = 0;
    int nClientPingCount = 0;
    ServerConnection sc;
    boolean bLoggedIn = false;
    boolean bPrivacyMode;
    boolean bReverseListBehaviour;
    boolean bMobileAuthorization;
    boolean bMobileDeviceEnabled;
    String strUserStatus;
    Hashtable hGroups;
    Hashtable hBlockingContacts;
    Hashtable hAllowingContacts;
    Hashtable hPhoneNumbers;
    ContactList contactList;
    Object objPingLock;
    Thread clienPingThread;
    Profile profile = null;
    HashMap switchboardSessions;

    NotificationServerConnector(String serverIP, Integer serverPort) {
        this.serverIP = serverIP;
        this.serverPort = serverPort;
        this.switchboardSessions = new HashMap();
        this.contactList = new ContactList();
        this.hGroups = new Hashtable();
        this.hBlockingContacts = new Hashtable();
        this.hAllowingContacts = new Hashtable();
        this.hPhoneNumbers = new Hashtable();
        this.objPingLock = new Object();
        this.clienPingThread = new Thread(this);
        this.profile = new Profile();
        this.bPrivacyMode = true;
        this.bReverseListBehaviour = true;
        this.bMobileAuthorization = true;
        this.bMobileDeviceEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void signIn(String userName, String password, String strStatus, boolean blocking) {
        this.strUserStatus = strStatus;
        this.userName = userName;
        this.password = password;
        this.nClientPingCount = 0;
        this.hBlockingContacts.clear();
        this.hAllowingContacts.clear();
        this.sc = new ServerConnection(this.serverIP, this.serverPort, this);
        OutgoingMessage msg = new OutgoingMessage(32, this.getTransactionID());
        msg.addArgument("MSNP8");
        msg.addArgument("CVR0");
        this.sc.sendMSNPMessage(msg);
        if (blocking && this.isConnected()) {
            try {
                NotificationServerConnector notificationServerConnector = this;
                synchronized (notificationServerConnector) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    void signOut() throws MSNException {
        if (!this.isConnected()) {
            throw new MSNException(3);
        }
        OutgoingMessage msg = new OutgoingMessage(22, -1);
        this.sc.sendMSNPMessage(msg);
        this.contactList.removeAll();
    }

    boolean isConnected() {
        return this.sc.isConnected();
    }

    void sendMessage(String buddyName, String message) throws MSNException {
        SwitchboardSessionConnector ssc;
        if (this.isConnected()) {
            Object o = this.switchboardSessions.get(buddyName);
            if (o == null) {
                ssc = new SwitchboardSessionConnector(this.userName, buddyName, this);
                this.switchboardSessions.put(buddyName, ssc);
            } else {
                ssc = (SwitchboardSessionConnector)o;
            }
        } else {
            throw new MSNException(3);
        }
        ssc.sendMessage(message);
    }

    void sendMessage(OutgoingMessage msg) {
        this.sc.sendMSNPMessage(msg);
    }

    String getUserName() {
        return this.userName;
    }

    Profile getProfile() {
        return this.profile;
    }

    void setStatus(String strNewStatus) throws MSNException {
        if (this.isConnected()) {
            if (ContactStatus.parseStatus(strNewStatus).compareTo("UNKNOWN") == 0) {
                throw new MSNException(6);
            }
        } else {
            throw new MSNException(3);
        }
        OutgoingMessage outgoingMsg = new OutgoingMessage(9, this.getTransactionID());
        this.strUserStatus = strNewStatus;
        outgoingMsg.addArgument(this.strUserStatus);
        outgoingMsg.addArgument(String.valueOf(0));
        this.sc.sendMSNPMessage(outgoingMsg);
    }

    String getStatus() {
        return this.strUserStatus;
    }

    void setPrivacyMode(boolean bAllowAll) throws MSNException {
        if (!this.isConnected()) {
            throw new MSNException(3);
        }
        OutgoingMessage outgoingMsg = new OutgoingMessage(5, this.getTransactionID());
        outgoingMsg.addArgument(bAllowAll ? "AL" : "BL");
        this.sc.sendMSNPMessage(outgoingMsg);
    }

    boolean getPrivacyMode() throws MSNException {
        if (this.isConnected()) {
            return this.bPrivacyMode;
        }
        throw new MSNException(3);
    }

    void setReverseListBehaviour(boolean bAutomaticAddRLToAL) throws MSNException {
        if (!this.isConnected()) {
            throw new MSNException(3);
        }
        OutgoingMessage outgoingMsg = new OutgoingMessage(12, this.getTransactionID());
        outgoingMsg.addArgument(bAutomaticAddRLToAL ? "N" : "A");
        this.sc.sendMSNPMessage(outgoingMsg);
    }

    boolean getReverseListBehaviour() throws MSNException {
        if (this.isConnected()) {
            return this.bReverseListBehaviour;
        }
        throw new MSNException(3);
    }

    synchronized void addToContactList(Contact contact) throws MSNException {
        this.addToContactList(contact, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void addToContactList(Contact contact, int nGroupId) throws MSNException {
        Contact c;
        if (!this.isConnected()) throw new MSNException(3);
        try {
            c = this.contactList.getContact(contact.getUserName());
        }
        catch (MSNException e) {
            System.err.println("NotificationServerConnector.addToContactList() - " + e);
            c = null;
        }
        if (c != null) {
            if (c.isBlocked() && contact.isAllowed()) {
                throw new MSNException(10);
            }
            if (c.isAllowed() && contact.isBlocked()) {
                throw new MSNException(11);
            }
        }
        if (contact.isReverse()) throw new MSNException(4);
        OutgoingMessage outgoingMsg = new OutgoingMessage(2, this.getTransactionID());
        Integer iListType = (Integer)contact.getListType().values().toArray()[0];
        outgoingMsg.addArgument(ContactList.parseListType(iListType));
        outgoingMsg.addArgument(contact.getUserName());
        outgoingMsg.addArgument(contact.getFriendlyName().compareTo("") == 0 ? contact.getUserName() : contact.getFriendlyName());
        if (nGroupId != -1) {
            outgoingMsg.addArgument(Integer.toString(nGroupId));
        }
        this.sc.sendMSNPMessage(outgoingMsg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void removeFromContactList(Contact contact, int nGroupId) throws MSNException {
        Contact c;
        if (!this.isConnected()) throw new MSNException(3);
        try {
            c = this.contactList.getContact(contact.getUserName());
        }
        catch (MSNException e) {
            System.err.println("NotificationServerConnector.removeFromContactList() - " + e);
            throw new MSNException(2);
        }
        if (nGroupId != -1 && nGroupId != -2 && nGroupId != -3 && !c.containGroup(nGroupId == -1 ? 0 : nGroupId)) {
            throw new MSNException(9);
        }
        if (contact.isReverse()) throw new MSNException(5);
        OutgoingMessage outgoingMsg = new OutgoingMessage(27, this.getTransactionID());
        if (nGroupId == -2) {
            this.hBlockingContacts.put(contact.getUserName(), contact);
        } else if (nGroupId == -3) {
            this.hAllowingContacts.put(contact.getUserName(), contact);
        }
        Integer iListType = (Integer)contact.getListType().values().toArray()[0];
        outgoingMsg.addArgument(ContactList.parseListType(iListType));
        outgoingMsg.addArgument(contact.getUserName());
        if (nGroupId != -1 && nGroupId != -2 && nGroupId != -3) {
            outgoingMsg.addArgument(Integer.toString(nGroupId));
        }
        this.sc.sendMSNPMessage(outgoingMsg);
    }

    ContactList getContactList() {
        return this.contactList;
    }

    void synchronizeContactList() throws MSNException {
        if (!this.isConnected()) {
            throw new MSNException(3);
        }
        OutgoingMessage outgoingMsg = new OutgoingMessage(30, this.getTransactionID());
        outgoingMsg.addArgument(String.valueOf(this.contactList.getContactListVersion()));
        this.contactList.removeAll();
        this.hGroups.clear();
        this.sc.sendMSNPMessage(outgoingMsg);
    }

    Hashtable getGroups() {
        return (Hashtable)this.hGroups.clone();
    }

    void addGroup(String strGroupName) throws MSNException {
        if (this.isConnected()) {
            try {
                OutgoingMessage outgoingMsg = new OutgoingMessage(3, this.getTransactionID());
                String utfEncodedGrp = URLEncoder.encode(strGroupName, "UTF-8");
                String strTmp = utfEncodedGrp.replaceAll("\\+", "%20");
                outgoingMsg.addArgument(strTmp);
                outgoingMsg.addArgument("0");
                this.sc.sendMSNPMessage(outgoingMsg);
            }
            catch (UnsupportedEncodingException e) {
                throw new MSNException(13);
            }
        } else {
            throw new MSNException(3);
        }
    }

    void removeGroup(int nGroupId) throws MSNException {
        if (!this.isConnected()) {
            throw new MSNException(3);
        }
        OutgoingMessage outgoingMsg = new OutgoingMessage(28, this.getTransactionID());
        outgoingMsg.addArgument(String.valueOf(nGroupId));
        this.sc.sendMSNPMessage(outgoingMsg);
    }

    void renameGroup(int nGroupId, String strNewGroupName) throws MSNException {
        if (this.isConnected()) {
            try {
                OutgoingMessage outgoingMsg = new OutgoingMessage(26, this.getTransactionID());
                String utfEncodedGrp = URLEncoder.encode(strNewGroupName, "UTF-8");
                String strTmp = utfEncodedGrp.replaceAll("\\+", "%20");
                outgoingMsg.addArgument(String.valueOf(nGroupId));
                outgoingMsg.addArgument(strTmp);
                outgoingMsg.addArgument("0");
                this.sc.sendMSNPMessage(outgoingMsg);
            }
            catch (UnsupportedEncodingException e) {
                throw new MSNException(13);
            }
        } else {
            throw new MSNException(3);
        }
    }

    void sendEmailInvitation(String strUserEmail) throws MSNException {
        if (this.isConnected()) {
            try {
                OutgoingMessage outgoingMsg = new OutgoingMessage(35, this.getTransactionID());
                String utfEncodedUser = URLEncoder.encode(this.userName, "UTF-8");
                outgoingMsg.addArgument(strUserEmail);
                outgoingMsg.addArgument(SDC_STRING);
                outgoingMsg.addArgument(utfEncodedUser);
                outgoingMsg.addArgument("8");
                this.sc.sendMSNPMessage(outgoingMsg);
            }
            catch (UnsupportedEncodingException e) {
                throw new MSNException(13);
            }
        } else {
            throw new MSNException(3);
        }
    }

    void setFriendlyName(String strFriendlyName) throws MSNException {
        if (this.isConnected()) {
            try {
                OutgoingMessage outgoingMsg = new OutgoingMessage(25, this.getTransactionID());
                String utfEncodedName = URLEncoder.encode(strFriendlyName, "UTF-8");
                String strTmp = utfEncodedName.replaceAll("\\+", "%20");
                outgoingMsg.addArgument(this.userName);
                outgoingMsg.addArgument(strTmp);
                this.sc.sendMSNPMessage(outgoingMsg);
            }
            catch (UnsupportedEncodingException e) {
                throw new MSNException(13);
            }
        } else {
            throw new MSNException(3);
        }
    }

    void setPhoneNumber(String strPhoneNumber, int nPhoneType) throws MSNException {
        if (this.isConnected()) {
            try {
                OutgoingMessage outgoingMsg = new OutgoingMessage(23, this.getTransactionID());
                String utfEncodedPhone = URLEncoder.encode(strPhoneNumber, "UTF-8");
                String strTmp = utfEncodedPhone.replaceAll("\\+", "%20");
                switch (nPhoneType) {
                    case 1: {
                        outgoingMsg.addArgument("PHH");
                        break;
                    }
                    case 2: {
                        outgoingMsg.addArgument("PHW");
                        break;
                    }
                    case 3: {
                        outgoingMsg.addArgument("PHM");
                        break;
                    }
                    default: {
                        throw new MSNException(12);
                    }
                }
                outgoingMsg.addArgument(strTmp);
                this.sc.sendMSNPMessage(outgoingMsg);
            }
            catch (UnsupportedEncodingException e) {
                throw new MSNException(13);
            }
        } else {
            throw new MSNException(3);
        }
    }

    String getPhoneNumber(int nPhoneType) throws MSNException {
        if (this.isConnected()) {
            if (nPhoneType != 1 && nPhoneType != 2 && nPhoneType != 3) {
                throw new MSNException(12);
            }
            String strPhoneNumber = (String)this.hPhoneNumbers.get(new Integer(nPhoneType));
            return strPhoneNumber != null ? strPhoneNumber : "";
        }
        throw new MSNException(3);
    }

    void setMobileAuthorization(boolean bAuthorize) throws MSNException {
        OutgoingMessage outgoingMsg;
        if (this.isConnected()) {
            outgoingMsg = new OutgoingMessage(23, this.getTransactionID());
            outgoingMsg.addArgument("MOB");
            if (bAuthorize) {
                outgoingMsg.addArgument("Y");
            } else {
                outgoingMsg.addArgument("N");
            }
        } else {
            throw new MSNException(3);
        }
        this.sc.sendMSNPMessage(outgoingMsg);
    }

    boolean getMobileAuthorization() throws MSNException {
        if (this.isConnected()) {
            return this.bMobileAuthorization;
        }
        throw new MSNException(3);
    }

    void setMobileDeviceEnabled(boolean bEnableMobileDevice) throws MSNException {
        OutgoingMessage outgoingMsg;
        if (this.isConnected()) {
            outgoingMsg = new OutgoingMessage(23, this.getTransactionID());
            outgoingMsg.addArgument("MBE");
            if (bEnableMobileDevice) {
                outgoingMsg.addArgument("Y");
            } else {
                outgoingMsg.addArgument("N");
            }
        } else {
            throw new MSNException(3);
        }
        this.sc.sendMSNPMessage(outgoingMsg);
    }

    boolean getMobileDeviceEnabled() throws MSNException {
        if (this.isConnected()) {
            return this.bMobileDeviceEnabled;
        }
        throw new MSNException(3);
    }

    protected void requestSwitchboardSession() {
        OutgoingMessage msg = new OutgoingMessage(33, this.getTransactionID());
        msg.addArgument("SB");
        this.sc.sendMSNPMessage(msg);
    }

    protected synchronized void fireIncomingMessageEvent(String userName, String friendlyName, String message) {
        MessengerServerManager.getInstance().fireIncomingMessageEvent(userName, friendlyName, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendClientPing() {
        Object object = this.objPingLock;
        synchronized (object) {
            if (this.nClientPingCount >= 6) {
                System.err.println("NotificationServerManager.sendClientPing() - Closing connection with Notification Server by ping Timeout");
                this.clienPingThread.interrupt();
                this.sc.disconnect(true);
                this.nClientPingCount = 0;
            } else {
                System.err.println("NotificationServerManager.sendClientPing() - Sending client ping (KeepAlive)");
                OutgoingMessage msg = new OutgoingMessage(36);
                this.sc.sendMSNPMessage(msg);
                ++this.nClientPingCount;
            }
        }
    }

    private int getTransactionID() {
        ++this.transactionID;
        return this.transactionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivedQNG(IncomingMessage incomingMessage) {
        System.err.println("NotificationServerConnector.receivedQNG() - Received QNG command (KeepAlive response)");
        Object object = this.objPingLock;
        synchronized (object) {
            this.nClientPingCount = 0;
        }
    }

    private void receivedVER(IncomingMessage incomingMessage) {
        OutgoingMessage outgoingMsg = new OutgoingMessage(34, this.getTransactionID());
        String strArgument = "0x0409 winnt 5.1 i386 MSNMSGR 5.0.0540 MSMSGS " + this.userName;
        outgoingMsg.addArgument(strArgument);
        this.sc.sendMSNPMessage(outgoingMsg);
    }

    private void receivedCVR(IncomingMessage incomingMessage) {
        OutgoingMessage outgoingMsg = new OutgoingMessage(31, this.getTransactionID());
        outgoingMsg.addArgument("TWN");
        outgoingMsg.addArgument("I");
        outgoingMsg.addArgument(this.userName);
        this.sc.sendMSNPMessage(outgoingMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivedUSR(IncomingMessage incomingMessage) {
        block7: {
            try {
                String securityProtocol = incomingMessage.getSecurityProtocol();
                if (securityProtocol.equals(Message.commandToString(14))) {
                    SSLServerConnection sslConn = new SSLServerConnection("https://nexus.passport.com/rdr/pprdr.asp");
                    String strLoginSvr = sslConn.getPassportLoginServer();
                    String strTicket = sslConn.requestAuthorizationTicket(strLoginSvr, this.userName, this.password, incomingMessage.getChallengeHash());
                    if (strTicket == null) {
                        this.sc.disconnect(false);
                        return;
                    }
                    OutgoingMessage outgoingMsg = new OutgoingMessage(31, this.getTransactionID());
                    outgoingMsg.addArgument(Message.commandToString(14));
                    outgoingMsg.addArgument("S");
                    outgoingMsg.addArgument(strTicket);
                    this.sc.sendMSNPMessage(outgoingMsg);
                    break block7;
                }
                if (!securityProtocol.equals("OK")) break block7;
                NotificationServerConnector notificationServerConnector = this;
                synchronized (notificationServerConnector) {
                    this.notifyAll();
                }
                this.synchronizeContactList();
                MessengerServerManager.getInstance().fireLoginAccepted();
                this.clienPingThread.start();
            }
            catch (Exception e) {
                System.err.println("NotificationServerConnector.receivedUSR() - " + e);
                this.sc.disconnect(false);
            }
        }
    }

    private synchronized void receivedCHG(IncomingMessage incomingMessage) {
    }

    private void receivedCHL(IncomingMessage incomingMessage) {
        try {
            OutgoingMessage msg = new OutgoingMessage(24, this.getTransactionID());
            msg.addArgument("PROD0038W!61ZTF9");
            msg.addArgument("32");
            msg.addArgument("\r\n");
            msg.addArgument(NotificationServerConnector.MD5sum(incomingMessage.getChallengeHash() + MESSENGER_CHALLENGE_STRING));
            this.sc.sendMSNPMessage(msg);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private void receivedQRY(IncomingMessage incomingMessage) {
        System.err.println("NotificationServerConnector.receivedQRY() - QRY received");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivedXFR(IncomingMessage incomingMessage) {
        block6: {
            try {
                Object o;
                String referralType = incomingMessage.getReferralType();
                if (!referralType.equals("SB")) break block6;
                LinkedList linkedList = SwitchboardSessionConnector.queuedSessions;
                synchronized (linkedList) {
                    o = SwitchboardSessionConnector.queuedSessions.removeLast();
                }
                if (o == null) {
                    return;
                }
                SwitchboardSessionConnector ssc = (SwitchboardSessionConnector)o;
                String serverIP = incomingMessage.getServerIP();
                int serverPort = incomingMessage.getServerPort();
                String challengeHash = incomingMessage.getChallengeHash();
                String sessionID = "None";
                ssc.setSessionInfo(serverIP, serverPort, sessionID, challengeHash);
                ssc.setCalling(true);
                ssc.connectSession();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }

    private void receivedRNG(IncomingMessage incomingMessage) {
        try {
            String sessionID = incomingMessage.getSessionID();
            String buddyName = incomingMessage.getUserName();
            String challengeHash = incomingMessage.getChallengeHash();
            String serverIP = incomingMessage.getServerIP();
            int serverPort = incomingMessage.getServerPort();
            SwitchboardSessionConnector ssc = (SwitchboardSessionConnector)this.switchboardSessions.get(buddyName);
            if (ssc == null) {
                ssc = new SwitchboardSessionConnector(this.userName, buddyName, this);
                this.switchboardSessions.put(buddyName, ssc);
            }
            ssc.setSessionInfo(serverIP, serverPort, sessionID, challengeHash);
            ssc.setCalling(false);
            ssc.connectSession();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private void receivedREA(IncomingMessage incomingMessage) {
        try {
            String strFriendlyName = incomingMessage.getFriendlyName();
            MessengerServerManager.getInstance().fireContactChangeEvent(incomingMessage.getUserName(), 7, strFriendlyName.compareTo("") == 0 ? incomingMessage.getUserName() : strFriendlyName, incomingMessage.toString());
        }
        catch (NoSuchFieldException e) {
            System.err.println("NotificationServerConnector.receivedREA() - " + e);
        }
    }

    private void receivedILN(IncomingMessage incomingMessage) {
        try {
            Contact contact = this.getContactList().getContact(incomingMessage.getUserName());
            Capabilities capabilities = contact.getCapabilities();
            String strFriendlyName = incomingMessage.getFriendlyName();
            capabilities.setClientId(incomingMessage.getClientId());
            MessengerServerManager.getInstance().fireContactChangeEvent(incomingMessage.getUserName(), 7, strFriendlyName.compareTo("") == 0 ? incomingMessage.getUserName() : strFriendlyName, incomingMessage.toString());
            MessengerServerManager.getInstance().fireContactChangeEvent(incomingMessage.getUserName(), 6, incomingMessage.getStatus(), incomingMessage.toString());
            MessengerServerManager.getInstance().fireContactChangeEvent(incomingMessage.getUserName(), 8, capabilities, incomingMessage.toString());
        }
        catch (NoSuchFieldException e) {
            System.err.println("NotificationServerConnector.receiveILN() - " + e);
        }
        catch (MSNException e) {
            System.err.println("NotificationServerConnector.receiveILN() - " + e);
        }
    }

    private void receivedFLN(IncomingMessage incomingMessage) {
        try {
            MessengerServerManager.getInstance().fireContactChangeEvent(incomingMessage.getUserName(), 6, incomingMessage.getStatus(), incomingMessage.toString());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private void receivedNLN(IncomingMessage incomingMessage) {
        try {
            Contact contact = this.getContactList().getContact(incomingMessage.getUserName());
            Capabilities capabilities = contact.getCapabilities();
            String strFriendlyName = incomingMessage.getFriendlyName();
            capabilities.setClientId(incomingMessage.getClientId());
            MessengerServerManager.getInstance().fireContactChangeEvent(incomingMessage.getUserName(), 7, strFriendlyName.compareTo("") == 0 ? incomingMessage.getUserName() : strFriendlyName, incomingMessage.toString());
            MessengerServerManager.getInstance().fireContactChangeEvent(incomingMessage.getUserName(), 6, incomingMessage.getStatus(), incomingMessage.toString());
            MessengerServerManager.getInstance().fireContactChangeEvent(incomingMessage.getUserName(), 8, capabilities, incomingMessage.toString());
        }
        catch (NoSuchFieldException e) {
            System.err.println("NotificationServerConnector.receiveNLN() - " + e);
        }
        catch (MSNException e) {
            System.err.println("NotificationServerConnector.receiveNLN() - " + e);
        }
    }

    private void receivedBPR(IncomingMessage incomingMessage) {
        try {
            String newValue = incomingMessage.getValue();
            if (newValue == null) {
                return;
            }
            String property = incomingMessage.getProperty();
            if (property.equals("PHH")) {
                MessengerServerManager.getInstance().fireContactChangeEvent(incomingMessage.getUserName(), 1, newValue, incomingMessage.toString());
            } else if (property.equals("PHW")) {
                MessengerServerManager.getInstance().fireContactChangeEvent(incomingMessage.getUserName(), 2, newValue, incomingMessage.toString());
            } else if (property.equals("PHM")) {
                MessengerServerManager.getInstance().fireContactChangeEvent(incomingMessage.getUserName(), 3, newValue, incomingMessage.toString());
            } else if (property.equals("MOB")) {
                MessengerServerManager.getInstance().fireContactChangeEvent(incomingMessage.getUserName(), 4, newValue, incomingMessage.toString());
            }
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
    }

    private void receivedLST(IncomingMessage incomingMessage) {
        try {
            Contact contact = new Contact(incomingMessage.getUserName(), -1);
            String strFriendlyName = incomingMessage.getFriendlyName();
            contact.setFriendlyName(strFriendlyName.compareTo("") == 0 ? incomingMessage.getUserName() : strFriendlyName);
            contact.setGroups(incomingMessage.getGroups());
            contact.setListType(incomingMessage.getListType());
            this.contactList.addToContactList(contact);
            MessengerServerManager.getInstance().fireContactReceived(contact);
            System.out.println("NotificationServerConnector.receivedLST() - " + contact.toString());
        }
        catch (NoSuchFieldException e) {
            System.err.println("NotificationServerConnector.receivedLST() - " + e);
        }
    }

    private void receivedLSG(IncomingMessage incomingMessage) {
        ArrayList aGroups = incomingMessage.getGroups();
        int nGroupID = -1;
        if (aGroups != null) {
            Integer iGroupID = (Integer)aGroups.get(0);
            nGroupID = iGroupID;
            this.hGroups.put(iGroupID, incomingMessage.getGroupName());
            MessengerServerManager.getInstance().fireGroupReceived(iGroupID, incomingMessage.getGroupName());
        }
        System.out.println("NotificationServerConnector.receivedLSG() - " + incomingMessage.getGroupName() + " " + nGroupID);
    }

    private void receivedADG(IncomingMessage incomingMessage) {
        int nGroupId = incomingMessage.getGroupId();
        Integer iGroupId = new Integer(nGroupId);
        this.hGroups.put(iGroupId, incomingMessage.getGroupName());
        MessengerServerManager.getInstance().fireGroupAdded(nGroupId, incomingMessage.getGroupName());
        System.out.println("NotificationServerConnector.receivedADG() - " + incomingMessage.getGroupName() + " " + nGroupId);
    }

    private void receivedRMG(IncomingMessage incomingMessage) {
        int nGroupId = incomingMessage.getGroupId();
        Integer iGroupId = new Integer(nGroupId);
        String strGroupName = (String)this.hGroups.get(iGroupId);
        this.hGroups.remove(iGroupId);
        MessengerServerManager.getInstance().fireGroupRemoved(nGroupId, strGroupName);
        System.out.println("NotificationServerConnector.receivedRMG() - " + strGroupName + " " + nGroupId);
    }

    private void receivedREG(IncomingMessage incomingMessage) {
        int nGroupId = incomingMessage.getGroupId();
        Integer iGroupId = new Integer(nGroupId);
        this.hGroups.put(iGroupId, incomingMessage.getGroupName());
        MessengerServerManager.getInstance().fireGroupRenamed(nGroupId, incomingMessage.getGroupName());
        System.out.println("NotificationServerConnector.receivedREG() - " + incomingMessage.getGroupName() + " " + nGroupId);
    }

    private void receivedADD(IncomingMessage incomingMessage) {
        try {
            Contact contact;
            int nListType;
            int nGroupId = 0;
            boolean bAlreadyInContactList = false;
            try {
                nListType = (Integer)incomingMessage.getListType().values().toArray()[0];
            }
            catch (Exception ex) {
                System.err.println("NotificationServerConnector.receivedADD() - Invalid list type assuming FORWARD_LIST");
                nListType = 3;
            }
            try {
                contact = this.contactList.getContact(incomingMessage.getUserName());
                bAlreadyInContactList = true;
            }
            catch (MSNException e) {
                contact = new Contact(incomingMessage.getUserName(), nListType);
            }
            try {
                if (nListType == 3) {
                    System.err.println("NotificationServerConnector.receivedADD() - Adding to group " + nListType);
                    nGroupId = incomingMessage.getGroupId();
                    contact.addToGroup(nGroupId);
                }
            }
            catch (MSNException ex) {
                System.err.println("NotificationServerConnector.receivedADD() - " + ex);
                return;
            }
            if (bAlreadyInContactList) {
                bAlreadyInContactList = contact.isInListType(3);
            }
            contact.addToListType(nListType);
            if (!bAlreadyInContactList) {
                String strFriendlyName = incomingMessage.getFriendlyName();
                contact.setFriendlyName(strFriendlyName.compareTo("") == 0 ? incomingMessage.getUserName() : strFriendlyName);
                this.contactList.addToContactList(contact);
                MessengerServerManager.getInstance().fireContactAdded(contact);
            }
            System.out.println("NotificationServerConnector.receivedADD() - " + contact + " GroupId[" + nGroupId + "]");
        }
        catch (NoSuchFieldException e) {
            System.err.println("NotificationServerConnector.receivedADD() - " + e);
        }
    }

    private void receivedREM(IncomingMessage incomingMessage) {
        try {
            Contact contact = this.contactList.getContact(incomingMessage.getUserName());
            int nListType = (Integer)incomingMessage.getListType().values().toArray()[0];
            contact.removeFromListType(nListType);
            if (contact.getGroups().size() > 1 && nListType == 3) {
                try {
                    int nGroupId = incomingMessage.getGroupId();
                    contact.removeFromGroup(nGroupId);
                }
                catch (MSNException ex) {
                    System.err.println("NotificationServerConnector.receivedREM() - " + ex);
                }
            } else {
                if (nListType == 3) {
                    this.contactList.removeFromContactList(contact);
                }
                MessengerServerManager.getInstance().fireContactRemoved(contact);
            }
            contact = (Contact)this.hBlockingContacts.get(incomingMessage.getUserName());
            if (contact != null) {
                System.out.println("NotificationServerConnector.receivedREM() - Blocking contact " + incomingMessage.getUserName());
                this.hBlockingContacts.remove(contact.getUserName());
                contact.removeFromListType(0);
                contact.addToListType(1);
                this.addToContactList(contact);
            } else {
                contact = (Contact)this.hAllowingContacts.get(incomingMessage.getUserName());
                if (contact != null) {
                    System.out.println("NotificationServerConnector.receivedREM() - Allowing contact " + incomingMessage.getUserName());
                    this.hAllowingContacts.remove(contact.getUserName());
                    contact.removeFromListType(1);
                    contact.addToListType(0);
                    this.addToContactList(contact);
                }
            }
            System.out.println("NotificationServerConnector.receivedREM() - " + incomingMessage.getUserName());
        }
        catch (NoSuchFieldException e) {
            System.err.println("NotificationServerConnector.receivedREM() - " + e);
        }
        catch (MSNException ex) {
            System.err.println("NotificationServerConnector.receivedREM() - " + ex);
        }
    }

    private void receivedBLP(IncomingMessage incomingMessage) {
        System.err.println("NotificationServerConnector.receivedBLP()");
        try {
            this.bPrivacyMode = incomingMessage.getPrivacyMode();
        }
        catch (NoSuchFieldException e) {
            System.err.println("NotificationServerConnector.receivedBLP() - " + e);
        }
    }

    private void receivedGTC(IncomingMessage incomingMessage) {
        System.err.println("NotificationServerConnector.receivedGTC()");
        try {
            this.bReverseListBehaviour = incomingMessage.getReverseListBehaviour();
        }
        catch (NoSuchFieldException e) {
            System.err.println("NotificationServerConnector.receivedGTC() - " + e);
        }
    }

    private void receivedPRP(IncomingMessage incomingMessage) {
        System.err.println("NotificationServerConnector.receivedPRP()");
        try {
            String strParm = incomingMessage.getPRPParameter();
            if (!incomingMessage.isMOB() && !incomingMessage.isMBE()) {
                Integer nPhoneType = Integer.getInteger(String.valueOf(incomingMessage.getPhoneType()));
                this.hPhoneNumbers.put(nPhoneType, strParm);
            } else if (incomingMessage.isMOB()) {
                this.bMobileAuthorization = strParm.compareTo("Y") == 0;
            } else {
                this.bMobileDeviceEnabled = strParm.compareTo("Y") == 0;
            }
        }
        catch (NoSuchFieldException e) {
            System.err.println("NotificationServerConnector.receivedPRP() - " + e);
        }
    }

    private void receivedMSG(IncomingMessage incomingMessage) {
        System.err.println("NotificationServerConnector.receivedMSG()");
        try {
            this.profile.parseBody(incomingMessage);
        }
        catch (ParseException e) {
            System.err.println("NotificationServerConnector.receivedMSG() - " + e);
        }
    }

    private void receivedSDC(IncomingMessage incomingMessage) {
    }

    private void receivedSYN(IncomingMessage incomingMessage) {
        System.err.println("NotificationServerConnector.receivedSYN()");
        try {
            long nContactListVersion = incomingMessage.getContactListVersion();
            this.contactList.setContactListVersion(nContactListVersion);
        }
        catch (NoSuchFieldException e) {
            System.err.println(e);
        }
        if (!this.bLoggedIn) {
            try {
                this.setStatus(this.strUserStatus);
                this.bLoggedIn = true;
            }
            catch (MSNException e) {
                System.err.println("NotificationServerConnector.receivedSYN()" + e);
            }
        }
    }

    private void receivedError(IncomingMessage incomingMessage) {
        try {
            MessengerServerManager.getInstance().fireErrorReceived(incomingMessage.getErrorCode());
        }
        catch (NoSuchFieldException e) {
            System.err.println("NotificationServerConnector.receivedError() - " + e);
        }
    }

    private static String MD5sum(String toHash) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return NotificationServerConnector.byteArrayToHexString(md.digest(toHash.getBytes()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "";
        }
    }

    private static String byteArrayToHexString(byte[] bytes) {
        String hexString = "";
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            hexString = hexString + NotificationServerConnector.byteToHexString(b & 0xF, b >> 4 & 0xF);
        }
        return hexString;
    }

    private static String byteToHexString(int nib1, int nib2) {
        char char2;
        char[] chars = new char[2];
        char char1 = NotificationServerConnector.nibbleToChar(nib1);
        chars[0] = char2 = NotificationServerConnector.nibbleToChar(nib2);
        chars[1] = char1;
        return new String(chars);
    }

    private static char nibbleToChar(int nibble) {
        if (nibble < 10) {
            return Integer.toString(nibble).charAt(0);
        }
        int nib = nibble - 10;
        return (char)((char)nib + 97);
    }

    public void incomingMSNPMessage(IncomingMessage incomingMessage) {
        switch (incomingMessage.getType()) {
            case 32: {
                this.receivedVER(incomingMessage);
                break;
            }
            case 34: {
                this.receivedCVR(incomingMessage);
                break;
            }
            case 31: {
                this.receivedUSR(incomingMessage);
                break;
            }
            case 9: {
                this.receivedCHG(incomingMessage);
                break;
            }
            case 10: {
                this.receivedCHL(incomingMessage);
                break;
            }
            case 24: {
                this.receivedQRY(incomingMessage);
                break;
            }
            case 33: {
                this.receivedXFR(incomingMessage);
                break;
            }
            case 29: {
                this.receivedRNG(incomingMessage);
                break;
            }
            case 25: {
                this.receivedREA(incomingMessage);
                break;
            }
            case 13: {
                this.receivedILN(incomingMessage);
                break;
            }
            case 6: {
                this.receivedBPR(incomingMessage);
                break;
            }
            case 21: {
                this.receivedNLN(incomingMessage);
                break;
            }
            case 11: {
                this.receivedFLN(incomingMessage);
                break;
            }
            case 30: {
                this.receivedSYN(incomingMessage);
                break;
            }
            case 18: {
                this.receivedLST(incomingMessage);
                break;
            }
            case 17: {
                this.receivedLSG(incomingMessage);
                break;
            }
            case 19: {
                this.receivedMSG(incomingMessage);
                break;
            }
            case 3: {
                this.receivedADG(incomingMessage);
                break;
            }
            case 28: {
                this.receivedRMG(incomingMessage);
                break;
            }
            case 26: {
                this.receivedREG(incomingMessage);
                break;
            }
            case 2: {
                this.receivedADD(incomingMessage);
                break;
            }
            case 27: {
                this.receivedREM(incomingMessage);
                break;
            }
            case 35: {
                this.receivedSDC(incomingMessage);
                break;
            }
            case 5: {
                this.receivedBLP(incomingMessage);
                break;
            }
            case 12: {
                this.receivedGTC(incomingMessage);
                break;
            }
            case 23: {
                this.receivedPRP(incomingMessage);
                break;
            }
            case 37: {
                this.receivedQNG(incomingMessage);
                break;
            }
            case 38: {
                this.receivedError(incomingMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverDisconnected() {
        System.out.println("NotificationServerConnector.serverDisconnected() - Notification server disconnected...");
        NotificationServerConnector notificationServerConnector = this;
        synchronized (notificationServerConnector) {
            try {
                this.notifyAll();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
        if (!this.bLoggedIn) {
            MessengerServerManager.getInstance().fireLoginError();
        } else {
            this.clienPingThread.interrupt();
        }
        this.bLoggedIn = false;
        MessengerServerManager.getInstance().fireServerDisconnected();
    }

    public void run() {
        System.err.println("NotificationServerConnector.run() - Processing PNG command");
        try {
            while (true) {
                this.sendClientPing();
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException e) {
            System.err.println("NotificationServerConnector.run() - Stopping Client Ping Thread processor");
            return;
        }
    }

    public static void main(final String[] args) {
        DispatchServerConnector ds = new DispatchServerConnector();
        ArrayList serverInfo = ds.getNSServer(args[0]);
        final NotificationServerConnector nsc = new NotificationServerConnector((String)serverInfo.get(0), (Integer)serverInfo.get(1));
        nsc.signIn(args[0], args[1], "NLN", false);
        Thread t = new Thread(){

            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    nsc.sendMessage(args[2], "what's up?");
                    nsc.sendMessage(args[3], "i rock house");
                }
                catch (MSNException e) {
                    System.err.println("NotificationServerConnector.main() - " + e);
                }
            }
        };
        t.start();
        Thread t2 = new Thread(){

            public void run() {
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    nsc.sendMessage(args[2], "the second message");
                    nsc.sendMessage(args[3], "you got nothin'");
                }
                catch (MSNException e) {
                    System.err.println("NotificationServerConnector.main() - " + e);
                }
            }
        };
        t2.start();
    }
}

