/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.netaddr;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class BsdLocalhostRetriever {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetAddress getLocalSocketAddress(InetSocketAddress dest) throws IOException {
        sockaddr addr = sockaddr.create(dest);
        int fd = LibC.INSTANCE.socket(addr.getFamily(), 2, 0);
        if (fd == -1) {
            throw new LibC.CException();
        }
        try {
            IntByReference size;
            int err = LibC.INSTANCE.connect(fd, addr, addr.getSize());
            if (err != 0) {
                throw new LibC.CException();
            }
            sockaddr local = addr.createEmpty();
            err = LibC.INSTANCE.getsockname(fd, local, size = new IntByReference(local.getSize()));
            if (err != 0) {
                throw new LibC.CException();
            }
            InetAddress inetAddress = local.getAddress();
            return inetAddress;
        }
        finally {
            LibC.INSTANCE.close(fd);
        }
    }

    public static final class sockaddr_in6
    extends sockaddr {
        public byte sin6_len;
        public byte sin6_family = (byte)30;
        public short sin6_port;
        public int sin6_flowinfo;
        public byte[] sin6_addr = new byte[16];
        public int sin_scope_id;

        @Override
        public int getFamily() {
            return 30;
        }

        @Override
        public sockaddr createEmpty() {
            sockaddr_in6 v6 = new sockaddr_in6();
            v6.sin6_len = (byte)Native.getNativeSize(((Object)((Object)v6)).getClass(), (Object)((Object)v6));
            return v6;
        }

        @Override
        public InetAddress getAddress() throws UnknownHostException {
            return InetAddress.getByAddress(this.sin6_addr);
        }
    }

    public static final class sockaddr_in
    extends sockaddr {
        public byte sin_len;
        public byte sin_family = (byte)2;
        public short sin_port;
        public byte[] sin_addr = new byte[4];
        public byte[] sin_zero = new byte[8];

        @Override
        public int getFamily() {
            return 2;
        }

        @Override
        public sockaddr createEmpty() {
            sockaddr_in v4 = new sockaddr_in();
            v4.sin_len = (byte)Native.getNativeSize(((Object)((Object)v4)).getClass(), (Object)((Object)v4));
            return v4;
        }

        @Override
        public InetAddress getAddress() throws UnknownHostException {
            return InetAddress.getByAddress(this.sin_addr);
        }
    }

    public static abstract class sockaddr
    extends Structure {
        public static sockaddr create(InetSocketAddress socket) {
            InetAddress address = socket.getAddress();
            if (address instanceof Inet4Address) {
                sockaddr_in v4 = new sockaddr_in();
                v4.sin_addr = address.getAddress();
                v4.sin_port = (short)socket.getPort();
                v4.sin_len = (byte)Native.getNativeSize(((Object)((Object)v4)).getClass(), (Object)((Object)v4));
                return v4;
            }
            if (address instanceof Inet6Address) {
                sockaddr_in6 v6 = new sockaddr_in6();
                v6.sin6_addr = address.getAddress();
                v6.sin6_port = (short)socket.getPort();
                v6.sin6_len = (byte)Native.getNativeSize(((Object)((Object)v6)).getClass(), (Object)((Object)v6));
                return v6;
            }
            throw new IllegalArgumentException("Unsupported address type");
        }

        public abstract int getFamily();

        public abstract sockaddr createEmpty();

        public abstract InetAddress getAddress() throws UnknownHostException;

        public int getSize() {
            return Native.getNativeSize(((Object)((Object)this)).getClass(), (Object)((Object)this));
        }
    }

    public static interface LibC
    extends Library {
        public static final LibC INSTANCE = (LibC)Native.loadLibrary((String)"c", LibC.class);
        public static final int AF_INET = 2;
        public static final int AF_INET6 = 30;
        public static final int SOCK_DGRAM = 2;

        public int socket(int var1, int var2, int var3);

        public int connect(int var1, sockaddr var2, int var3);

        public int getsockname(int var1, sockaddr var2, IntByReference var3);

        public int close(int var1);

        public String strerror(int var1);

        public static class CException
        extends IOException {
            private static final long serialVersionUID = 2988769925077172885L;

            public CException() {
                super(INSTANCE.strerror(Native.getLastError()));
            }
        }
    }
}

