/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.transform;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.transform.RawPacketCache;

public class CachingTransformer
extends SinglePacketTransformer
implements RawPacketCache,
TransformEngine {
    private static final Logger logger = Logger.getLogger(CachingTransformer.class);
    private static int SIZE_MILLIS = 300;
    private static int RTP_CLOCK_RATE = 90000;
    private static int SIZE_RTP_CLOCK_TICKS = RTP_CLOCK_RATE / 1000 * SIZE_MILLIS;
    private static int MAX_SSRC_COUNT = 10;
    private static int MAX_SIZE_PACKETS = 200;
    private static int POOL_SIZE = 100;
    private static int SSRC_TIMEOUT_MILLIS = SIZE_MILLIS + 50;
    private Queue<RawPacket> pool = new LinkedBlockingQueue<RawPacket>(POOL_SIZE);
    private final Object sizesSyncRoot = new Object();
    private int sizeInBytes = 0;
    private int maxSizeInBytes = 0;
    private int sizeInPackets = 0;
    private int maxSizeInPackets = 0;
    private AtomicInteger totalHits = new AtomicInteger(0);
    private AtomicInteger totalMisses = new AtomicInteger(0);
    private AtomicInteger totalPacketsAdded = new AtomicInteger(0);
    private boolean closed = false;
    private final Map<Long, Cache> caches = new HashMap<Long, Cache>();
    private final CleanerThread cleanerThread = new CleanerThread();

    private static boolean lessThanTS(long a, long b) {
        if (a == b) {
            return false;
        }
        if (a > b) {
            return a - b >= 0x80000000L;
        }
        return b - a < 0x80000000L;
    }

    public CachingTransformer() {
        this.cleanerThread.start();
    }

    public RawPacket transform(RawPacket pkt) {
        if (!this.closed && pkt != null && pkt.getVersion() == 2) {
            this.cachePacket(pkt);
        }
        return pkt;
    }

    public RawPacket reverseTransform(RawPacket pkt) {
        return pkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        logger.info((Object)("Closing. Maximum size reached: " + this.maxSizeInBytes + " bytes, " + this.maxSizeInPackets + " packets; " + this.totalHits + " hits, " + this.totalMisses + " misses (" + (this.totalHits.get() + this.totalMisses.get()) + " total requests); " + this.totalPacketsAdded.get() + " total packets added."));
        Map<Long, Cache> map = this.caches;
        synchronized (map) {
            this.caches.clear();
        }
        this.cleanerThread.notify();
    }

    public RawPacket get(long ssrc, int seq) {
        RawPacket pkt;
        Cache cache = this.getCache(ssrc & 0xFFFFFFFFL, false);
        RawPacket rawPacket = pkt = cache != null ? cache.get(seq) : null;
        if (pkt != null) {
            this.totalHits.incrementAndGet();
        } else {
            this.totalMisses.incrementAndGet();
        }
        return pkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getCache(long ssrc, boolean create) {
        Map<Long, Cache> map = this.caches;
        synchronized (map) {
            Cache cache = this.caches.get(ssrc);
            if (cache == null && create) {
                if (this.caches.size() < MAX_SSRC_COUNT) {
                    cache = new Cache();
                    this.caches.put(ssrc, cache);
                } else {
                    logger.warn((Object)("Not creating a new cache for SSRC " + ssrc + ": too many SSRCs already cached."));
                }
            }
            return cache;
        }
    }

    private void cachePacket(RawPacket pkt) {
        Cache cache = this.getCache((long)pkt.getSSRC() & 0xFFFFFFFFL, true);
        if (cache != null) {
            cache.insert(pkt);
            this.totalPacketsAdded.incrementAndGet();
        }
    }

    private RawPacket getFreePacket(int len) {
        RawPacket pkt = this.pool.poll();
        if (pkt == null) {
            pkt = new RawPacket(new byte[len], 0, 0);
        }
        if (pkt.getBuffer() == null || pkt.getBuffer().length < len) {
            pkt.setBuffer(new byte[len]);
        }
        pkt.setOffset(0);
        pkt.setLength(0);
        return pkt;
    }

    public PacketTransformer getRTPTransformer() {
        return this;
    }

    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    private class CleanerThread
    extends Thread {
        private CleanerThread() {
            this.setDaemon(true);
            this.setName(CleanerThread.class.getCanonicalName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!CachingTransformer.this.closed) {
                Object object = CachingTransformer.this.caches;
                synchronized (object) {
                    long now = System.currentTimeMillis();
                    Iterator iter = CachingTransformer.this.caches.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        Cache cache = (Cache)entry.getValue();
                        if (cache.lastInsertTime + (long)SSRC_TIMEOUT_MILLIS >= now) continue;
                        logger.debug((Object)("Removing cache for SSRC " + entry.getKey()));
                        cache.empty();
                        iter.remove();
                    }
                }
                try {
                    object = this;
                    synchronized (object) {
                        this.wait(10000L);
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            logger.debug((Object)"CleanerThread done.");
        }
    }

    private class Cache {
        private TreeMap<Integer, RawPacket> cache = new TreeMap();
        private long lastInsertTime = -1L;
        private int ROC = 0;
        private int s_l = -1;

        private Cache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void insert(RawPacket pkt) {
            int len = pkt.getLength();
            RawPacket cachePacket = CachingTransformer.this.getFreePacket(len);
            System.arraycopy(pkt.getBuffer(), pkt.getOffset(), cachePacket.getBuffer(), 0, len);
            cachePacket.setLength(len);
            int index = this.calculateIndex(pkt.getSequenceNumber());
            this.cache.put(index, cachePacket);
            Object object = CachingTransformer.this.sizesSyncRoot;
            synchronized (object) {
                CachingTransformer.this.sizeInPackets++;
                CachingTransformer.this.sizeInBytes += len;
                if (CachingTransformer.this.sizeInPackets > CachingTransformer.this.maxSizeInPackets) {
                    CachingTransformer.this.maxSizeInPackets = CachingTransformer.this.sizeInPackets;
                }
                if (CachingTransformer.this.sizeInBytes > CachingTransformer.this.maxSizeInBytes) {
                    CachingTransformer.this.maxSizeInBytes = CachingTransformer.this.sizeInBytes;
                }
            }
            this.lastInsertTime = System.currentTimeMillis();
            this.clean();
        }

        private int calculateIndex(int seq) {
            if (this.s_l == -1) {
                this.s_l = seq;
                return seq;
            }
            int v = this.ROC;
            if (this.s_l < 32768) {
                if (seq - this.s_l > 32768) {
                    v = (int)((long)(this.ROC - 1) % 0x100000000L);
                } else if (this.s_l - 65536 > seq) {
                    v = (int)((long)(this.ROC + 1) % 0x100000000L);
                }
            }
            if (v == this.ROC && seq > this.s_l) {
                this.s_l = seq;
            } else if ((long)v == (long)(this.ROC + 1) % 0x100000000L) {
                this.s_l = seq;
                this.ROC = v;
            }
            return seq + v * 65536;
        }

        private synchronized RawPacket get(int seq) {
            RawPacket pkt = this.cache.get(seq + this.ROC * 65536);
            if (pkt == null && this.ROC > 0) {
                pkt = this.cache.get(seq + (this.ROC - 1) * 65536);
            }
            return pkt == null ? null : new RawPacket((byte[])pkt.getBuffer().clone(), pkt.getOffset(), pkt.getLength());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void clean() {
            int size = this.cache.size();
            if (size <= 0) {
                return;
            }
            long lastTimestamp = this.cache.lastEntry().getValue().getTimestamp();
            long cleanBefore = this.getCleanBefore(lastTimestamp);
            Iterator<Map.Entry<Integer, RawPacket>> iter = this.cache.entrySet().iterator();
            int removesPackets = 0;
            int removedBytes = 0;
            while (iter.hasNext()) {
                RawPacket pkt = iter.next().getValue();
                if (size > MAX_SIZE_PACKETS) {
                    --size;
                } else if (CachingTransformer.lessThanTS(cleanBefore, pkt.getTimestamp())) break;
                iter.remove();
                removedBytes += pkt.getLength();
                ++removesPackets;
                CachingTransformer.this.pool.offer(pkt);
            }
            Object object = CachingTransformer.this.sizesSyncRoot;
            synchronized (object) {
                CachingTransformer.this.sizeInBytes -= removedBytes;
                CachingTransformer.this.sizeInPackets -= removesPackets;
            }
        }

        private synchronized void empty() {
            for (RawPacket pkt : this.cache.values()) {
                CachingTransformer.this.pool.offer(pkt);
            }
            this.cache.clear();
        }

        private long getCleanBefore(long ts) {
            return (ts + 0x100000000L - (long)SIZE_RTP_CLOCK_TICKS) % 0x100000000L;
        }
    }
}

