/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceTcpSocketWrapper;
import org.ice4j.socket.IceUdpSocketWrapper;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.dtls.DtlsControlImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsPacketTransformer;
import org.jitsi.impl.neomedia.transform.dtls.DtlsTransformEngine;
import org.jitsi.impl.osgi.framework.AsyncExecutor;
import org.jitsi.sctp4j.NetworkLink;
import org.jitsi.sctp4j.Sctp;
import org.jitsi.sctp4j.SctpDataCallback;
import org.jitsi.sctp4j.SctpNotification;
import org.jitsi.sctp4j.SctpSocket;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.util.ExecutorUtils;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.IceUdpTransportManager;
import org.jitsi.videobridge.TransportManager;
import org.jitsi.videobridge.WebRtcDataStream;
import org.jitsi.videobridge.WebRtcDataStreamListener;

public class SctpConnection
extends Channel
implements SctpDataCallback,
SctpSocket.NotificationListener {
    private static int debugIdGen = -1;
    private static final int DTLS_BUFFER_SIZE = 2048;
    private static final boolean LOG_SCTP_PACKETS = false;
    private static final Logger logger = Logger.getLogger(SctpConnection.class);
    private static final int MSG_CHANNEL_ACK = 2;
    private static final byte[] MSG_CHANNEL_ACK_BYTES = new byte[]{2};
    private static final int MSG_OPEN_CHANNEL = 3;
    private static final int SCTP_BUFFER_SIZE = 2035;
    private static final ExecutorService threadPool = ExecutorUtils.newCachedThreadPool((boolean)true, (String)SctpConnection.class.getName());
    static final int WEB_RTC_PPID_BIN = 53;
    static final int WEB_RTC_PPID_CTRL = 50;
    static final int WEB_RTC_PPID_STRING = 51;
    private static final String WEBRTC_DATA_CHANNEL_PROTOCOL = "http://jitsi.org/protocols/colibri";
    private boolean acceptedIncomingConnection;
    private boolean assocIsUp;
    private final Map<Integer, WebRtcDataStream> channels = new HashMap<Integer, WebRtcDataStream>();
    private final int debugId;
    private final AsyncExecutor<Runnable> eventDispatcher = new AsyncExecutor(15L, TimeUnit.MILLISECONDS);
    private IceSocketWrapper iceSocket;
    private final List<WebRtcDataStreamListener> listeners = new ArrayList<WebRtcDataStreamListener>();
    private final int remoteSctpPort;
    private SctpSocket sctpSocket;
    private boolean started;

    private static synchronized int generateDebugId() {
        return debugIdGen += 2;
    }

    public SctpConnection(String id, Content content, Endpoint endpoint, int remoteSctpPort, String channelBundleId, Boolean initiator) throws Exception {
        super(content, id, channelBundleId, "urn:xmpp:jingle:transports:ice-udp:1", initiator);
        this.setEndpoint(endpoint.getID());
        this.remoteSctpPort = remoteSctpPort;
        this.debugId = SctpConnection.generateDebugId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChannelListener(WebRtcDataStreamListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<WebRtcDataStreamListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void closeStream() throws IOException {
        try {
            SctpConnection sctpConnection = this;
            synchronized (sctpConnection) {
                this.assocIsUp = false;
                this.acceptedIncomingConnection = false;
                if (this.sctpSocket != null) {
                    this.sctpSocket.close();
                    this.sctpSocket = null;
                }
            }
            Object var4_3 = null;
            if (this.iceSocket == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.iceSocket == null) throw throwable;
            throw throwable;
        }
    }

    protected TransportManager createTransportManager(String xmlNamespace) throws IOException {
        if ("urn:xmpp:jingle:transports:ice-udp:1".equals(xmlNamespace)) {
            Content content = this.getContent();
            return new IceUdpTransportManager(content.getConference(), this.isInitiator(), 1, content.getName());
        }
        if ("urn:xmpp:jingle:transports:raw-udp:1".equals(xmlNamespace)) {
            throw new IllegalArgumentException("Unsupported Jingle transport " + xmlNamespace);
        }
        throw new IllegalArgumentException("Unsupported Jingle transport " + xmlNamespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        try {
            this.eventDispatcher.shutdown();
            Object var2_1 = null;
            super.expire();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.expire();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebRtcDataStreamListener[] getChannelListeners() {
        WebRtcDataStreamListener[] ls;
        List<WebRtcDataStreamListener> list = this.listeners;
        synchronized (list) {
            ls = this.listeners.isEmpty() ? null : this.listeners.toArray(new WebRtcDataStreamListener[this.listeners.size()]);
        }
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebRtcDataStream getDefaultDataStream() throws IOException {
        WebRtcDataStream def;
        SctpConnection sctpConnection = this;
        synchronized (sctpConnection) {
            if (this.sctpSocket == null) {
                def = null;
            } else {
                def = this.channels.get(0);
                if (def == null) {
                    def = this.openChannel(0, 0, 0L, 0, "default");
                }
            }
        }
        return def;
    }

    public boolean isReady() {
        return this.assocIsUp && this.acceptedIncomingConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeStartStream() throws IOException {
        final StreamConnector connector = this.getStreamConnector();
        if (connector == null) {
            return;
        }
        SctpConnection sctpConnection = this;
        synchronized (sctpConnection) {
            if (this.started) {
                return;
            }
            threadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block8: {
                        Sctp.init();
                        SctpConnection.this.runOnDtlsTransport(connector);
                        Object var3_1 = null;
                        try {
                            Sctp.finish();
                        }
                        catch (IOException e2) {
                            logger.error((Object)"Failed to shutdown SCTP stack", (Throwable)e2);
                        }
                        break block8;
                        {
                            catch (IOException e) {
                                logger.error((Object)e, (Throwable)e);
                                Object var3_2 = null;
                                try {
                                    Sctp.finish();
                                }
                                catch (IOException e2) {
                                    logger.error((Object)"Failed to shutdown SCTP stack", (Throwable)e2);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            try {
                                Sctp.finish();
                            }
                            catch (IOException e2) {
                                logger.error((Object)"Failed to shutdown SCTP stack", (Throwable)e2);
                            }
                            throw throwable;
                        }
                    }
                }
            });
            this.started = true;
        }
    }

    private void notifyChannelOpened(final WebRtcDataStream dataChannel) {
        if (!this.isExpired()) {
            this.eventDispatcher.execute(new Runnable(){

                public void run() {
                    SctpConnection.this.notifyChannelOpenedInEventDispatcher(dataChannel);
                }
            });
        }
    }

    private void notifyChannelOpenedInEventDispatcher(WebRtcDataStream dataChannel) {
        WebRtcDataStreamListener[] ls;
        if (!this.isExpired() && (ls = this.getChannelListeners()) != null) {
            for (WebRtcDataStreamListener l : ls) {
                l.onChannelOpened(this, dataChannel);
            }
        }
    }

    private void notifySctpConnectionReady() {
        if (!this.isExpired()) {
            this.eventDispatcher.execute(new Runnable(){

                public void run() {
                    SctpConnection.this.notifySctpConnectionReadyInEventDispatcher();
                }
            });
        }
    }

    private void notifySctpConnectionReadyInEventDispatcher() {
        WebRtcDataStreamListener[] ls;
        if (!this.isExpired() && this.isReady() && (ls = this.getChannelListeners()) != null) {
            for (WebRtcDataStreamListener l : ls) {
                l.onSctpConnectionReady(this);
            }
        }
    }

    private synchronized void onCtrlPacket(byte[] data, int sid) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int messageType = 0xFF & buffer.get();
        if (messageType == 2) {
            WebRtcDataStream channel;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.getEndpoint().getID() + " ACK received SID: " + sid));
            }
            if ((channel = this.channels.get(sid)) != null) {
                if (!channel.isAcknowledged()) {
                    channel.ackReceived();
                    this.notifyChannelOpened(channel);
                } else {
                    logger.warn((Object)("Redundant ACK received for SID: " + sid));
                }
            } else {
                logger.error((Object)("No channel exists on sid: " + sid));
            }
        } else if (messageType == 3) {
            String protocol;
            String label;
            int channelType = 0xFF & buffer.get();
            int priority = 0xFFFF & buffer.getShort();
            long reliability = 0xFFFFFFFFL & (long)buffer.getInt();
            int labelLength = 0xFFFF & buffer.getShort();
            int protocolLength = 0xFFFF & buffer.getShort();
            if (labelLength == 0) {
                label = "";
            } else {
                byte[] labelBytes = new byte[labelLength];
                buffer.get(labelBytes);
                label = new String(labelBytes, "UTF-8");
            }
            if (protocolLength == 0) {
                protocol = "";
            } else {
                byte[] protocolBytes = new byte[protocolLength];
                buffer.get(protocolBytes);
                protocol = new String(protocolBytes, "UTF-8");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("!!! " + this.getEndpoint().getID() + " data channel open request on SID: " + sid + " type: " + channelType + " prio: " + priority + " reliab: " + reliability + " label: " + label + " proto: " + protocol));
            }
            if (this.channels.containsKey(sid)) {
                logger.error((Object)("Channel on sid: " + sid + " already exists"));
            }
            WebRtcDataStream newChannel = new WebRtcDataStream(this.sctpSocket, sid, label, true);
            this.channels.put(sid, newChannel);
            this.sendOpenChannelAck(sid);
            this.notifyChannelOpened(newChannel);
        } else {
            logger.error((Object)("Unexpected ctrl msg type: " + messageType));
        }
    }

    protected void onEndpointChanged(Endpoint oldValue, Endpoint newValue) {
        super.onEndpointChanged(oldValue, newValue);
        if (oldValue != null) {
            oldValue.setSctpConnection(null);
        }
        if (newValue != null) {
            newValue.setSctpConnection(this);
        }
    }

    public synchronized void onSctpNotification(SctpSocket socket, SctpNotification notification) {
        block12: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("socket=" + socket + "; notification=" + notification));
            }
            block1 : switch (notification.sn_type) {
                case 1: {
                    SctpNotification.AssociationChange assocChange = (SctpNotification.AssociationChange)notification;
                    switch (assocChange.state) {
                        case 1: {
                            if (!this.assocIsUp) {
                                boolean wasReady = this.isReady();
                                this.assocIsUp = true;
                                if (this.isReady() && !wasReady) {
                                    this.notifySctpConnectionReady();
                                    break block1;
                                }
                            }
                            break block12;
                        }
                        case 2: 
                        case 4: 
                        case 5: {
                            try {
                                this.closeStream();
                                break block1;
                            }
                            catch (IOException e) {
                                logger.error((Object)"Error closing SCTP socket", (Throwable)e);
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSctpPacket(byte[] data, int sid, int ssn, int tsn, long ppid, int context, int flags) {
        if (ppid == 50L) {
            try {
                this.onCtrlPacket(data, sid);
            }
            catch (IOException e) {
                logger.error((Object)"IOException when processing ctrl packet", (Throwable)e);
            }
        } else if (ppid == 51L || ppid == 53L) {
            WebRtcDataStream channel;
            SctpConnection sctpConnection = this;
            synchronized (sctpConnection) {
                channel = this.channels.get(sid);
            }
            if (channel == null) {
                logger.error((Object)("No channel found for sid: " + sid));
                return;
            }
            if (ppid == 51L) {
                String str;
                String charsetName = "UTF-8";
                try {
                    str = new String(data, charsetName);
                }
                catch (UnsupportedEncodingException uee) {
                    logger.error((Object)("Unsupported charset encoding/name " + charsetName), (Throwable)uee);
                    str = null;
                }
                channel.onStringMsg(str);
            } else {
                channel.onBinaryMsg(data);
            }
        } else {
            logger.warn((Object)("Got message on unsupported PPID: " + ppid));
        }
    }

    public synchronized WebRtcDataStream openChannel(int type, int prio, long reliab, int sid, String label) throws IOException {
        int sentCount;
        int labelByteLength;
        byte[] labelBytes;
        if (this.channels.containsKey(sid)) {
            throw new IOException("Channel on sid: " + sid + " already exists");
        }
        if (label == null) {
            labelBytes = null;
            labelByteLength = 0;
        } else {
            labelBytes = label.getBytes("UTF-8");
            labelByteLength = labelBytes.length;
            if (labelByteLength > 65535) {
                labelByteLength = 65535;
            }
        }
        String protocol = WEBRTC_DATA_CHANNEL_PROTOCOL;
        byte[] protocolBytes = protocol.getBytes("UTF-8");
        int protocolByteLength = protocolBytes.length;
        if (protocolByteLength > 65535) {
            protocolByteLength = 65535;
        }
        ByteBuffer packet = ByteBuffer.allocate(12 + labelByteLength + protocolByteLength);
        packet.put((byte)3);
        packet.put((byte)type);
        packet.putShort((short)prio);
        packet.putInt((int)reliab);
        packet.putShort((short)labelByteLength);
        packet.putShort((short)protocolByteLength);
        if (labelByteLength != 0) {
            packet.put(labelBytes, 0, labelByteLength);
        }
        if (protocolByteLength != 0) {
            packet.put(protocolBytes, 0, protocolByteLength);
        }
        if ((sentCount = this.sctpSocket.send(packet.array(), true, sid, 50)) != packet.capacity()) {
            throw new IOException("Failed to open new chanel on sid: " + sid);
        }
        WebRtcDataStream channel = new WebRtcDataStream(this.sctpSocket, sid, label, false);
        this.channels.put(sid, channel);
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChannelListener(WebRtcDataStreamListener listener) {
        if (listener != null) {
            List<WebRtcDataStreamListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runOnDtlsTransport(StreamConnector connector) throws IOException {
        DtlsControlImpl dtlsControl = (DtlsControlImpl)this.getTransportManager().getDtlsControl(this);
        DtlsTransformEngine engine = (DtlsTransformEngine)dtlsControl.getTransformEngine();
        final DtlsPacketTransformer transformer = (DtlsPacketTransformer)engine.getRTPTransformer();
        byte[] receiveBuffer = new byte[2035];
        SctpConnection sctpConnection2 = this;
        synchronized (sctpConnection2) {
            this.sctpSocket = Sctp.createSocket((int)5000);
            this.assocIsUp = false;
            this.acceptedIncomingConnection = false;
        }
        this.sctpSocket.setLink(new NetworkLink(){

            public void onConnOut(SctpSocket s, byte[] packet) throws IOException {
                transformer.sendApplicationData(packet, 0, packet.length);
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Connecting SCTP to port: " + this.remoteSctpPort + " to " + this.getEndpoint().getID()));
        }
        this.sctpSocket.setNotificationListener((SctpSocket.NotificationListener)this);
        this.sctpSocket.listen();
        threadPool.execute(new Runnable(){

            public void run() {
                SctpSocket sctpSocket = null;
                try {
                    sctpSocket = SctpConnection.this.sctpSocket;
                    while (sctpSocket != null) {
                        if (sctpSocket.accept()) {
                            SctpConnection.this.acceptedIncomingConnection = true;
                            break;
                        }
                        Thread.sleep(100L);
                        sctpSocket = SctpConnection.this.sctpSocket;
                    }
                    if (SctpConnection.this.isReady()) {
                        SctpConnection.this.notifySctpConnectionReady();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Error accepting SCTP connection", (Throwable)e);
                }
                if (sctpSocket == null && logger.isInfoEnabled()) {
                    logger.info((Object)("SctpConnection " + SctpConnection.this.getID() + " closed" + " before SctpSocket accept()-ed."));
                }
            }
        });
        this.sctpSocket.setDataCallback((SctpDataCallback)this);
        DatagramSocket datagramSocket = connector.getDataSocket();
        this.iceSocket = datagramSocket != null ? new IceUdpSocketWrapper(datagramSocket) : new IceTcpSocketWrapper(connector.getDataTCPSocket());
        DatagramPacket rcvPacket = new DatagramPacket(receiveBuffer, 0, receiveBuffer.length);
        try {
            try {}
            catch (SocketException ex) {
                if (!"Socket closed".equals(ex.getMessage())) {
                    throw ex;
                }
                Object var10_11 = null;
                SctpConnection sctpConnection = this;
                synchronized (sctpConnection) {
                    this.assocIsUp = false;
                    this.acceptedIncomingConnection = false;
                    if (this.sctpSocket == null) return;
                    this.sctpSocket.close();
                    this.sctpSocket = null;
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            SctpConnection sctpConnection4 = this;
            synchronized (sctpConnection4) {
                this.assocIsUp = false;
                this.acceptedIncomingConnection = false;
                if (this.sctpSocket == null) throw throwable;
                this.sctpSocket.close();
                this.sctpSocket = null;
                throw throwable;
            }
        }
        while (true) {
            this.iceSocket.receive(rcvPacket);
            RawPacket raw = new RawPacket(rcvPacket.getData(), rcvPacket.getOffset(), rcvPacket.getLength());
            if ((raw = transformer.reverseTransform(raw)) == null) continue;
            if (this.sctpSocket == null) break;
            this.sctpSocket.onConnIn(raw.getBuffer(), raw.getOffset(), raw.getLength());
        }
        Object var10_10 = null;
        SctpConnection sctpConnection = this;
        synchronized (sctpConnection) {
            this.assocIsUp = false;
            this.acceptedIncomingConnection = false;
            if (this.sctpSocket == null) return;
            this.sctpSocket.close();
            this.sctpSocket = null;
            return;
        }
    }

    private void sendOpenChannelAck(int sid) throws IOException {
        byte[] ack = MSG_CHANNEL_ACK_BYTES;
        int sendAck = this.sctpSocket.send(ack, true, sid, 50);
        if (sendAck != ack.length) {
            logger.error((Object)"Failed to send open channel confirmation");
        }
    }
}

