/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.trillcrypt;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.rvcmd.trillcrypt.AbstractTrillianCryptRvCmd;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class TrillianCryptMsgRvCmd
extends AbstractTrillianCryptRvCmd {
    private static final int TYPE_MSG = 1010;
    private final ByteBlock encryptedMsg;

    public TrillianCryptMsgRvCmd(RecvRvIcbm recvRvIcbm) {
        super(recvRvIcbm);
        TlvChain tlvChain = this.getExtraTlvs();
        Tlv tlv = tlvChain.getLastTlv(1010);
        this.encryptedMsg = tlv == null ? null : tlv.getData();
    }

    public TrillianCryptMsgRvCmd(ByteBlock byteBlock) {
        super(3);
        this.encryptedMsg = byteBlock;
    }

    public final ByteBlock getEncryptedMsg() {
        return this.encryptedMsg;
    }

    protected void writeExtraTlvs(OutputStream outputStream) throws IOException {
        if (this.encryptedMsg != null) {
            new Tlv(1010, this.encryptedMsg).write(outputStream);
        }
    }

    public String toString() {
        return "TrillianEncryptMsgRvCmd: msg=" + BinaryTools.describeData(this.encryptedMsg);
    }
}

