/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.LogWriter;
import gov.nist.core.net.NetworkLayer;
import gov.nist.javax.sip.EventScanner;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.NistSipMessageFactoryImpl;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.PeerUnavailableException;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TransportNotSupportedException;
import javax.sip.address.Router;

public class SipStackImpl
extends SIPTransactionStack
implements SipStack {
    private Hashtable listeningPoints;
    private LinkedList sipProviders;
    private String outboundProxy;
    protected String routerPath;
    protected EventScanner eventScanner;
    protected boolean reEntrantListener;
    protected boolean stripRouteHeader;
    protected boolean dialogSupport;

    protected SipStackImpl() {
        NistSipMessageFactoryImpl msgFactory = new NistSipMessageFactoryImpl(this);
        super.setMessageFactory(msgFactory);
        this.listeningPoints = new Hashtable();
        this.sipProviders = new LinkedList();
        this.eventScanner = new EventScanner(this);
    }

    protected void reInit() {
        super.reInit();
        this.listeningPoints = new Hashtable();
        this.sipProviders = new LinkedList();
        this.eventScanner = new EventScanner(this);
    }

    public SipStackImpl(Properties configurationProperties) throws PeerUnavailableException {
        this();
        String stunAddr;
        String readTimeout;
        String transactionTableSize;
        String threadPoolSize;
        String serverLog;
        String badMessageLog;
        String logLevel;
        String debugLog;
        String rf;
        String extensionMethods;
        String address = configurationProperties.getProperty("javax.sip.IP_ADDRESS");
        try {
            if (address == null) {
                throw new PeerUnavailableException("address not specified");
            }
            super.setHostAddress(address);
            super.setRealHostAddress(address);
        }
        catch (UnknownHostException ex) {
            throw new PeerUnavailableException("bad address " + address);
        }
        String name = configurationProperties.getProperty("javax.sip.STACK_NAME");
        if (name == null) {
            throw new PeerUnavailableException("stack name is missing");
        }
        super.setStackName(name);
        String routerPath = configurationProperties.getProperty("javax.sip.ROUTER_PATH");
        if (routerPath == null) {
            routerPath = "gov.nist.javax.sip.stack.DefaultRouter";
        }
        String outboundProxy = configurationProperties.getProperty("javax.sip.OUTBOUND_PROXY");
        try {
            Class<?> routerClass = Class.forName(routerPath);
            Class[] constructorArgs = new Class[]{SipStack.class, String.class};
            Constructor<?> cons = routerClass.getConstructor(constructorArgs);
            Object[] args = new Object[]{this, outboundProxy};
            Router router = (Router)cons.newInstance(args);
            super.setRouter(router);
        }
        catch (InvocationTargetException ex1) {
            throw new PeerUnavailableException("Cound not instantiate router - check constructor", (Throwable)ex1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new PeerUnavailableException("Could not instantiate router", (Throwable)ex);
        }
        String NETWORK_LAYER_KEY = "gov.nist.javax.sip.NETWORK_LAYER";
        if (configurationProperties.containsKey("gov.nist.javax.sip.NETWORK_LAYER")) {
            String path = configurationProperties.getProperty("gov.nist.javax.sip.NETWORK_LAYER");
            try {
                Class<?> clazz = Class.forName(path);
                Constructor<?> c = clazz.getConstructor(new Class[0]);
                this.networkLayer = (NetworkLayer)c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new PeerUnavailableException("can't find or instantiate NetworkLayer implementation: " + path);
            }
        }
        if ((extensionMethods = configurationProperties.getProperty("javax.sip.EXTENSION_METHODS")) != null) {
            StringTokenizer st = new StringTokenizer(extensionMethods);
            LinkedList ll = new LinkedList();
            while (st.hasMoreTokens()) {
                String em = st.nextToken(":");
                if (em.equalsIgnoreCase("BYE") || em.equalsIgnoreCase("ACK") || em.equalsIgnoreCase("OPTIONS")) {
                    throw new PeerUnavailableException("Bad extension method " + em);
                }
                this.addExtensionMethod(em);
            }
        }
        if ((rf = configurationProperties.getProperty("javax.sip.RETRANSMISSION_FILTER")) != null && ("true".equalsIgnoreCase(rf.trim()) || "on".equalsIgnoreCase(rf.trim()))) {
            this.retransmissionFilter = true;
        }
        if ((debugLog = configurationProperties.getProperty("gov.nist.javax.sip.DEBUG_LOG")) != null) {
            this.setDebugLogFileName(debugLog);
        }
        if ((logLevel = configurationProperties.getProperty("gov.nist.javax.sip.TRACE_LEVEL")) != null) {
            try {
                int ll = Integer.parseInt(logLevel);
                if (ll == 32) {
                    LogWriter.needsLogging = true;
                }
                this.serverLog.setTraceLevel(ll);
            }
            catch (NumberFormatException ex) {
                System.out.println("WARNING Bad integer " + logLevel);
                System.out.println("logging dislabled ");
                this.serverLog.setTraceLevel(0);
            }
        }
        if ((badMessageLog = configurationProperties.getProperty("gov.nist.javax.sip.BAD_MESSAGE_LOG")) != null) {
            this.badMessageLog = badMessageLog;
        }
        if ((serverLog = configurationProperties.getProperty("gov.nist.javax.sip.SERVER_LOG")) != null) {
            this.serverLog.setProperties(configurationProperties);
        }
        this.serverLog.checkLogFile();
        String maxConnections = configurationProperties.getProperty("gov.nist.javax.sip.MAX_CONNECTIONS");
        if (maxConnections != null) {
            try {
                this.maxConnections = new Integer(maxConnections);
            }
            catch (NumberFormatException ex) {
                System.out.println("max connections - bad value " + ex.getMessage());
            }
        }
        if ((threadPoolSize = configurationProperties.getProperty("gov.nist.javax.sip.THREAD_POOL_SIZE")) != null) {
            try {
                this.threadPoolSize = new Integer(threadPoolSize);
            }
            catch (NumberFormatException ex) {
                System.out.println("thread pool size - bad value " + ex.getMessage());
            }
        }
        if ((transactionTableSize = configurationProperties.getProperty("gov.nist.javax.sip.MAX_SERVER_TRANSACTIONS")) != null) {
            try {
                this.transactionTableSize = new Integer(transactionTableSize);
            }
            catch (NumberFormatException ex) {
                System.out.println("transaction table size - bad value " + ex.getMessage());
            }
        }
        this.cacheServerConnections = true;
        String flag = configurationProperties.getProperty("gov.nist.javax.sip.CACHE_SERVER_CONNECTIONS");
        if (flag != null && "false".equalsIgnoreCase(flag.trim())) {
            this.cacheServerConnections = false;
        }
        this.cacheClientConnections = true;
        String cacheflag = configurationProperties.getProperty("gov.nist.javax.sip.CACHE_CLIENT_CONNECTIONS");
        if (cacheflag != null && "false".equalsIgnoreCase(cacheflag.trim())) {
            this.cacheClientConnections = false;
        }
        if ((readTimeout = configurationProperties.getProperty("gov.nist.javax.sip.READ_TIMEOUT")) != null) {
            try {
                int rt = Integer.parseInt(readTimeout);
                if (rt >= 100) {
                    this.readTimeout = rt;
                } else {
                    System.out.println("Value too low " + readTimeout);
                }
            }
            catch (NumberFormatException nfe) {
                System.out.println("Bad read timeout " + readTimeout);
            }
        }
        if ((stunAddr = configurationProperties.getProperty("gov.nist.javax.sip.STUN_SERVER")) != null) {
            int k = stunAddr.indexOf(58);
            if (k == -1) {
                this.stunServerAddress = stunAddr;
                this.stunServerPort = 3478;
            } else {
                this.stunServerAddress = stunAddr.substring(0, k);
                String portString = stunAddr.substring(k + 1).trim();
                try {
                    this.stunServerPort = Integer.parseInt(portString);
                }
                catch (NumberFormatException ex) {
                    this.stunServerPort = 3478;
                }
            }
        }
        String maxMsgSize = configurationProperties.getProperty("gov.nist.javax.sip.MAX_MESSAGE_SIZE");
        try {
            if (maxMsgSize != null) {
                this.maxMessageSize = new Integer(maxMsgSize);
                if (this.maxMessageSize < 4096) {
                    this.maxMessageSize = 4096;
                }
            } else {
                this.maxMessageSize = 0;
            }
        }
        catch (NumberFormatException ex) {
            System.out.println("maxMessageSize - bad value " + ex.getMessage());
        }
        String rel = configurationProperties.getProperty("gov.nist.javax.sip.REENTRANT_LISTENER");
        this.reEntrantListener = rel != null && "true".equals(rel);
        String flagStr = configurationProperties.getProperty("gov.nist.javax.sip.STRIP_ROUTE_HEADER");
        this.stripRouteHeader = true;
        this.stripRouteHeader = flagStr == null ? true : "true".equals(flagStr);
        String dialogSupportStr = configurationProperties.getProperty("javax.sip.AUTOMATIC_DIALOG_SUPPORT");
        this.dialogSupport = dialogSupportStr == null ? true : !"false".equals(dialogSupportStr);
    }

    public synchronized ListeningPoint createListeningPoint(int port, String transport) throws TransportNotSupportedException, InvalidArgumentException {
        String key;
        ListeningPointImpl lip;
        if (transport == null) {
            throw new NullPointerException("null transport");
        }
        if (port <= 0) {
            throw new InvalidArgumentException("bad port");
        }
        if (!(transport.equalsIgnoreCase("UDP") || transport.equalsIgnoreCase("TLS") || transport.equalsIgnoreCase("TCP"))) {
            throw new TransportNotSupportedException("bad transport " + transport);
        }
        if (!this.isAlive()) {
            this.toExit = false;
            this.reInit();
        }
        if ((lip = (ListeningPointImpl)this.listeningPoints.get(key = ListeningPointImpl.makeKey(this.stackAddress, port, transport))) != null) {
            return lip;
        }
        try {
            MessageProcessor messageProcessor = this.createMessageProcessor(port, transport);
            lip = new ListeningPointImpl(this, port, transport);
            lip.messageProcessor = messageProcessor;
            messageProcessor.setListeningPoint(lip);
            this.listeningPoints.put(key, lip);
            return lip;
        }
        catch (IOException ex) {
            throw new InvalidArgumentException(ex.getMessage());
        }
    }

    public SipProvider createSipProvider(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint");
        }
        ListeningPointImpl listeningPointImpl = (ListeningPointImpl)listeningPoint;
        if (listeningPointImpl.sipProviderImpl != null) {
            throw new ObjectInUseException("Provider already attached!");
        }
        SipProviderImpl provider = new SipProviderImpl(this.eventScanner);
        provider.setSipStack(this);
        provider.setListeningPoint(listeningPointImpl);
        listeningPointImpl.sipProviderImpl = provider;
        this.sipProviders.add(provider);
        return provider;
    }

    public void deleteListeningPoint(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint arg");
        }
        ListeningPointImpl lip = (ListeningPointImpl)listeningPoint;
        super.removeMessageProcessor(lip.messageProcessor);
        String key = lip.getKey();
        this.listeningPoints.remove(key);
    }

    public void deleteSipProvider(SipProvider sipProvider) throws ObjectInUseException {
        if (sipProvider == null) {
            throw new NullPointerException("null provider arg");
        }
        SipProviderImpl sipProviderImpl = (SipProviderImpl)sipProvider;
        if (sipProviderImpl.listeningPoint.messageProcessor.inUse()) {
            throw new ObjectInUseException("Provider in use");
        }
        sipProviderImpl.sipListener = null;
        sipProviderImpl.stop();
        this.sipProviders.remove(sipProvider);
        if (this.sipProviders.isEmpty()) {
            this.stopStack();
        }
    }

    public String getIPAddress() {
        return super.getHostAddress();
    }

    public Iterator getListeningPoints() {
        return this.listeningPoints.values().iterator();
    }

    public ListeningPointImpl getListeningPoint(int port, String transport) {
        String key = ListeningPointImpl.makeKey(this.stackAddress, port, transport);
        return (ListeningPointImpl)this.listeningPoints.get(key);
    }

    public String getOutboundProxy() {
        return this.outboundProxy;
    }

    public boolean isRetransmissionFilterActive() {
        return this.retransmissionFilter;
    }

    public Router getRouter() {
        return super.getRouter();
    }

    public Iterator getSipProviders() {
        return this.sipProviders.iterator();
    }

    public String getStackName() {
        return this.stackName;
    }

    protected String getDefaultTransport() {
        if (this.isTransportEnabled("udp")) {
            return "udp";
        }
        if (this.isTransportEnabled("tcp")) {
            return "tcp";
        }
        if (this.isTransportEnabled("tls")) {
            return "tls";
        }
        return null;
    }

    public void finalize() {
        this.stopStack();
    }
}

