/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StunMessageEvent;
import org.ice4j.attribute.AttributeFactory;
import org.ice4j.attribute.ErrorCodeAttribute;
import org.ice4j.attribute.IceControlledAttribute;
import org.ice4j.attribute.IceControllingAttribute;
import org.ice4j.attribute.MappedAddressAttribute;
import org.ice4j.attribute.MessageIntegrityAttribute;
import org.ice4j.attribute.PriorityAttribute;
import org.ice4j.attribute.UsernameAttribute;
import org.ice4j.ice.Agent;
import org.ice4j.ice.CompatibilityMode;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.message.Message;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.security.CredentialsAuthority;
import org.ice4j.stack.RequestListener;
import org.ice4j.stack.StunStack;

class ConnectivityCheckServer
implements RequestListener,
CredentialsAuthority {
    private static final Logger logger = Logger.getLogger(ConnectivityCheckServer.class.getName());
    private final Agent parentAgent;
    private boolean started = false;
    private final StunStack stunStack;

    public ConnectivityCheckServer(Agent parentAgent) {
        this.parentAgent = parentAgent;
        this.stunStack = this.parentAgent.getStunStack();
        this.stunStack.getCredentialsManager().registerAuthority(this);
        this.start();
    }

    public void processRequest(StunMessageEvent evt) throws IllegalArgumentException {
        Request request;
        UsernameAttribute uname;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Received request " + evt);
        }
        if ((uname = (UsernameAttribute)(request = (Request)evt.getMessage()).getAttribute('\u0006')) == null || this.parentAgent.getCompatibilityMode() == CompatibilityMode.RFC5245 && !this.checkLocalUserName(new String(uname.getUsername()))) {
            return;
        }
        if ((this.parentAgent.isControlling() && request.containsAttribute('\u802a') || !this.parentAgent.isControlling() && request.containsAttribute('\u8029')) && !this.repairRoleConflict(evt)) {
            return;
        }
        long priority = 0L;
        boolean useCandidate = request.containsAttribute('%');
        String username = new String(uname.getUsername());
        String remoteUfrag = null;
        String localUFrag = null;
        if (this.parentAgent.getCompatibilityMode() == CompatibilityMode.GTALK) {
            useCandidate = false;
            priority = 900L;
            remoteUfrag = username.substring(0, 16);
            localUFrag = username.substring(16, 32);
        } else {
            priority = this.extractPriority(request);
            int colon = username.indexOf(":");
            remoteUfrag = username.substring(0, colon);
        }
        if (this.parentAgent.getCompatibilityMode() == CompatibilityMode.GTALK && this.parentAgent.findCandidatePair(localUFrag, remoteUfrag) == null) {
            logger.info("No candidate pair that match local and remote ufrag");
            Response response = MessageFactory.createBindingErrorResponse('\u01ae');
            ErrorCodeAttribute err = (ErrorCodeAttribute)response.getAttribute('\t');
            err.setErrorClass((byte)1);
            err.setErrorNumber((byte)-82);
            try {
                this.stunStack.sendResponse(evt.getTransactionID().getBytes(), response, evt.getLocalAddress(), evt.getRemoteAddress());
                return;
            }
            catch (Exception exc) {
                throw new RuntimeException("Failed to send a 430", exc);
            }
        }
        this.parentAgent.incomingCheckReceived(evt.getRemoteAddress(), evt.getLocalAddress(), priority, remoteUfrag, localUFrag, useCandidate);
        Response response = MessageFactory.createBindingResponse(request, evt.getRemoteAddress());
        UsernameAttribute usernameAttribute = AttributeFactory.createUsernameAttribute(uname.getUsername());
        response.addAttribute(usernameAttribute);
        if (this.parentAgent.getCompatibilityMode() == CompatibilityMode.GTALK) {
            MappedAddressAttribute mappedAddressAttribute = AttributeFactory.createMappedAddressAttribute(evt.getRemoteAddress());
            response.addAttribute(mappedAddressAttribute);
            response.removeAttribute(' ');
        } else {
            MessageIntegrityAttribute messageIntegrityAttribute = AttributeFactory.createMessageIntegrityAttribute(new String(uname.getUsername()));
            response.addAttribute(messageIntegrityAttribute);
        }
        try {
            this.stunStack.sendResponse(evt.getTransactionID().getBytes(), response, evt.getLocalAddress(), evt.getRemoteAddress());
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Failed to send " + response + " through " + evt.getLocalAddress(), e);
            throw new RuntimeException("Failed to send a response", e);
        }
    }

    private long extractPriority(Request request) throws IllegalArgumentException {
        PriorityAttribute priorityAttr = (PriorityAttribute)request.getAttribute('$');
        if (priorityAttr == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Received a connectivity ckeck withno PRIORITY attribute. Discarding.");
            }
            throw new IllegalArgumentException("Missing PRIORITY attribtue!");
        }
        return priorityAttr.getPriority();
    }

    private boolean repairRoleConflict(StunMessageEvent evt) {
        Message req = evt.getMessage();
        long ourTieBreaker = this.parentAgent.getTieBreaker();
        if (this.parentAgent.isControlling() && req.containsAttribute('\u802a')) {
            IceControllingAttribute controlling = (IceControllingAttribute)req.getAttribute('\u802a');
            long theirTieBreaker = controlling.getTieBreaker();
            if (ourTieBreaker >= theirTieBreaker) {
                Response response = MessageFactory.createBindingErrorResponse('\u01e7');
                try {
                    this.stunStack.sendResponse(evt.getTransactionID().getBytes(), response, evt.getLocalAddress(), evt.getRemoteAddress());
                    return false;
                }
                catch (Exception exc) {
                    throw new RuntimeException("Failed to send a 487", exc);
                }
            }
            logger.finer("Swithing to controlled because theirTieBreaker=" + theirTieBreaker + " and ourTieBreaker=" + ourTieBreaker);
            this.parentAgent.setControlling(false);
            return true;
        }
        if (!this.parentAgent.isControlling() && req.containsAttribute('\u8029')) {
            IceControlledAttribute controlled = (IceControlledAttribute)req.getAttribute('\u8029');
            long theirTieBreaker = controlled.getTieBreaker();
            if (ourTieBreaker >= theirTieBreaker) {
                logger.finer("Swithing to controlling because theirTieBreaker=" + theirTieBreaker + " and ourTieBreaker=" + ourTieBreaker);
                this.parentAgent.setControlling(true);
                return true;
            }
            Response response = MessageFactory.createBindingErrorResponse('\u01e7');
            try {
                this.stunStack.sendResponse(evt.getTransactionID().getBytes(), response, evt.getLocalAddress(), evt.getRemoteAddress());
                return false;
            }
            catch (Exception exc) {
                throw new RuntimeException("Failed to send a 487", exc);
            }
        }
        return true;
    }

    public boolean checkLocalUserName(String username) {
        int colon;
        String ufrag = null;
        ufrag = this.parentAgent.getCompatibilityMode() == CompatibilityMode.GTALK ? (username.length() == 32 ? username.substring(0, 16) : username) : ((colon = username.indexOf(":")) < 0 ? username : username.substring(0, colon));
        return ufrag.equals(this.parentAgent.getLocalUfrag());
    }

    public byte[] getLocalKey(String username) {
        return this.checkLocalUserName(username) ? this.parentAgent.getLocalPassword().getBytes() : null;
    }

    public byte[] getRemoteKey(String username, String media) {
        int colon = username.indexOf(":");
        IceMediaStream stream = this.parentAgent.getStream(media);
        if (stream == null) {
            return null;
        }
        if (colon < 0 ? username.equals(stream.getRemoteUfrag()) : username.equals(this.parentAgent.generateLocalUserName(media)) && stream.getRemotePassword() != null) {
            return stream.getRemotePassword().getBytes();
        }
        return null;
    }

    public void start() {
        if (!this.started) {
            this.stunStack.addRequestListener(this);
            this.started = true;
        }
    }

    public void stop() {
        this.stunStack.removeRequestListener(this);
        this.started = false;
    }
}

