/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.renderer.video;

import java.awt.Canvas;
import java.awt.Container;
import java.awt.Graphics;
import org.jitsi.impl.neomedia.jmfext.media.renderer.video.JAWTRenderer;

public class JAWTRendererVideoComponent
extends Canvas {
    private static final long serialVersionUID = 0L;
    protected final JAWTRenderer renderer;
    private boolean wantsPaint = true;

    public JAWTRendererVideoComponent(JAWTRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.wantsPaint = true;
    }

    protected long getHandle() {
        return this.renderer.getHandle();
    }

    protected Object getHandleLock() {
        return this.renderer.getHandleLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        if (this.wantsPaint && this.getWidth() >= 4 && this.getHeight() >= 4) {
            Object object = this.getHandleLock();
            synchronized (object) {
                long handle = this.getHandle();
                if (handle != 0L) {
                    Container parent = this.getParent();
                    int zOrder = parent == null ? -1 : parent.getComponentZOrder(this);
                    this.wantsPaint = JAWTRenderer.paint(handle, this, g, zOrder);
                }
            }
        }
    }

    @Override
    public void removeNotify() {
        this.wantsPaint = true;
        super.removeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Graphics g) {
        Object object = this.getHandleLock();
        synchronized (object) {
            if (!this.wantsPaint || this.getHandle() == 0L) {
                super.update(g);
                return;
            }
        }
        this.paint(g);
    }
}

