/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.trust;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import net.kano.joscar.DefensiveTools;
import net.kano.joustsim.trust.CertificateHolder;

public class DefaultCertificateHolder
implements CertificateHolder {
    private final X509Certificate certificate;
    private final BigInteger mod;
    private final BigInteger exp;

    public DefaultCertificateHolder(X509Certificate cert) {
        DefensiveTools.checkNull((Object)cert, (String)"cert");
        PublicKey pubkey = cert.getPublicKey();
        if (!(pubkey instanceof RSAPublicKey)) {
            throw new IllegalArgumentException();
        }
        this.certificate = cert;
        RSAPublicKey rsaKey = (RSAPublicKey)pubkey;
        this.mod = rsaKey.getModulus();
        if (this.mod == null) {
            throw new IllegalArgumentException("modulus of key is null");
        }
        this.exp = rsaKey.getPublicExponent();
        if (this.exp == null) {
            throw new IllegalArgumentException("exponent of key is null");
        }
    }

    public final X509Certificate getCertificate() {
        return this.certificate;
    }

    public final int hashCode() {
        return this.mod.hashCode() ^ this.exp.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CertificateHolder)) {
            return false;
        }
        DefaultCertificateHolder holder = (DefaultCertificateHolder)obj;
        return holder.mod.equals(this.mod) && holder.exp.equals(this.exp);
    }
}

