/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.dtd;

import java.io.IOException;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.baseparser.Space;
import weblogic.xml.babel.dtd.Declaration;
import weblogic.xml.babel.dtd.EntityTable;
import weblogic.xml.babel.dtd.ExternalID;
import weblogic.xml.babel.dtd.Name;
import weblogic.xml.babel.scanner.ScannerException;

public abstract class EntityDeclaration
extends Declaration {
    protected Name name;
    protected Space space;
    protected ExternalID externalID;
    protected boolean isExternal;
    protected String data;

    public EntityDeclaration() {
        this.init();
    }

    public void init() {
        super.init();
        this.name = new Name();
        this.space = new Space();
        this.externalID = new ExternalID();
        this.isExternal = false;
    }

    protected abstract void parseType(BaseParser var1) throws IOException, ScannerException, ParseException;

    protected void parseNData(BaseParser baseParser) throws IOException, ScannerException, ParseException {
    }

    protected void parseValue(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        this.data = "";
        while (baseParser.compare(13) || baseParser.compare(15) || baseParser.compare(14)) {
            this.data = this.data + baseParser.getCurrentToken().getArrayAsString();
            baseParser.accept();
        }
    }

    public void parse(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        this.init();
        this.parseType(baseParser);
        this.space.parse(baseParser);
        this.name.parse(baseParser);
        this.space.parse(baseParser);
        switch (baseParser.getCurrentToken().tokenType) {
            case 13: 
            case 14: 
            case 15: {
                this.isExternal = false;
                this.parseValue(baseParser);
                EntityTable entityTable = baseParser.getInternalEntityTable();
                if (entityTable == null) break;
                entityTable.put(this.name.getRawName(), this.data);
                break;
            }
            case 25: 
            case 26: {
                this.isExternal = true;
                this.externalID.parse(baseParser);
                this.parseNData(baseParser);
                EntityTable entityTable = baseParser.getExternalEntityTable();
                if (entityTable == null) break;
                entityTable.put(this.name.getRawName(), this.externalID);
                break;
            }
            case 39: {
                this.data = "";
                break;
            }
            default: {
                throw new ParseException("An Entity Declaration must contain an EntityValue or ExternalID", baseParser.getLine(), baseParser.getCurrentToken());
            }
        }
        this.space.parse(baseParser);
        baseParser.accept(39);
        this.type = 14;
    }
}

