/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icq;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.kano.joscar.LEBinaryTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icq.AbstractIcqCmd;
import net.kano.joscar.snaccmd.icq.AbstractInfoCmd;
import net.kano.joscar.snaccmd.icq.IcqType;

public class MetaHomepageCategoryInfoCmd
extends AbstractInfoCmd {
    private int categoryCode;
    private String keywords;

    protected MetaHomepageCategoryInfoCmd(SnacPacket packet) {
        super(packet);
    }

    protected MetaHomepageCategoryInfoCmd(long uin, IcqType type, int id) {
        super(uin, AbstractIcqCmd.CMD_META_HOMEPAGE_CATEGORY_INFO_CMD, id);
    }

    protected void readInfo(InputStream is) throws IOException {
        int enabled = is.read();
        if (enabled != 0) {
            this.categoryCode = LEBinaryTools.readUShort(is);
            this.keywords = LEBinaryTools.readUShortLengthString(is);
        }
    }

    protected void writeInfo(OutputStream out) throws IOException {
        out.write(1);
        LEBinaryTools.writeUShort(out, this.categoryCode);
        LEBinaryTools.writeUShortLengthString(out, this.keywords);
        out.write(0);
    }

    public String toString() {
        return "MetaHomepageCategoryInfoCmd: categoryCode=" + this.categoryCode + " keywords=" + this.keywords + " in " + super.toString();
    }

    public int getCategory() {
        return this.categoryCode;
    }

    public String getKeywords() {
        return this.keywords;
    }
}

