/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.net.AddressResolver;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.sip.SipException;
import javax.sip.SipStack;
import javax.sip.address.Hop;
import javax.sip.address.Router;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.message.Request;

public class DefaultRouter
implements Router {
    private SipStackImpl sipStack;
    private Hop defaultRoute;

    private DefaultRouter() {
    }

    public DefaultRouter(SipStack sipStack, String string) {
        this.sipStack = (SipStackImpl)sipStack;
        if (string != null) {
            try {
                this.defaultRoute = this.sipStack.getAddressResolver().resolveAddress(new HopImpl(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((SIPTransactionStack)sipStack).getLogWriter().logError("Invalid default route specification - need host:port/transport");
                throw illegalArgumentException;
            }
        }
    }

    public Hop getNextHop(Request request) throws SipException {
        SIPRequest sIPRequest = (SIPRequest)request;
        RequestLine requestLine = sIPRequest.getRequestLine();
        if (requestLine == null) {
            return this.defaultRoute;
        }
        GenericURI genericURI = requestLine.getUri();
        if (genericURI == null) {
            throw new IllegalArgumentException("Bad message: Null requestURI");
        }
        RouteList routeList = sIPRequest.getRouteHeaders();
        if (routeList != null) {
            Route route = (Route)routeList.getFirst();
            URI uRI = route.getAddress().getURI();
            if (uRI.isSipURI()) {
                SipURI sipURI = (SipURI)uRI;
                if (!sipURI.hasLrParam()) {
                    this.fixStrictRouting(sIPRequest);
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.logWriter.logDebug("Route post processing fixed strict routing");
                    }
                }
                Hop hop = this.createHop(sipURI);
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("NextHop based on Route:" + hop);
                }
                return hop;
            }
            throw new SipException("First Route not a SIP URI");
        }
        if (genericURI.isSipURI() && ((SipURI)genericURI).getMAddrParam() != null) {
            Hop hop = this.createHop((SipURI)genericURI);
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Using request URI maddr to route the request = " + hop.toString());
            }
            return hop;
        }
        if (this.defaultRoute != null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Using outbound proxy to route the request = " + this.defaultRoute.toString());
            }
            return this.defaultRoute;
        }
        if (genericURI.isSipURI()) {
            Hop hop = this.createHop((SipURI)genericURI);
            if (hop != null && this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Used request-URI for nextHop = " + hop.toString());
            } else if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("returning null hop -- loop detected");
            }
            return hop;
        }
        InternalErrorHandler.handleException("Unexpected non-sip URI", this.sipStack.logWriter);
        return null;
    }

    public void fixStrictRouting(SIPRequest sIPRequest) {
        RouteList routeList = sIPRequest.getRouteHeaders();
        Route route = (Route)routeList.getFirst();
        SipUri sipUri = (SipUri)route.getAddress().getURI();
        routeList.removeFirst();
        AddressImpl addressImpl = new AddressImpl();
        addressImpl.setAddess(sIPRequest.getRequestURI());
        Route route2 = new Route(addressImpl);
        routeList.add(route2);
        sIPRequest.setRequestURI(sipUri);
        if (this.sipStack.getLogWriter().isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("post: fixStrictRouting" + sIPRequest);
        }
    }

    private final Hop createHop(SipURI sipURI) {
        String string;
        String string2 = string = sipURI.isSecure() ? "tls" : sipURI.getTransportParam();
        if (string == null) {
            string = "udp";
        }
        int n = sipURI.getPort() != -1 ? sipURI.getPort() : (string.equalsIgnoreCase("tls") ? 5061 : 5060);
        String string3 = sipURI.getMAddrParam() != null ? sipURI.getMAddrParam() : sipURI.getHost();
        AddressResolver addressResolver = this.sipStack.getAddressResolver();
        return addressResolver.resolveAddress(new HopImpl(string3, n, string));
    }

    public Hop getOutboundProxy() {
        return this.defaultRoute;
    }

    public ListIterator getNextHops(Request request) {
        try {
            LinkedList<Hop> linkedList = new LinkedList<Hop>();
            linkedList.add(this.getNextHop(request));
            return linkedList.listIterator();
        }
        catch (SipException sipException) {
            return null;
        }
    }
}

