/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr;

import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.util.Logger;

public final class InboundVariable {
    private InboundContext context;
    private String key;
    private String type;
    private String value;
    private boolean dereferenced;
    private static final Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("uk.ltd.getahead.dwr.InboundVariable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
    }

    public InboundVariable(InboundContext context, String key, String type, String value) {
        this.context = context;
        this.type = type;
        this.value = value;
        this.key = key;
        this.dereferenced = this.attemptDereference();
    }

    private boolean attemptDereference() {
        int maxDepth = 0;
        if ("reference".equals(this.type)) {
            while ("reference".equals(this.type)) {
                InboundVariable cd = this.context.getInboundVariable(this.value);
                if (cd == null) {
                    return false;
                }
                this.type = cd.type;
                this.value = cd.value;
                if (++maxDepth <= 20) continue;
                throw new IllegalStateException("Max depth exceeded when dereferencing " + this.value);
            }
            if (this.key == null) {
                this.key = this.value;
            }
        }
        return true;
    }

    private void forceDereference() {
        if (!this.dereferenced) {
            this.dereferenced = this.attemptDereference();
            if (!this.dereferenced) {
                log.error(Messages.getString("InboundVariable.MissingVariable", this.value));
            }
        }
    }

    public InboundContext getLookup() {
        this.forceDereference();
        return this.context;
    }

    public String getType() {
        this.forceDereference();
        return this.type;
    }

    public boolean isNull() {
        this.forceDereference();
        return this.type.equals("null");
    }

    public String getValue() {
        this.forceDereference();
        return this.value;
    }

    public String toString() {
        this.forceDereference();
        return String.valueOf(this.type) + ":" + this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InboundVariable)) {
            return false;
        }
        InboundVariable that = (InboundVariable)obj;
        this.forceDereference();
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.value.equals(that.value)) {
            return false;
        }
        if (this.key == null || that.key == null) {
            return false;
        }
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.value.hashCode() + this.type.hashCode();
    }
}

