/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.colibri;

import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.jinglesdp.JingleUtils;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaType;

public class ColibriAnalyser {
    private static final Logger logger = Logger.getLogger(ColibriAnalyser.class);
    private final ColibriConferenceIQ conferenceState;

    public ColibriAnalyser(ColibriConferenceIQ conferenceStateHolder) {
        this.conferenceState = conferenceStateHolder;
    }

    public void processChannelAllocResp(ColibriConferenceIQ allocateResponse) {
        String conferenceResponseID = allocateResponse.getID();
        String colibriID = this.conferenceState.getID();
        if (colibriID == null) {
            this.conferenceState.setID(conferenceResponseID);
        } else if (!colibriID.equals(conferenceResponseID)) {
            throw new IllegalStateException("conference.id");
        }
        this.conferenceState.setFrom(allocateResponse.getFrom());
        for (ColibriConferenceIQ.Content contentResponse : allocateResponse.getContents()) {
            String contentName = contentResponse.getName();
            ColibriConferenceIQ.Content content = this.conferenceState.getOrCreateContent(contentName);
            for (ColibriConferenceIQ.Channel channelResponse : contentResponse.getChannels()) {
                content.addChannel(channelResponse);
            }
            for (ColibriConferenceIQ.SctpConnection sctpConnResponse : contentResponse.getSctpConnections()) {
                content.addSctpConnection(sctpConnResponse);
            }
        }
        for (ColibriConferenceIQ.ChannelBundle bundle : allocateResponse.getChannelBundles()) {
            this.conferenceState.addChannelBundle(bundle);
        }
    }

    public static ColibriConferenceIQ getResponseContents(ColibriConferenceIQ conferenceResponse, List<ContentPacketExtension> peerContents) {
        ColibriConferenceIQ conferenceResult = new ColibriConferenceIQ();
        conferenceResult.setFrom(conferenceResponse.getFrom());
        conferenceResult.setID(conferenceResponse.getID());
        String bundleId = null;
        for (ContentPacketExtension content : peerContents) {
            MediaType mediaType = JingleUtils.getMediaType(content);
            ColibriConferenceIQ.Content contentResponse = conferenceResponse.getContent(mediaType.toString());
            if (contentResponse == null) continue;
            String contentName = contentResponse.getName();
            ColibriConferenceIQ.Content contentResult = new ColibriConferenceIQ.Content(contentName);
            conferenceResult.addContent(contentResult);
            for (ColibriConferenceIQ.Channel channelResponse : contentResponse.getChannels()) {
                contentResult.addChannel(channelResponse);
                bundleId = ColibriAnalyser.readChannelBundle(channelResponse, bundleId);
            }
            for (ColibriConferenceIQ.SctpConnection sctpConnResponse : contentResponse.getSctpConnections()) {
                contentResult.addSctpConnection(sctpConnResponse);
                bundleId = ColibriAnalyser.readChannelBundle(sctpConnResponse, bundleId);
            }
        }
        if (bundleId != null) {
            for (ColibriConferenceIQ.ChannelBundle bundle : conferenceResponse.getChannelBundles()) {
                if (!bundleId.equals(bundle.getId())) continue;
                conferenceResult.addChannelBundle(bundle);
                break;
            }
        }
        return conferenceResult;
    }

    private static String readChannelBundle(ColibriConferenceIQ.ChannelCommon channel, String currentBundle) {
        String channelBundle = channel.getChannelBundleId();
        if (channelBundle == null) {
            return currentBundle;
        }
        if (currentBundle == null) {
            return channel.getChannelBundleId();
        }
        if (!currentBundle.equals(channelBundle)) {
            logger.error((Object)("Replaced bundle: " + currentBundle + " with " + channelBundle));
        }
        return channelBundle;
    }
}

