/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.rtcp;

import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.util.BadFormatException;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPPacketParserEx;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.RTCPTerminationStrategy;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.Transformer;
import org.jitsi.util.Logger;

public class RTCPTerminationTransformEngine
extends SinglePacketTransformer
implements TransformEngine {
    private static final Logger logger = Logger.getLogger(RTCPTerminationTransformEngine.class);
    private final MediaStream mediaStream;
    private final RTCPPacketParserEx parser;

    public RTCPTerminationTransformEngine(MediaStream mediaStream) {
        this.mediaStream = mediaStream;
        this.parser = new RTCPPacketParserEx();
    }

    @Override
    public void close() {
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return null;
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        RTCPCompoundPacket inRTCPPacket;
        if (pkt == null) {
            return pkt;
        }
        RTPTranslator rtpTranslator = this.mediaStream.getRTPTranslator();
        if (rtpTranslator == null) {
            return pkt;
        }
        RTCPTerminationStrategy rtcpTerminationStrategy = rtpTranslator.getRTCPTerminationStrategy();
        if (rtcpTerminationStrategy == null) {
            return pkt;
        }
        Transformer<RTCPCompoundPacket> rtcpPacketTransformer = rtcpTerminationStrategy.getRTCPCompoundPacketTransformer();
        if (rtcpPacketTransformer == null) {
            return pkt;
        }
        try {
            inRTCPPacket = (RTCPCompoundPacket)this.parser.parse(pkt.getBuffer(), pkt.getOffset(), pkt.getLength());
        }
        catch (BadFormatException e) {
            logger.error("Could not parse RTCP packet.", e);
            return pkt;
        }
        logger.debug("Parsed : " + inRTCPPacket.toString());
        RTCPCompoundPacket outRTCPPacket = rtcpPacketTransformer.reverseTransform(inRTCPPacket);
        if (inRTCPPacket == outRTCPPacket) {
            logger.debug("Did not perform any modifications to the received packet.");
            return pkt;
        }
        if (outRTCPPacket == null) {
            logger.debug("The RTCP termination strategy dropped the received packet from the transform engine chain.");
        } else {
            logger.debug("Transformed the received packet to : " + outRTCPPacket.toString());
        }
        if (outRTCPPacket == null || outRTCPPacket.packets == null || outRTCPPacket.packets.length == 0) {
            return null;
        }
        int len = outRTCPPacket.calcLength();
        outRTCPPacket.assemble(len, false);
        byte[] buf = outRTCPPacket.data;
        RawPacket pktOut = new RawPacket();
        pktOut.setBuffer(buf);
        pktOut.setLength(buf.length);
        pktOut.setOffset(0);
        return pktOut;
    }

    @Override
    public RawPacket transform(RawPacket pkt) {
        return pkt;
    }
}

