/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.unix;

import cx.ath.matthew.unix.NotConnectedException;
import cx.ath.matthew.unix.USInputStream;
import cx.ath.matthew.unix.USOutputStream;
import cx.ath.matthew.unix.UnixSocketAddress;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UnixSocket {
    private UnixSocketAddress address = null;
    private USOutputStream os = null;
    private USInputStream is = null;
    private boolean closed = false;
    private boolean connected = false;
    private boolean passcred = false;
    private int sock = 0;
    private boolean blocking = true;
    private int uid = -1;
    private int pid = -1;
    private int gid = -1;

    private native void native_set_pass_cred(int var1, boolean var2) throws IOException;

    private native int native_connect(String var1, boolean var2) throws IOException;

    private native void native_close(int var1) throws IOException;

    private native int native_getPID(int var1);

    private native int native_getUID(int var1);

    private native int native_getGID(int var1);

    private native void native_send_creds(int var1, byte var2) throws IOException;

    private native byte native_recv_creds(int var1, int[] var2) throws IOException;

    UnixSocket(int n, UnixSocketAddress unixSocketAddress) {
        this.sock = n;
        this.address = unixSocketAddress;
        this.connected = true;
        this.os = new USOutputStream(n, this);
        this.is = new USInputStream(n, this);
    }

    public UnixSocket() {
    }

    public UnixSocket(UnixSocketAddress unixSocketAddress) throws IOException {
        this.connect(unixSocketAddress);
    }

    public UnixSocket(String string) throws IOException {
        this(new UnixSocketAddress(string));
    }

    public void connect(UnixSocketAddress unixSocketAddress) throws IOException {
        if (this.connected) {
            this.close();
        }
        this.sock = this.native_connect(unixSocketAddress.path, unixSocketAddress.abs);
        this.os = new USOutputStream(this.sock, this);
        this.is = new USInputStream(this.sock, this);
        this.address = unixSocketAddress;
        this.connected = true;
        this.closed = false;
        this.is.setBlocking(this.blocking);
    }

    public void connect(String string) throws IOException {
        this.connect(new UnixSocketAddress(string));
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void close() throws IOException {
        this.native_close(this.sock);
        this.sock = 0;
        this.closed = true;
        this.connected = false;
        this.os = null;
        this.is = null;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public UnixSocketAddress getAddress() {
        return this.address;
    }

    public void sendCredentialByte(byte by) throws IOException {
        if (!this.connected) {
            throw new NotConnectedException();
        }
        this.native_send_creds(this.sock, by);
    }

    public byte recvCredentialByte() throws IOException {
        if (!this.connected) {
            throw new NotConnectedException();
        }
        int[] nArray = new int[]{-1, -1, -1};
        byte by = this.native_recv_creds(this.sock, nArray);
        this.pid = nArray[0];
        this.uid = nArray[1];
        this.gid = nArray[2];
        return by;
    }

    public boolean getPassCred() {
        return this.passcred;
    }

    public int getPeerUID() {
        if (-1 == this.uid) {
            this.uid = this.native_getUID(this.sock);
        }
        return this.uid;
    }

    public int getPeerGID() {
        if (-1 == this.gid) {
            this.gid = this.native_getGID(this.sock);
        }
        return this.gid;
    }

    public int getPeerPID() {
        if (-1 == this.pid) {
            this.pid = this.native_getPID(this.sock);
        }
        return this.pid;
    }

    public void setPassCred(boolean bl) throws IOException {
        this.native_set_pass_cred(this.sock, bl);
        this.passcred = bl;
    }

    public boolean getBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean bl) {
        this.blocking = bl;
        if (null != this.is) {
            this.is.setBlocking(bl);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isInputShutdown() {
        return this.is.isClosed();
    }

    public boolean isOutputShutdown() {
        return this.os.isClosed();
    }

    public void shutdownInput() {
        this.is.closed = true;
    }

    public void shutdownOutput() {
        this.os.closed = true;
    }

    public void setSoTimeout(int n) {
        this.is.setSoTimeout(n);
    }

    static {
        System.loadLibrary("unix-java");
    }
}

