/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi;

import com.hazelcast.cluster.impl.operations.JoinOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.partition.MigrationCycleOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.annotation.PrivateApi;

@PrivateApi
public final class OperationAccessor {
    private static final ClassLoader THIS_CLASS_LOADER = OperationAccessor.class.getClassLoader();

    private OperationAccessor() {
    }

    public static boolean isJoinOperation(Operation op) {
        return op instanceof JoinOperation && op.getClass().getClassLoader() == THIS_CLASS_LOADER;
    }

    public static boolean isMigrationOperation(Operation op) {
        return op instanceof MigrationCycleOperation && op.getClass().getClassLoader() == THIS_CLASS_LOADER;
    }

    public static void setCallerAddress(Operation op, Address caller) {
        op.setCallerAddress(caller);
    }

    public static void setConnection(Operation op, Connection connection) {
        op.setConnection(connection);
    }

    public static void setCallId(Operation op, long callId) {
        op.setCallId(callId);
    }

    public static void setInvocationTime(Operation op, long invocationTime) {
        op.setInvocationTime(invocationTime);
    }

    public static void setCallTimeout(Operation op, long callTimeout) {
        op.setCallTimeout(callTimeout);
    }
}

