/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.asm;

import org.logicalcobwebs.cglib.asm.Attribute;
import org.logicalcobwebs.cglib.asm.ByteVector;
import org.logicalcobwebs.cglib.asm.ClassVisitor;
import org.logicalcobwebs.cglib.asm.CodeVisitor;
import org.logicalcobwebs.cglib.asm.CodeWriter;
import org.logicalcobwebs.cglib.asm.Item;
import org.logicalcobwebs.cglib.asm.Type;

public class ClassWriter
implements ClassVisitor {
    static final int CLASS = 7;
    static final int FIELD = 9;
    static final int METH = 10;
    static final int IMETH = 11;
    static final int STR = 8;
    static final int INT = 3;
    static final int FLOAT = 4;
    static final int LONG = 5;
    static final int DOUBLE = 6;
    static final int NAME_TYPE = 12;
    static final int UTF8 = 1;
    private int version;
    private short index = 1;
    private ByteVector pool = new ByteVector();
    private Item[] items = new Item[64];
    private int threshold = (int)(0.75 * (double)this.items.length);
    private int access;
    private int name;
    private int superName;
    private int interfaceCount;
    private int[] interfaces;
    private int sourceFile;
    private int fieldCount;
    private ByteVector fields;
    private boolean computeMaxs;
    boolean checkAttributes;
    CodeWriter firstMethod;
    CodeWriter lastMethod;
    private int innerClassesCount;
    private ByteVector innerClasses;
    private Attribute attrs;
    Item key = new Item();
    Item key2 = new Item();
    Item key3 = new Item();
    static final int NOARG_INSN = 0;
    static final int SBYTE_INSN = 1;
    static final int SHORT_INSN = 2;
    static final int VAR_INSN = 3;
    static final int IMPLVAR_INSN = 4;
    static final int TYPE_INSN = 5;
    static final int FIELDORMETH_INSN = 6;
    static final int ITFMETH_INSN = 7;
    static final int LABEL_INSN = 8;
    static final int LABELW_INSN = 9;
    static final int LDC_INSN = 10;
    static final int LDCW_INSN = 11;
    static final int IINC_INSN = 12;
    static final int TABL_INSN = 13;
    static final int LOOK_INSN = 14;
    static final int MANA_INSN = 15;
    static final int WIDE_INSN = 16;
    static byte[] TYPE;

    public ClassWriter(boolean bl) {
        this(bl, false);
    }

    public ClassWriter(boolean bl, boolean bl2) {
        this.computeMaxs = bl;
        this.checkAttributes = !bl2;
    }

    public void visit(int n, int n2, String string, String string2, String[] stringArray, String string3) {
        this.version = n;
        this.access = n2;
        this.name = this.newClass(string);
        int n3 = this.superName = string2 == null ? 0 : this.newClass(string2);
        if (stringArray != null && stringArray.length > 0) {
            this.interfaceCount = stringArray.length;
            this.interfaces = new int[this.interfaceCount];
            for (int i = 0; i < this.interfaceCount; ++i) {
                this.interfaces[i] = this.newClass(stringArray[i]);
            }
        }
        if (string3 != null) {
            this.newUTF8("SourceFile");
            this.sourceFile = this.newUTF8(string3);
        }
        if ((n2 & 0x20000) != 0) {
            this.newUTF8("Deprecated");
        }
        if ((n2 & 0x1000) != 0) {
            this.newUTF8("Synthetic");
        }
    }

    public void visitInnerClass(String string, String string2, String string3, int n) {
        if (this.innerClasses == null) {
            this.newUTF8("InnerClasses");
            this.innerClasses = new ByteVector();
        }
        ++this.innerClassesCount;
        this.innerClasses.putShort(string == null ? 0 : this.newClass(string));
        this.innerClasses.putShort(string2 == null ? 0 : this.newClass(string2));
        this.innerClasses.putShort(string3 == null ? 0 : this.newUTF8(string3));
        this.innerClasses.putShort(n);
    }

    public void visitField(int n, String string, String string2, Object object, Attribute attribute) {
        ++this.fieldCount;
        if (this.fields == null) {
            this.fields = new ByteVector();
        }
        this.fields.putShort(n).putShort(this.newUTF8(string)).putShort(this.newUTF8(string2));
        int n2 = 0;
        if (object != null) {
            ++n2;
        }
        if ((n & 0x1000) != 0) {
            ++n2;
        }
        if ((n & 0x20000) != 0) {
            ++n2;
        }
        if (attribute != null) {
            n2 += attribute.getCount();
        }
        this.fields.putShort(n2);
        if (object != null) {
            this.fields.putShort(this.newUTF8("ConstantValue"));
            this.fields.putInt(2).putShort(this.newConstItem((Object)object).index);
        }
        if ((n & 0x1000) != 0) {
            this.fields.putShort(this.newUTF8("Synthetic")).putInt(0);
        }
        if ((n & 0x20000) != 0) {
            this.fields.putShort(this.newUTF8("Deprecated")).putInt(0);
        }
        if (attribute != null) {
            attribute.put(this, null, 0, -1, -1, this.fields);
        }
    }

    public CodeVisitor visitMethod(int n, String string, String string2, String[] stringArray, Attribute attribute) {
        CodeWriter codeWriter = new CodeWriter(this, this.computeMaxs);
        codeWriter.init(n, string, string2, stringArray, attribute);
        return codeWriter;
    }

    public void visitAttribute(Attribute attribute) {
        attribute.next = this.attrs;
        this.attrs = attribute;
    }

    public void visitEnd() {
    }

    public byte[] toByteArray() {
        int n = 24 + 2 * this.interfaceCount;
        if (this.fields != null) {
            n += this.fields.length;
        }
        int n2 = 0;
        CodeWriter codeWriter = this.firstMethod;
        while (codeWriter != null) {
            ++n2;
            n += codeWriter.getSize();
            codeWriter = codeWriter.next;
        }
        int n3 = 0;
        if (this.sourceFile != 0) {
            ++n3;
            n += 8;
        }
        if ((this.access & 0x20000) != 0) {
            ++n3;
            n += 6;
        }
        if ((this.access & 0x1000) != 0) {
            ++n3;
            n += 6;
        }
        if (this.innerClasses != null) {
            ++n3;
            n += 8 + this.innerClasses.length;
        }
        if (this.attrs != null) {
            n3 += this.attrs.getCount();
            n += this.attrs.getSize(this, null, 0, -1, -1);
        }
        ByteVector byteVector = new ByteVector(n += this.pool.length);
        byteVector.putInt(-889275714).putInt(this.version);
        byteVector.putShort(this.index).putByteArray(this.pool.data, 0, this.pool.length);
        byteVector.putShort(this.access).putShort(this.name).putShort(this.superName);
        byteVector.putShort(this.interfaceCount);
        for (int i = 0; i < this.interfaceCount; ++i) {
            byteVector.putShort(this.interfaces[i]);
        }
        byteVector.putShort(this.fieldCount);
        if (this.fields != null) {
            byteVector.putByteArray(this.fields.data, 0, this.fields.length);
        }
        byteVector.putShort(n2);
        codeWriter = this.firstMethod;
        while (codeWriter != null) {
            codeWriter.put(byteVector);
            codeWriter = codeWriter.next;
        }
        byteVector.putShort(n3);
        if (this.sourceFile != 0) {
            byteVector.putShort(this.newUTF8("SourceFile")).putInt(2).putShort(this.sourceFile);
        }
        if ((this.access & 0x20000) != 0) {
            byteVector.putShort(this.newUTF8("Deprecated")).putInt(0);
        }
        if ((this.access & 0x1000) != 0) {
            byteVector.putShort(this.newUTF8("Synthetic")).putInt(0);
        }
        if (this.innerClasses != null) {
            byteVector.putShort(this.newUTF8("InnerClasses"));
            byteVector.putInt(this.innerClasses.length + 2).putShort(this.innerClassesCount);
            byteVector.putByteArray(this.innerClasses.data, 0, this.innerClasses.length);
        }
        if (this.attrs != null) {
            this.attrs.put(this, null, 0, -1, -1, byteVector);
        }
        return byteVector.data;
    }

    Item newConstItem(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return this.newInteger(n);
        }
        if (object instanceof Byte) {
            int n = ((Byte)object).intValue();
            return this.newInteger(n);
        }
        if (object instanceof Character) {
            char c = ((Character)object).charValue();
            return this.newInteger(c);
        }
        if (object instanceof Short) {
            int n = ((Short)object).intValue();
            return this.newInteger(n);
        }
        if (object instanceof Boolean) {
            int n = (Boolean)object != false ? 1 : 0;
            return this.newInteger(n);
        }
        if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            return this.newFloat(f);
        }
        if (object instanceof Long) {
            long l = (Long)object;
            return this.newLong(l);
        }
        if (object instanceof Double) {
            double d = (Double)object;
            return this.newDouble(d);
        }
        if (object instanceof String) {
            return this.newString((String)object);
        }
        if (object instanceof Type) {
            Type type = (Type)object;
            return this.newClassItem(type.getSort() == 10 ? type.getInternalName() : type.getDescriptor());
        }
        throw new IllegalArgumentException("value " + object);
    }

    public int newConst(Object object) {
        return this.newConstItem((Object)object).index;
    }

    public int newConstInt(int n) {
        return this.newInteger((int)n).index;
    }

    public int newConstLong(long l) {
        return this.newLong((long)l).index;
    }

    public int newConstFloat(float f) {
        return this.newFloat((float)f).index;
    }

    public int newConstDouble(double d) {
        return this.newDouble((double)d).index;
    }

    public int newUTF8(String string) {
        this.key.set(1, string, null, null);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.putByte(1).putUTF8(string);
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key);
            this.put(item);
        }
        return item.index;
    }

    public int newClass(String string) {
        return this.newClassItem((String)string).index;
    }

    private Item newClassItem(String string) {
        this.key2.set(7, string, null, null);
        Item item = this.get(this.key2);
        if (item == null) {
            this.pool.put12(7, this.newUTF8(string));
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key2);
            this.put(item);
        }
        return item;
    }

    public int newField(String string, String string2, String string3) {
        this.key3.set(9, string, string2, string3);
        Item item = this.get(this.key3);
        if (item == null) {
            this.put122(9, this.newClass(string), this.newNameType(string2, string3));
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key3);
            this.put(item);
        }
        return item.index;
    }

    Item newMethodItem(String string, String string2, String string3, boolean bl) {
        this.key3.set(bl ? 11 : 10, string, string2, string3);
        Item item = this.get(this.key3);
        if (item == null) {
            this.put122(bl ? 11 : 10, this.newClass(string), this.newNameType(string2, string3));
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key3);
            this.put(item);
        }
        return item;
    }

    public int newMethod(String string, String string2, String string3, boolean bl) {
        return this.newMethodItem((String)string, (String)string2, (String)string3, (boolean)bl).index;
    }

    private Item newInteger(int n) {
        this.key.set(n);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.putByte(3).putInt(n);
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key);
            this.put(item);
        }
        return item;
    }

    private Item newFloat(float f) {
        this.key.set(f);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.putByte(4).putInt(Float.floatToIntBits(f));
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key);
            this.put(item);
        }
        return item;
    }

    private Item newLong(long l) {
        this.key.set(l);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.putByte(5).putLong(l);
            item = new Item(this.index, this.key);
            this.put(item);
            this.index = (short)(this.index + 2);
        }
        return item;
    }

    private Item newDouble(double d) {
        this.key.set(d);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.putByte(6).putLong(Double.doubleToLongBits(d));
            item = new Item(this.index, this.key);
            this.put(item);
            this.index = (short)(this.index + 2);
        }
        return item;
    }

    private Item newString(String string) {
        this.key2.set(8, string, null, null);
        Item item = this.get(this.key2);
        if (item == null) {
            this.pool.put12(8, this.newUTF8(string));
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key2);
            this.put(item);
        }
        return item;
    }

    public int newNameType(String string, String string2) {
        this.key2.set(12, string, string2, null);
        Item item = this.get(this.key2);
        if (item == null) {
            this.put122(12, this.newUTF8(string), this.newUTF8(string2));
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key2);
            this.put(item);
        }
        return item.index;
    }

    private Item get(Item item) {
        int n = item.hashCode;
        Item item2 = this.items[n % this.items.length];
        while (item2 != null) {
            if (item2.hashCode == n && item.isEqualTo(item2)) {
                return item2;
            }
            item2 = item2.next;
        }
        return null;
    }

    private void put(Item item) {
        if (this.index > this.threshold) {
            Item[] itemArray = new Item[this.items.length * 2 + 1];
            for (int i = this.items.length - 1; i >= 0; --i) {
                Item item2 = this.items[i];
                while (item2 != null) {
                    int n = item2.hashCode % itemArray.length;
                    Item item3 = item2.next;
                    item2.next = itemArray[n];
                    itemArray[n] = item2;
                    item2 = item3;
                }
            }
            this.items = itemArray;
            this.threshold = (int)((double)this.items.length * 0.75);
        }
        int n = item.hashCode % this.items.length;
        item.next = this.items[n];
        this.items[n] = item;
    }

    private void put122(int n, int n2, int n3) {
        this.pool.put12(n, n2).putShort(n3);
    }

    static {
        byte[] byArray = new byte[220];
        String string = "AAAAAAAAAAAAAAAABCKLLDDDDDEEEEEEEEEEEEEEEEEEEEAAAAAAAADDDDDEEEEEEEEEEEEEEEEEEEEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAIIIIIIIIIIIIIIIIDNOAAAAAAGGGGGGGHAFBFAAFFAAQPIIJJIIIIIIIIIIIIIIIIII";
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(string.charAt(i) - 65);
        }
        TYPE = byArray;
    }
}

