/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.LogWriter;
import gov.nist.core.net.AddressResolver;
import gov.nist.core.net.NetworkLayer;
import gov.nist.javax.sip.EventScanner;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.LogRecordFactory;
import gov.nist.javax.sip.NistSipMessageFactoryImpl;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.stack.DefaultMessageLogFactory;
import gov.nist.javax.sip.stack.DefaultRouter;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerLog;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.PeerUnavailableException;
import javax.sip.ProviderDoesNotExistException;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TransportNotSupportedException;
import javax.sip.address.Router;

public class SipStackImpl
extends SIPTransactionStack
implements SipStack {
    EventScanner eventScanner;
    private Hashtable listeningPoints;
    private LinkedList sipProviders;
    boolean reEntrantListener;
    SipListener sipListener;
    boolean deliverTerminatedEventForAck = false;
    boolean deliverUnsolicitedNotify = false;

    protected SipStackImpl() {
        NistSipMessageFactoryImpl nistSipMessageFactoryImpl = new NistSipMessageFactoryImpl(this);
        super.setMessageFactory(nistSipMessageFactoryImpl);
        this.eventScanner = new EventScanner(this);
        this.listeningPoints = new Hashtable();
        this.sipProviders = new LinkedList();
    }

    private void reInitialize() {
        super.reInit();
        this.eventScanner = new EventScanner(this);
        this.listeningPoints = new Hashtable();
        this.sipProviders = new LinkedList();
        this.sipListener = null;
    }

    boolean isAutomaticDialogSupportEnabled() {
        return this.isAutomaticDialogSupportEnabled;
    }

    public SipStackImpl(Properties properties) throws PeerUnavailableException {
        this();
        String string;
        String string2;
        Object object;
        Object object2;
        Object object3;
        String string3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        String string4 = properties.getProperty("javax.sip.IP_ADDRESS");
        try {
            if (string4 != null) {
                super.setHostAddress(string4);
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new PeerUnavailableException("bad address " + string4);
        }
        String string5 = properties.getProperty("javax.sip.STACK_NAME");
        if (string5 == null) {
            throw new PeerUnavailableException("stack name is missing");
        }
        super.setStackName(string5);
        this.logWriter = new LogWriter(properties);
        this.serverLog = new ServerLog(this, properties);
        this.defaultRouter = new DefaultRouter(this, this.outboundProxy);
        String string6 = properties.getProperty("javax.sip.ROUTER_PATH");
        if (string6 == null) {
            string6 = "gov.nist.javax.sip.stack.DefaultRouter";
        }
        String string7 = properties.getProperty("javax.sip.OUTBOUND_PROXY");
        try {
            object8 = Class.forName(string6);
            object7 = new Class[]{SipStack.class, String.class};
            object6 = ((Class)object8).getConstructor((Class<?>)object7);
            object5 = new Object[]{this, string7};
            object4 = (Router)((Constructor)object6).newInstance((Object[])object5);
            super.setRouter((Router)object4);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.getLogWriter().logError("could not instantiate router -- invocation target problem", (Exception)invocationTargetException.getCause());
            throw new PeerUnavailableException("Cound not instantiate router - check constructor", (Throwable)invocationTargetException);
        }
        catch (Exception exception) {
            this.getLogWriter().logError("could not instantiate router", (Exception)exception.getCause());
            throw new PeerUnavailableException("Could not instantiate router", (Throwable)exception);
        }
        object8 = properties.getProperty("javax.sip.USE_ROUTER_FOR_ALL_URIS");
        this.useRouterForAll = true;
        if (object8 != null) {
            this.useRouterForAll = "true".equalsIgnoreCase((String)object8);
        }
        if ((object7 = properties.getProperty("javax.sip.EXTENSION_METHODS")) != null) {
            object6 = new StringTokenizer((String)object7);
            while (((StringTokenizer)object6).hasMoreTokens()) {
                object5 = ((StringTokenizer)object6).nextToken(":");
                if (((String)object5).equalsIgnoreCase("BYE") || ((String)object5).equalsIgnoreCase("INVITE") || ((String)object5).equalsIgnoreCase("SUBSCRIBE") || ((String)object5).equalsIgnoreCase("NOTIFY") || ((String)object5).equalsIgnoreCase("ACK") || ((String)object5).equalsIgnoreCase("OPTIONS")) {
                    throw new PeerUnavailableException("Bad extension method " + (String)object5);
                }
                this.addExtensionMethod((String)object5);
            }
        }
        this.isAutomaticDialogSupportEnabled = properties.getProperty("javax.sip.AUTOMATIC_DIALOG_SUPPORT", "on").equalsIgnoreCase("on");
        if (properties.getProperty("gov.nist.javax.sip.MAX_LISTENER_RESPONSE_TIME") != null) {
            this.maxListenerResponseTime = Integer.parseInt(properties.getProperty("gov.nist.javax.sip.MAX_LISTENER_RESPONSE_TIME"));
            if (this.maxListenerResponseTime <= 0) {
                throw new PeerUnavailableException("Bad configuration parameter gov.nist.javax.sip.MAX_LISTENER_RESPONSE_TIME : should be positive");
            }
        } else {
            this.maxListenerResponseTime = -1;
        }
        this.useTlsAccelerator = false;
        object6 = properties.getProperty("gov.nist.javax.sip.USE_TLS_ACCELERATOR");
        if (object6 != null && "true".equalsIgnoreCase(((String)object6).trim())) {
            this.useTlsAccelerator = true;
        }
        this.deliverTerminatedEventForAck = properties.getProperty("gov.nist.javax.sip.DELIVER_TERMINATED_EVENT_FOR_ACK", "false").equalsIgnoreCase("true");
        this.deliverUnsolicitedNotify = properties.getProperty("gov.nist.javax.sip.DELIVER_UNSOLICITED_NOTIFY", "false").equalsIgnoreCase("true");
        object5 = properties.getProperty("javax.sip.FORKABLE_EVENTS");
        if (object5 != null) {
            object4 = new StringTokenizer((String)object5);
            while (((StringTokenizer)object4).hasMoreTokens()) {
                string3 = ((StringTokenizer)object4).nextToken();
                this.forkedEvents.add(string3);
            }
        }
        if (properties.containsKey("gov.nist.javax.sip.NETWORK_LAYER")) {
            string3 = properties.getProperty("gov.nist.javax.sip.NETWORK_LAYER");
            try {
                object3 = Class.forName(string3);
                object2 = ((Class)object3).getConstructor(new Class[0]);
                this.networkLayer = (NetworkLayer)((Constructor)object2).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new PeerUnavailableException("can't find or instantiate NetworkLayer implementation: " + string3);
            }
        }
        if (properties.containsKey("gov.nist.javax.sip.ADDRESS_RESOLVER")) {
            object3 = properties.getProperty("gov.nist.javax.sip.ADDRESS_RESOLVER");
            try {
                object2 = Class.forName((String)object3);
                object = ((Class)object2).getConstructor(new Class[0]);
                this.addressResolver = (AddressResolver)((Constructor)object).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new PeerUnavailableException("can't find or instantiate AddressResolver implementation: " + (String)object3);
            }
        }
        if ((object3 = properties.getProperty("gov.nist.javax.sip.MAX_CONNECTIONS")) != null) {
            try {
                this.maxConnections = new Integer((String)object3);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("max connections - bad value " + numberFormatException.getMessage());
            }
        }
        if ((object2 = properties.getProperty("gov.nist.javax.sip.THREAD_POOL_SIZE")) != null) {
            try {
                this.threadPoolSize = new Integer((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("thread pool size - bad value " + numberFormatException.getMessage());
            }
        }
        if ((object = properties.getProperty("gov.nist.javax.sip.MAX_SERVER_TRANSACTIONS")) != null) {
            try {
                this.serverTransactionTableHighwaterMark = new Integer((String)object);
                this.serverTransactionTableLowaterMark = this.serverTransactionTableHighwaterMark * 80 / 100;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("transaction table size - bad value " + numberFormatException.getMessage());
            }
        }
        this.cacheServerConnections = true;
        String string8 = properties.getProperty("gov.nist.javax.sip.CACHE_SERVER_CONNECTIONS");
        if (string8 != null && "false".equalsIgnoreCase(string8.trim())) {
            this.cacheServerConnections = false;
        }
        this.cacheClientConnections = true;
        String string9 = properties.getProperty("gov.nist.javax.sip.CACHE_CLIENT_CONNECTIONS");
        if (string9 != null && "false".equalsIgnoreCase(string9.trim())) {
            this.cacheClientConnections = false;
        }
        if ((string2 = properties.getProperty("gov.nist.javax.sip.READ_TIMEOUT")) != null) {
            try {
                int n = Integer.parseInt(string2);
                if (n >= 100) {
                    this.readTimeout = n;
                } else {
                    System.out.println("Value too low " + string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Bad read timeout " + string2);
            }
        }
        if ((string = properties.getProperty("gov.nist.javax.sip.STUN_SERVER")) != null) {
            this.logWriter.logWarning("Ignoring obsolete property gov.nist.javax.sip.STUN_SERVER");
        }
        String string10 = properties.getProperty("gov.nist.javax.sip.MAX_MESSAGE_SIZE");
        try {
            if (string10 != null) {
                this.maxMessageSize = new Integer(string10);
                if (this.maxMessageSize < 4096) {
                    this.maxMessageSize = 4096;
                }
            } else {
                this.maxMessageSize = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("maxMessageSize - bad value " + numberFormatException.getMessage());
        }
        String string11 = properties.getProperty("gov.nist.javax.sip.REENTRANT_LISTENER");
        this.reEntrantListener = string11 != null && "true".equalsIgnoreCase(string11);
        String string12 = properties.getProperty("gov.nist.javax.sip.THREAD_AUDIT_INTERVAL_IN_MILLISECS");
        if (string12 != null) {
            try {
                this.getThreadAuditor().setPingIntervalInMillisecs(Long.valueOf(string12) / 2L);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("THREAD_AUDIT_INTERVAL_IN_MILLISECS - bad value [" + string12 + "] " + numberFormatException.getMessage());
            }
        }
        this.setNon2XXAckPassedToListener(Boolean.valueOf(properties.getProperty("gov.nist.javax.sip.PASS_INVITE_NON_2XX_ACK_TO_LISTENER", "false")));
        this.generateTimeStampHeader = Boolean.valueOf(properties.getProperty("gov.nist.javax.sip.AUTO_GENERATE_TIMESTAMP", "false"));
        String string13 = properties.getProperty("gov.nist.javax.sip.LOG_FACTORY");
        if (string13 != null) {
            try {
                Class<?> clazz = Class.forName(string13);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                this.logRecordFactory = (LogRecordFactory)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                System.out.println("Bad configuration value for LOG_FACTORY -- using default logger");
                this.logRecordFactory = new DefaultMessageLogFactory();
            }
        } else {
            this.logRecordFactory = new DefaultMessageLogFactory();
        }
    }

    public synchronized ListeningPoint createListeningPoint(String string, int n, String string2) throws TransportNotSupportedException, InvalidArgumentException {
        String string3;
        ListeningPointImpl listeningPointImpl;
        this.getLogWriter().logDebug("createListeningPoint : address = " + string + " port = " + n + " transport = " + string2);
        if (string == null) {
            throw new NullPointerException("Address for listening point is null!");
        }
        if (string2 == null) {
            throw new NullPointerException("null transport");
        }
        if (n <= 0) {
            throw new InvalidArgumentException("bad port");
        }
        if (!(string2.equalsIgnoreCase("UDP") || string2.equalsIgnoreCase("TLS") || string2.equalsIgnoreCase("TCP"))) {
            throw new TransportNotSupportedException("bad transport " + string2);
        }
        if (!this.isAlive()) {
            this.toExit = false;
            this.reInitialize();
        }
        if ((listeningPointImpl = (ListeningPointImpl)this.listeningPoints.get(string3 = ListeningPointImpl.makeKey(string, n, string2))) != null) {
            return listeningPointImpl;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            MessageProcessor messageProcessor = this.createMessageProcessor(inetAddress, n, string2);
            if (this.isLoggingEnabled()) {
                this.getLogWriter().logDebug("Created Message Processor: " + string + " port = " + n + " transport = " + string2);
            }
            listeningPointImpl = new ListeningPointImpl(this, n, string2);
            listeningPointImpl.messageProcessor = messageProcessor;
            messageProcessor.setListeningPoint(listeningPointImpl);
            this.listeningPoints.put(string3, listeningPointImpl);
            messageProcessor.start();
            return listeningPointImpl;
        }
        catch (IOException iOException) {
            this.getLogWriter().logError("Invalid argument address = " + string + " port = " + n + " transport = " + string2);
            throw new InvalidArgumentException(iOException.getMessage(), (Throwable)iOException);
        }
    }

    public SipProvider createSipProvider(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint");
        }
        if (this.getLogWriter().isLoggingEnabled()) {
            this.getLogWriter().logDebug("createSipProvider: " + listeningPoint);
        }
        ListeningPointImpl listeningPointImpl = (ListeningPointImpl)listeningPoint;
        if (listeningPointImpl.sipProvider != null) {
            throw new ObjectInUseException("Provider already attached!");
        }
        SipProviderImpl sipProviderImpl = new SipProviderImpl(this);
        sipProviderImpl.setListeningPoint(listeningPointImpl);
        listeningPointImpl.sipProvider = sipProviderImpl;
        this.sipProviders.add(sipProviderImpl);
        return sipProviderImpl;
    }

    public void deleteListeningPoint(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint arg");
        }
        ListeningPointImpl listeningPointImpl = (ListeningPointImpl)listeningPoint;
        super.removeMessageProcessor(listeningPointImpl.messageProcessor);
        String string = listeningPointImpl.getKey();
        this.listeningPoints.remove(string);
    }

    public void deleteSipProvider(SipProvider sipProvider) throws ObjectInUseException {
        if (sipProvider == null) {
            throw new NullPointerException("null provider arg");
        }
        SipProviderImpl sipProviderImpl = (SipProviderImpl)sipProvider;
        if (sipProviderImpl.sipListener != null) {
            throw new ObjectInUseException("SipProvider still has an associated SipListener!");
        }
        sipProviderImpl.removeListeningPoints();
        sipProviderImpl.stop();
        this.sipProviders.remove(sipProvider);
        if (this.sipProviders.isEmpty()) {
            this.stopStack();
        }
    }

    public String getIPAddress() {
        return super.getHostAddress();
    }

    public Iterator getListeningPoints() {
        return this.listeningPoints.values().iterator();
    }

    public boolean isRetransmissionFilterActive() {
        return true;
    }

    public Iterator getSipProviders() {
        return this.sipProviders.iterator();
    }

    public String getStackName() {
        return this.stackName;
    }

    public void finalize() {
        this.stopStack();
    }

    public ListeningPoint createListeningPoint(int n, String string) throws TransportNotSupportedException, InvalidArgumentException {
        if (this.stackAddress == null) {
            throw new NullPointerException("Stack does not have a default IP Address!");
        }
        return this.createListeningPoint(this.stackAddress, n, string);
    }

    public void stop() {
        if (this.getLogWriter().isLoggingEnabled()) {
            this.getLogWriter().logDebug("stopStack -- stoppping the stack");
        }
        this.stopStack();
        this.sipProviders = new LinkedList();
        this.listeningPoints = new Hashtable();
        this.eventScanner.forceStop();
        this.eventScanner = null;
    }

    public void start() throws ProviderDoesNotExistException, SipException {
        if (this.eventScanner == null) {
            this.eventScanner = new EventScanner(this);
        }
    }

    protected SipListener getSipListener() {
        return this.sipListener;
    }

    public LogRecordFactory getLogRecordFactory() {
        return this.logRecordFactory;
    }
}

