/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.ContactList;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.parser.AddressParametersParser;
import gov.nist.javax.sip.parser.Lexer;
import java.text.ParseException;
import java.util.Iterator;
import javax.sip.address.URI;

public class ContactParser
extends AddressParametersParser {
    public ContactParser(String string) {
        super(string);
    }

    protected ContactParser(Lexer lexer) {
        super(lexer);
        this.lexer = lexer;
    }

    public SIPHeader parse() throws ParseException {
        this.headerName(2087);
        ContactList contactList = new ContactList();
        while (true) {
            Contact contact = new Contact();
            if (this.lexer.lookAhead(0) == '*') {
                char c = this.lexer.lookAhead(1);
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                    this.lexer.match(42);
                    contact.setWildCardFlag(true);
                } else {
                    super.parse(contact);
                }
            } else {
                super.parse(contact);
            }
            AddressImpl addressImpl = (AddressImpl)contact.getAddress();
            URI uRI = contact.getAddress().getURI();
            if (addressImpl.getAddressType() == 2 && uRI instanceof SipUri) {
                SipUri sipUri = (SipUri)uRI;
                Iterator iterator = sipUri.getParameterNames();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = sipUri.getParameter(string);
                    sipUri.removeParameter(string);
                    contact.setParameter(string, string2);
                }
            }
            contactList.add(contact);
            this.lexer.SPorHT();
            if (this.lexer.lookAhead(0) != ',') break;
            this.lexer.match(44);
            this.lexer.SPorHT();
        }
        if (this.lexer.lookAhead(0) != '\n' && this.lexer.lookAhead(0) != '\u0000') {
            throw this.createParseException("unexpected char");
        }
        return contactList;
    }
}

