/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.incoming;

import net.sf.jml.Email;
import net.sf.jml.MsnList;
import net.sf.jml.MsnProtocol;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnContactImpl;
import net.sf.jml.impl.MsnContactListImpl;
import net.sf.jml.protocol.MsnIncomingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.util.StringUtils;

public class IncomingADC
extends MsnIncomingMessage {
    public IncomingADC(MsnProtocol msnProtocol) {
        super(msnProtocol);
    }

    public MsnList getList() {
        return MsnList.parseStr(this.getParam(0));
    }

    private int getSyntaxType() {
        MsnList msnList = this.getList();
        if (msnList == MsnList.RL) {
            return 4;
        }
        if (msnList == MsnList.FL) {
            if (this.getParamCount() == 4) {
                return 2;
            }
            return 3;
        }
        return 1;
    }

    public String getId() {
        switch (this.getSyntaxType()) {
            case 2: {
                return this.getParam(3).substring(2);
            }
            case 3: {
                return this.getParam(1).substring(2);
            }
        }
        return null;
    }

    public Email getEmail() {
        switch (this.getSyntaxType()) {
            case 1: 
            case 2: 
            case 4: {
                return Email.parseStr(this.getParam(1).substring(2));
            }
        }
        return null;
    }

    public String getFriendlyName() {
        switch (this.getSyntaxType()) {
            case 2: {
                return StringUtils.urlDecode(this.getParam(2)).substring(2);
            }
        }
        return null;
    }

    public String getGroupId() {
        switch (this.getSyntaxType()) {
            case 3: {
                return this.getParam(2);
            }
        }
        return null;
    }

    protected void messageReceived(MsnSession msnSession) {
        super.messageReceived(msnSession);
        MsnContactListImpl msnContactListImpl = (MsnContactListImpl)msnSession.getMessenger().getContactList();
        MsnList msnList = this.getList();
        MsnContactImpl msnContactImpl = null;
        int n = this.getSyntaxType();
        switch (n) {
            case 1: {
                msnContactImpl = (MsnContactImpl)msnContactListImpl.getContactByEmail(this.getEmail());
                if (msnContactImpl == null) break;
                msnContactImpl.setInList(msnList, true);
                break;
            }
            case 3: {
                msnContactImpl = (MsnContactImpl)msnContactListImpl.getContactById(this.getId());
                if (msnContactImpl == null) break;
                msnContactImpl.addBelongGroup(this.getGroupId());
                break;
            }
            case 2: 
            case 4: {
                msnContactImpl = (MsnContactImpl)msnContactListImpl.getContactByEmail(this.getEmail());
                if (msnContactImpl == null) {
                    msnContactImpl = new MsnContactImpl(msnContactListImpl);
                    msnContactImpl.setEmail(this.getEmail());
                    msnContactImpl.setFriendlyName(this.getFriendlyName());
                    msnContactImpl.setDisplayName(msnContactImpl.getFriendlyName());
                    msnContactListImpl.addContact(msnContactImpl);
                }
                if (n == 2) {
                    msnContactImpl.setId(this.getId());
                    msnContactImpl.setInList(MsnList.FL, true);
                    ((AbstractMessenger)msnSession.getMessenger()).fireContactAddCompleted(msnContactImpl);
                    break;
                }
                msnContactImpl.setInList(MsnList.RL, true);
                ((AbstractMessenger)msnSession.getMessenger()).fireContactAddedMe(msnContactImpl);
            }
        }
    }
}

