/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network.event;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openymsg.network.FireEvent;
import org.openymsg.network.ServiceType;
import org.openymsg.network.Session;
import org.openymsg.network.event.SessionListener;

public class WaitListener
implements SessionListener {
    BlockingQueue<FireEvent> events = new ArrayBlockingQueue<FireEvent>(50);
    private static final Log log = LogFactory.getLog(WaitListener.class);
    private Session session;

    public WaitListener(Session session) {
        this.session = session;
        session.addSessionListener(this);
    }

    public void dispatch(FireEvent event) {
        log.debug((Object)("session :" + this.session.getLoginIdentity().getId() + "  event: " + (Object)((Object)event.getType())));
        this.events.offer(event);
    }

    public FireEvent waitForEvent(int seconds, ServiceType type) {
        try {
            int nt = seconds * 10;
            for (int i = 0; i < 100; ++i) {
                FireEvent ret = this.events.poll(nt, TimeUnit.MILLISECONDS);
                if (ret == null || !ret.getType().equals((Object)type)) continue;
                return ret;
            }
            return null;
        }
        catch (InterruptedException e) {
            log.error((Object)"exception, waitForEvent will return null", (Throwable)e);
            return null;
        }
    }

    public FireEvent waitForEvent(int seconds) {
        try {
            return this.events.poll(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error((Object)"exception, waitForEvent will return null", (Throwable)e);
            return null;
        }
    }

    public void clearEvents() {
        this.events.clear();
    }
}

