/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import java.io.IOException;
import java.util.ArrayList;
import pl.mn.communicator.AbstractChat;
import pl.mn.communicator.GGException;
import pl.mn.communicator.IChat;
import pl.mn.communicator.IGroupChat;
import pl.mn.communicator.IIncommingMessage;
import pl.mn.communicator.MessageStatus;
import pl.mn.communicator.OutgoingMessage;
import pl.mn.communicator.Session;
import pl.mn.communicator.packet.out.GGSendMsg;

public class GroupChat
extends AbstractChat
implements IGroupChat {
    private ArrayList m_recipientUins = new ArrayList();

    GroupChat(Session session) {
        this(session, new int[0]);
    }

    GroupChat(Session session, int[] recipientUins) {
        super(session);
        for (int i = 0; i < recipientUins.length; ++i) {
            this.addRecipient(recipientUins[i]);
        }
    }

    public IChat sendMessage(String messageBody) throws GGException {
        if (messageBody == null) {
            throw new NullPointerException("messageBody cannot be less than 0");
        }
        if (this.m_recipientUins.isEmpty()) {
            throw new GGException("Unable to send message, at least one recipient is required");
        }
        int recipientUin = (Integer)this.m_recipientUins.get(0);
        GGSendMsg sendMsg = new GGSendMsg(OutgoingMessage.createChatMessage(recipientUin, messageBody));
        for (int i = 1; i < this.m_recipientUins.size(); ++i) {
            int recipient = (Integer)this.m_recipientUins.get(i);
            sendMsg.addAdditionalRecipient(recipient);
        }
        try {
            this.m_session.getSessionAccessor().sendPackage(sendMsg);
        }
        catch (IOException ex) {
            throw new GGException("Unable to send group chat message");
        }
        return this;
    }

    public void addRecipient(int recipientUin) {
        if (recipientUin < 0) {
            throw new IllegalArgumentException("recipientUin cannot be less than 0");
        }
        this.m_recipientUins.add(new Integer(recipientUin));
    }

    public void removeRecipient(int recipientUin) {
        if (recipientUin < 0) {
            throw new IllegalArgumentException("recipientUin cannot be less than 0");
        }
        this.m_recipientUins.remove(new Integer(recipientUin));
    }

    public int[] getRecipientUins() {
        int[] recipientUins = new int[this.m_recipientUins.size()];
        for (int i = 0; i < this.m_recipientUins.size(); ++i) {
            recipientUins[i] = (Integer)this.m_recipientUins.get(i);
        }
        return recipientUins;
    }

    protected boolean acceptsIncoming(IIncommingMessage incomingMessage) {
        return this.isRegisteredRecipient(incomingMessage.getMessageID());
    }

    protected boolean acceptsOutgoing(int uin, int messageID, MessageStatus deliveryStatus) {
        return this.isRegisteredRecipient(uin);
    }

    private boolean isRegisteredRecipient(int uin) {
        for (int i = 0; i < this.m_recipientUins.size(); ++i) {
            if (uin != (Integer)this.m_recipientUins.get(i)) continue;
            return true;
        }
        return false;
    }
}

