/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.util.ByteUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapConfig
implements DataSerializable {
    public static final int MIN_BACKUP_COUNT = 0;
    public static final int DEFAULT_BACKUP_COUNT = 1;
    public static final int MAX_BACKUP_COUNT = 6;
    public static final int MIN_EVICTION_PERCENTAGE = 0;
    public static final int DEFAULT_EVICTION_PERCENTAGE = 25;
    public static final int MAX_EVICTION_PERCENTAGE = 100;
    public static final int DEFAULT_EVICTION_DELAY_SECONDS = 3;
    public static final int DEFAULT_TTL_SECONDS = 0;
    public static final int DEFAULT_MAX_IDLE_SECONDS = 0;
    public static final int DEFAULT_MAX_SIZE = Integer.MAX_VALUE;
    public static final String ATOMIC_LONG_MAP_NAME = "c:__hz_AtomicLongMap";
    public static final String COUNT_DOWN_LATCH_MAP_NAME = "c:__hz_CountDownLatchMap";
    public static final String SEMAPHORE_MAP_NAME = "c:__hz_SemaphoreMap";
    public static final String DEFAULT_EVICTION_POLICY = "NONE";
    public static final String DEFAULT_MERGE_POLICY = "hz.ADD_NEW_ENTRY";
    public static final boolean DEFAULT_CACHE_VALUE = true;
    private String name = null;
    private int backupCount = 1;
    private int asyncBackupCount = 0;
    private int evictionPercentage = 25;
    private int timeToLiveSeconds = 0;
    private int maxIdleSeconds = 0;
    private int evictionDelaySeconds = 3;
    private MaxSizeConfig maxSizeConfig = new MaxSizeConfig();
    private String evictionPolicy = "NONE";
    private boolean valueIndexed = false;
    private MapStoreConfig mapStoreConfig = null;
    private NearCacheConfig nearCacheConfig;
    private boolean readBackupData = false;
    private boolean cacheValue = true;
    private String mergePolicy = "hz.ADD_NEW_ENTRY";
    private WanReplicationRef wanReplicationRef;
    private List<EntryListenerConfig> listenerConfigs;
    private List<MapIndexConfig> mapIndexConfigs;
    private StorageType storageType = null;
    private boolean clearQuick = false;

    public MapConfig(String name) {
        this.name = name;
    }

    public MapConfig() {
    }

    public MapConfig(MapConfig config) {
        this.name = config.name;
        this.backupCount = config.backupCount;
        this.evictionPercentage = config.evictionPercentage;
        this.timeToLiveSeconds = config.timeToLiveSeconds;
        this.maxIdleSeconds = config.maxIdleSeconds;
        this.evictionDelaySeconds = config.evictionDelaySeconds;
        this.maxSizeConfig = config.maxSizeConfig;
        this.evictionPolicy = config.evictionPolicy;
        this.valueIndexed = config.valueIndexed;
        this.mapStoreConfig = config.mapStoreConfig;
        this.nearCacheConfig = config.nearCacheConfig;
        this.readBackupData = config.readBackupData;
        this.cacheValue = config.cacheValue;
        this.mergePolicy = config.mergePolicy;
        this.clearQuick = config.clearQuick;
    }

    public String getName() {
        return this.name;
    }

    public MapConfig setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isValueIndexed() {
        return this.valueIndexed;
    }

    public MapConfig setValueIndexed(boolean valueIndexed) {
        this.valueIndexed = valueIndexed;
        return this;
    }

    public boolean isCacheValue() {
        return this.cacheValue;
    }

    public MapConfig setCacheValue(boolean cacheValue) {
        this.cacheValue = cacheValue;
        return this;
    }

    public boolean isClearQuick() {
        return this.clearQuick;
    }

    public MapConfig setClearQuick(boolean clearQuick) {
        this.clearQuick = clearQuick;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public MapConfig setBackupCount(int backupCount) {
        if (backupCount < 0) {
            throw new IllegalArgumentException("map backup count must be equal to or bigger than 0");
        }
        if (backupCount + this.asyncBackupCount > 6) {
            throw new IllegalArgumentException("total (sync + async) map backup count must be less than 6");
        }
        this.backupCount = backupCount;
        return this;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public MapConfig setAsyncBackupCount(int asyncBackupCount) {
        if (asyncBackupCount < 0) {
            throw new IllegalArgumentException("map async backup count must be equal to or bigger than 0");
        }
        if (this.backupCount + asyncBackupCount > 6) {
            throw new IllegalArgumentException("total (sync + async) map backup count must be less than 6");
        }
        this.asyncBackupCount = asyncBackupCount;
        return this;
    }

    public MapConfig setBackupCounts(int backupCount, int asyncBackupCount) {
        if (backupCount < 0 || asyncBackupCount < 0) {
            throw new IllegalArgumentException("map backup count must be equal to or bigger than 0");
        }
        if (backupCount + asyncBackupCount > 6) {
            throw new IllegalArgumentException("total (sync + async) map backup count must be less than 6");
        }
        this.backupCount = backupCount;
        this.asyncBackupCount = asyncBackupCount;
        return this;
    }

    public int getEvictionPercentage() {
        return this.evictionPercentage;
    }

    public MapConfig setEvictionPercentage(int evictionPercentage) {
        if (evictionPercentage < 0) {
            throw new IllegalArgumentException("eviction percentage must be greater or equal than 0");
        }
        if (evictionPercentage > 100) {
            throw new IllegalArgumentException("eviction percentage must be smaller or equal than 100");
        }
        this.evictionPercentage = evictionPercentage;
        return this;
    }

    public int getEvictionDelaySeconds() {
        return this.evictionDelaySeconds;
    }

    public MapConfig setEvictionDelaySeconds(int evictionDelaySeconds) {
        this.evictionDelaySeconds = evictionDelaySeconds;
        return this;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public MapConfig setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
        return this;
    }

    public int getMaxIdleSeconds() {
        return this.maxIdleSeconds;
    }

    public MapConfig setMaxIdleSeconds(int maxIdleSeconds) {
        this.maxIdleSeconds = maxIdleSeconds;
        return this;
    }

    public int getMaxSize() {
        return this.maxSizeConfig.getSize();
    }

    public MapConfig setMaxSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("map max size must be greater than 0");
        }
        this.maxSizeConfig.setSize(maxSize);
        return this;
    }

    public MaxSizeConfig getMaxSizeConfig() {
        return this.maxSizeConfig;
    }

    public MapConfig setMaxSizeConfig(MaxSizeConfig maxSizeConfig) {
        this.maxSizeConfig = maxSizeConfig;
        return this;
    }

    public String getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public MapConfig setEvictionPolicy(String evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public MapStoreConfig getMapStoreConfig() {
        return this.mapStoreConfig;
    }

    public MapConfig setMapStoreConfig(MapStoreConfig mapStoreConfig) {
        this.mapStoreConfig = mapStoreConfig;
        return this;
    }

    public NearCacheConfig getNearCacheConfig() {
        return this.nearCacheConfig;
    }

    public MapConfig setNearCacheConfig(NearCacheConfig nearCacheConfig) {
        this.nearCacheConfig = nearCacheConfig;
        return this;
    }

    public String getMergePolicy() {
        return this.mergePolicy;
    }

    public MapConfig setMergePolicy(String mergePolicyName) {
        this.mergePolicy = mergePolicyName;
        return this;
    }

    public boolean isReadBackupData() {
        return this.readBackupData;
    }

    public MapConfig setReadBackupData(boolean readBackupData) {
        this.readBackupData = readBackupData;
        return this;
    }

    public WanReplicationRef getWanReplicationRef() {
        return this.wanReplicationRef;
    }

    public MapConfig setWanReplicationRef(WanReplicationRef wanReplicationRef) {
        this.wanReplicationRef = wanReplicationRef;
        return this;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public MapConfig setStorageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    public MapConfig addEntryListenerConfig(EntryListenerConfig listenerConfig) {
        this.getEntryListenerConfigs().add(listenerConfig);
        return this;
    }

    public List<EntryListenerConfig> getEntryListenerConfigs() {
        if (this.listenerConfigs == null) {
            this.listenerConfigs = new ArrayList<EntryListenerConfig>();
        }
        return this.listenerConfigs;
    }

    public MapConfig setEntryListenerConfigs(List<EntryListenerConfig> listenerConfigs) {
        this.listenerConfigs = listenerConfigs;
        return this;
    }

    public MapConfig addMapIndexConfig(MapIndexConfig mapIndexConfig) {
        this.getMapIndexConfigs().add(mapIndexConfig);
        return this;
    }

    public List<MapIndexConfig> getMapIndexConfigs() {
        if (this.mapIndexConfigs == null) {
            this.mapIndexConfigs = new ArrayList<MapIndexConfig>();
        }
        return this.mapIndexConfigs;
    }

    public MapConfig setMapIndexConfigs(List<MapIndexConfig> mapIndexConfigs) {
        this.mapIndexConfigs = mapIndexConfigs;
        return this;
    }

    public boolean isCompatible(MapConfig other) {
        if (this == other) {
            return true;
        }
        return other != null && (this.name != null ? this.name.equals(other.name) : other.name == null) && this.backupCount == other.backupCount && this.asyncBackupCount == other.asyncBackupCount && this.evictionDelaySeconds == other.evictionDelaySeconds && this.evictionPercentage == other.evictionPercentage && this.maxIdleSeconds == other.maxIdleSeconds && (this.maxSizeConfig.getSize() == other.maxSizeConfig.getSize() || Math.min(this.maxSizeConfig.getSize(), other.maxSizeConfig.getSize()) == 0 && Math.max(this.maxSizeConfig.getSize(), other.maxSizeConfig.getSize()) == Integer.MAX_VALUE) && this.timeToLiveSeconds == other.timeToLiveSeconds && this.readBackupData == other.readBackupData && this.clearQuick == other.clearQuick && this.valueIndexed == other.valueIndexed;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.backupCount;
        result = 31 * result + this.asyncBackupCount;
        result = 31 * result + this.evictionDelaySeconds;
        result = 31 * result + this.evictionPercentage;
        result = 31 * result + (this.evictionPolicy == null ? 0 : this.evictionPolicy.hashCode());
        result = 31 * result + (this.mapStoreConfig == null ? 0 : this.mapStoreConfig.hashCode());
        result = 31 * result + this.maxIdleSeconds;
        result = 31 * result + this.maxSizeConfig.getSize();
        result = 31 * result + (this.mergePolicy == null ? 0 : this.mergePolicy.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nearCacheConfig == null ? 0 : this.nearCacheConfig.hashCode());
        result = 31 * result + this.timeToLiveSeconds;
        result = 31 * result + (this.readBackupData ? 1231 : 1237);
        result = 31 * result + (this.clearQuick ? 1231 : 1237);
        result = 31 * result + (this.valueIndexed ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapConfig)) {
            return false;
        }
        MapConfig other = (MapConfig)obj;
        return (this.name != null ? this.name.equals(other.name) : other.name == null) && this.backupCount == other.backupCount && this.asyncBackupCount == other.asyncBackupCount && this.evictionDelaySeconds == other.evictionDelaySeconds && this.evictionPercentage == other.evictionPercentage && this.maxIdleSeconds == other.maxIdleSeconds && this.maxSizeConfig.getSize() == other.maxSizeConfig.getSize() && this.timeToLiveSeconds == other.timeToLiveSeconds && this.readBackupData == other.readBackupData && this.valueIndexed == other.valueIndexed && (this.mergePolicy != null ? this.mergePolicy.equals(other.mergePolicy) : other.mergePolicy == null) && (this.evictionPolicy != null ? this.evictionPolicy.equals(other.evictionPolicy) : other.evictionPolicy == null) && (this.mapStoreConfig != null ? this.mapStoreConfig.equals(other.mapStoreConfig) : other.mapStoreConfig == null) && (this.nearCacheConfig != null ? this.nearCacheConfig.equals(other.nearCacheConfig) : other.nearCacheConfig == null);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.name = in.readUTF();
        this.backupCount = in.readInt();
        this.asyncBackupCount = in.readInt();
        this.evictionPercentage = in.readInt();
        this.timeToLiveSeconds = in.readInt();
        this.maxIdleSeconds = in.readInt();
        this.evictionDelaySeconds = in.readInt();
        this.maxSizeConfig.readData(in);
        boolean[] b = ByteUtil.fromByte(in.readByte());
        this.valueIndexed = b[0];
        this.readBackupData = b[1];
        this.cacheValue = b[2];
        this.evictionPolicy = in.readUTF();
        this.mergePolicy = in.readUTF();
        this.clearQuick = in.readBoolean();
        boolean hasNearCacheConfig = in.readBoolean();
        if (hasNearCacheConfig) {
            this.nearCacheConfig = new NearCacheConfig();
            this.nearCacheConfig.readData(in);
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.backupCount);
        out.writeInt(this.asyncBackupCount);
        out.writeInt(this.evictionPercentage);
        out.writeInt(this.timeToLiveSeconds);
        out.writeInt(this.maxIdleSeconds);
        out.writeInt(this.evictionDelaySeconds);
        this.maxSizeConfig.writeData(out);
        out.writeByte(ByteUtil.toByte(this.valueIndexed, this.readBackupData, this.cacheValue));
        out.writeUTF(this.evictionPolicy);
        out.writeUTF(this.mergePolicy);
        out.writeBoolean(this.clearQuick);
        if (this.nearCacheConfig == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.nearCacheConfig.writeData(out);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MapConfig");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", backupCount=").append(this.backupCount);
        sb.append(", asyncBackupCount=").append(this.asyncBackupCount);
        sb.append(", timeToLiveSeconds=").append(this.timeToLiveSeconds);
        sb.append(", maxIdleSeconds=").append(this.maxIdleSeconds);
        sb.append(", evictionPolicy='").append(this.evictionPolicy).append('\'');
        sb.append(", evictionPercentage=").append(this.evictionPercentage);
        sb.append(", evictionDelaySeconds=").append(this.evictionDelaySeconds);
        sb.append(", maxSizeConfig=").append(this.maxSizeConfig);
        sb.append(", cacheValue=").append(this.cacheValue);
        sb.append(", readBackupData=").append(this.readBackupData);
        sb.append(", nearCacheConfig=").append(this.nearCacheConfig);
        sb.append(", mapStoreConfig=").append(this.mapStoreConfig);
        sb.append(", mergePolicy='").append(this.mergePolicy).append('\'');
        sb.append(", wanReplicationRef=").append(this.wanReplicationRef);
        sb.append(", listenerConfigs=").append(this.listenerConfigs);
        sb.append(", valueIndexed=").append(this.valueIndexed);
        sb.append(", mapIndexConfigs=").append(this.mapIndexConfigs);
        sb.append(", storageType=").append((Object)this.storageType);
        sb.append(", clearQuick=").append(this.clearQuick);
        sb.append('}');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StorageType {
        HEAP,
        OFFHEAP;

    }
}

