/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.gsm;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.media.AudioFormatCompleter;
import org.jitsi.impl.neomedia.codec.audio.gsm.GSMDecoderUtil;

public class Decoder
extends AbstractCodec {
    private Buffer innerBuffer = new Buffer();
    private static final int PCM_BYTES = 320;
    private static final int GSM_BYTES = 33;
    private int innerDataLength = 0;
    byte[] innerContent;
    protected Format[] outputFormats = new Format[]{new AudioFormat("LINEAR", 8000.0, 16, 1, -1, 1, -1, -1.0, Format.byteArray)};
    private static final boolean TRACE = false;

    @Override
    public String getName() {
        return "GSM Decoder";
    }

    public Decoder() {
        this.inputFormats = new Format[]{new AudioFormat("gsm", 8000.0, 8, 1, -1, 1, 264, -1.0, Format.byteArray)};
    }

    @Override
    public Format setOutputFormat(Format format) {
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        AudioFormat audioFormat = (AudioFormat)format;
        return super.setOutputFormat(AudioFormatCompleter.complete(audioFormat));
    }

    @Override
    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.outputFormats;
        }
        if (!(input instanceof AudioFormat)) {
            return new Format[]{null};
        }
        AudioFormat inputCast = (AudioFormat)input;
        if (!inputCast.getEncoding().equals("gsm") || inputCast.getSampleSizeInBits() != 8 && inputCast.getSampleSizeInBits() != -1 || inputCast.getChannels() != 1 && inputCast.getChannels() != -1 || inputCast.getSigned() != 1 && inputCast.getSigned() != -1 || inputCast.getFrameSizeInBits() != 264 && inputCast.getFrameSizeInBits() != -1 || inputCast.getDataType() != null && inputCast.getDataType() != Format.byteArray) {
            return new Format[]{null};
        }
        AudioFormat result = new AudioFormat("LINEAR", inputCast.getSampleRate(), 16, 1, inputCast.getEndian(), 1, 16, -1.0, Format.byteArray);
        return new Format[]{result};
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        int result;
        byte[] inputContent = new byte[inputBuffer.getLength()];
        System.arraycopy(inputBuffer.getData(), inputBuffer.getOffset(), inputContent, 0, inputContent.length);
        byte[] mergedContent = this.mergeArrays((byte[])this.innerBuffer.getData(), inputContent);
        this.innerBuffer.setData(mergedContent);
        this.innerBuffer.setLength(mergedContent.length);
        this.innerDataLength = this.innerBuffer.getLength();
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        byte[] outputBufferData = (byte[])outputBuffer.getData();
        if (outputBufferData == null || outputBufferData.length < 320 * this.innerBuffer.getLength() / 33) {
            outputBufferData = new byte[320 * (this.innerBuffer.getLength() / 33)];
            outputBuffer.setData(outputBufferData);
        }
        if (this.innerBuffer.getLength() < 33) {
            result = 4;
        } else {
            boolean bigEndian = ((AudioFormat)this.outputFormat).getEndian() == 1;
            outputBufferData = new byte[320 * (this.innerBuffer.getLength() / 33)];
            outputBuffer.setData(outputBufferData);
            outputBuffer.setLength(320 * (this.innerBuffer.getLength() / 33));
            GSMDecoderUtil.gsmDecode(bigEndian, (byte[])this.innerBuffer.getData(), inputBuffer.getOffset(), this.innerBuffer.getLength(), outputBufferData);
            outputBuffer.setFormat(this.outputFormat);
            result = 0;
            byte[] temp = new byte[this.innerDataLength - this.innerDataLength / 33 * 33];
            this.innerContent = (byte[])this.innerBuffer.getData();
            System.arraycopy(this.innerContent, this.innerDataLength / 33 * 33, temp, 0, temp.length);
            outputBuffer.setOffset(0);
            this.innerBuffer.setLength(temp.length);
            this.innerBuffer.setData(temp);
        }
        return result;
    }

    private byte[] mergeArrays(byte[] arr1, byte[] arr2) {
        if (arr1 == null) {
            return arr2;
        }
        if (arr2 == null) {
            return arr1;
        }
        byte[] merged = new byte[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, merged, 0, arr1.length);
        System.arraycopy(arr2, 0, merged, arr1.length, arr2.length);
        return merged;
    }

    @Override
    public Format setInputFormat(Format arg0) {
        return super.setInputFormat(arg0);
    }
}

