/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.ulaw;

import java.util.logging.Logger;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.AbstractDePacketizer;
import net.sf.fmj.utility.LoggerSingleton;

public class DePacketizer
extends AbstractDePacketizer {
    private static final Logger logger = LoggerSingleton.logger;
    protected Format[] outputFormats = new Format[]{new AudioFormat("ULAW", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)};

    public DePacketizer() {
        this.inputFormats = new Format[]{new AudioFormat("ULAW/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)};
    }

    public void close() {
    }

    public String getName() {
        return "ULAW DePacketizer";
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (!(format instanceof AudioFormat)) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + format);
            return new Format[]{null};
        }
        AudioFormat audioFormat = (AudioFormat)format;
        if (!audioFormat.getEncoding().equals("ULAW/rtp")) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + format);
            return new Format[]{null};
        }
        AudioFormat audioFormat2 = new AudioFormat("ULAW", audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getEndian(), audioFormat.getSigned(), audioFormat.getFrameSizeInBits(), audioFormat.getFrameRate(), audioFormat.getDataType());
        return new Format[]{audioFormat2};
    }

    public void open() {
    }

    public Format setInputFormat(Format format) {
        return super.setInputFormat(format);
    }

    public Format setOutputFormat(Format format) {
        return super.setOutputFormat(format);
    }
}

