/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls;

import java.awt.Component;
import java.util.EventListener;
import javax.media.Control;
import javax.media.Controller;
import javax.media.NotRealizedError;
import net.sf.fmj.ejmf.toolkit.gui.controls.Skin;

public abstract class AbstractListenerControl
implements Control {
    private EventListener currListener;
    private EventListener defaultListener;
    private Controller controller;
    private Component component;
    protected final Skin skin;
    private boolean isOperational = true;

    protected AbstractListenerControl(Skin skin) {
        this.skin = skin;
        this.component = this.createControlComponent(skin);
        this.initListener(this.createControlListener());
    }

    protected AbstractListenerControl(Skin skin, Controller controller) {
        this(skin);
        this.setController(controller);
    }

    protected abstract void addControlListener(EventListener var1);

    protected abstract Component createControlComponent(Skin var1);

    protected abstract EventListener createControlListener();

    public Component getControlComponent() {
        return this.component;
    }

    public Controller getController() {
        return this.controller;
    }

    protected EventListener getDefaultControlListener() {
        return this.defaultListener;
    }

    protected void initListener(EventListener eventListener) {
        this.currListener = this.defaultListener = eventListener;
        this.addControlListener(this.defaultListener);
    }

    public boolean isOperational() {
        return this.isOperational;
    }

    protected abstract void removeControlListener(EventListener var1);

    protected void setComponent(Component component) {
        this.setComponentAndListener(component, this.getDefaultControlListener());
    }

    protected void setComponentAndListener(Component component, EventListener eventListener) {
        this.component = component;
        this.setControlListener(eventListener);
    }

    public void setController(Controller controller) {
        if (this.controller != null) {
            throw new IllegalArgumentException("Controller already set on Control");
        }
        if (controller.getState() < 300) {
            throw new NotRealizedError("Control requires realized Controller");
        }
        this.controller = controller;
        this.setControllerHook(controller);
    }

    protected void setControllerHook(Controller controller) {
    }

    protected void setControlListener(EventListener eventListener) {
        if (this.currListener != null) {
            this.removeControlListener(this.currListener);
        }
        this.addControlListener(eventListener);
        this.currListener = eventListener;
    }

    protected void setOperational(boolean bl) {
        this.isOperational = bl;
    }

    public String toString() {
        return this.getClass().getName();
    }
}

