/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmyspaceiml;

import java.util.HashMap;
import junit.framework.TestCase;
import net.sf.jmyspaceiml.MSIMParser;

public class TestMSIMParser
extends TestCase {
    public void testOne() {
        String input = "\\k1\\v1\\k2\\v2\\xxx\\yyy\\final\\";
        HashMap<String, Object> hash = MSIMParser.parse(input);
        TestMSIMParser.assertEquals((int)3, (int)hash.size());
        TestMSIMParser.assertTrue((boolean)hash.containsKey("k1"));
        TestMSIMParser.assertEquals((Object)"v1", (Object)hash.get("k1"));
        TestMSIMParser.assertTrue((boolean)hash.containsKey("k2"));
        TestMSIMParser.assertEquals((Object)"v2", (Object)hash.get("k2"));
        TestMSIMParser.assertTrue((boolean)hash.containsKey("xxx"));
        TestMSIMParser.assertEquals((Object)"yyy", (Object)hash.get("xxx"));
        TestMSIMParser.assertFalse((boolean)hash.containsKey("final"));
        TestMSIMParser.assertFalse((boolean)hash.containsValue("final"));
    }

    public void testError() {
        String input = "\\error\\\\err\\260\\fatal\\\\errmsg\\The password provided is incorrect.\\id\\1\\final\\";
        HashMap<String, Object> hash = MSIMParser.parse(input);
        TestMSIMParser.assertEquals((int)5, (int)hash.size());
        TestMSIMParser.assertTrue((boolean)hash.containsKey("errmsg"));
        TestMSIMParser.assertEquals((Object)"The password provided is incorrect.", (Object)hash.get("errmsg"));
        TestMSIMParser.assertTrue((boolean)hash.containsKey("err"));
        TestMSIMParser.assertEquals((Object)"260", (Object)hash.get("err"));
        TestMSIMParser.assertTrue((boolean)hash.containsKey("error"));
        TestMSIMParser.assertEquals((Object)"", (Object)hash.get("error"));
        TestMSIMParser.assertTrue((boolean)hash.containsKey("id"));
        TestMSIMParser.assertEquals((Object)"1", (Object)hash.get("id"));
        TestMSIMParser.assertTrue((boolean)hash.containsKey("fatal"));
        TestMSIMParser.assertEquals((Object)"", (Object)hash.get("fatal"));
        TestMSIMParser.assertFalse((boolean)hash.containsKey("final"));
        TestMSIMParser.assertFalse((boolean)hash.containsValue("final"));
    }

    public void testIncomingMessage() {
        String input = "\\bm\\1\\f\\6221\\cv\\697\\msg\\<p><f n=\"Arial\" h=\"12\">woo!</1f></1p>\\final\\";
        HashMap<String, Object> hash = MSIMParser.parse(input);
        TestMSIMParser.assertEquals((int)4, (int)hash.size());
        TestMSIMParser.assertTrue((boolean)hash.containsKey("bm"));
        TestMSIMParser.assertEquals((Object)"1", (Object)hash.get("bm"));
        TestMSIMParser.assertTrue((boolean)hash.containsKey("f"));
        TestMSIMParser.assertEquals((Object)"6221", (Object)hash.get("f"));
        TestMSIMParser.assertTrue((boolean)hash.containsKey("cv"));
        TestMSIMParser.assertEquals((Object)"697", (Object)hash.get("cv"));
        TestMSIMParser.assertTrue((boolean)hash.containsKey("msg"));
        TestMSIMParser.assertEquals((Object)"<p><f n=\"Arial\" h=\"12\">woo!</1f></1p>", (Object)hash.get("msg"));
        TestMSIMParser.assertFalse((boolean)hash.containsKey("final"));
        TestMSIMParser.assertFalse((boolean)hash.containsValue("final"));
    }

    public void testOutgoingMessage() {
    }
}

