/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.SessionIdManager;
import org.mortbay.jetty.servlet.AbstractSessionManager;
import org.mortbay.util.MultiMap;

public class HashSessionIdManager
extends AbstractLifeCycle
implements SessionIdManager {
    private static final String __NEW_SESSION_ID = "org.mortbay.jetty.newSessionId";
    MultiMap _sessions;
    protected Random _random;
    private String _workerName;

    public HashSessionIdManager() {
    }

    public HashSessionIdManager(Random random) {
        this._random = random;
    }

    public String getWorkerName() {
        return this._workerName;
    }

    public void setWorkerName(String workerName) {
        this._workerName = workerName;
    }

    protected void doStart() {
        if (this._random == null) {
            this._random = new Random();
        }
        this._random.nextLong();
        this._sessions = new MultiMap();
    }

    protected void doStop() {
        if (this._sessions != null) {
            this._sessions.clear();
        }
        this._sessions = null;
    }

    public boolean idInUse(String id) {
        return this._sessions.containsKey((Object)id);
    }

    public void addSession(HttpSession session) {
        this._sessions.add((Object)session.getId(), (Object)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll(String id) {
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            while (this._sessions.containsKey((Object)id)) {
                AbstractSessionManager.Session session = (AbstractSessionManager.Session)this._sessions.getValue((Object)id, 0);
                if (session.isValid()) {
                    session.invalidate();
                    continue;
                }
                this._sessions.removeValue((Object)id, (Object)session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String newSessionId(HttpServletRequest request, long created) {
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            String requested_id = request.getRequestedSessionId();
            if (requested_id != null && this.idInUse(requested_id)) {
                return requested_id;
            }
            String new_id = (String)request.getAttribute(__NEW_SESSION_ID);
            if (new_id != null && this.idInUse(new_id)) {
                return new_id;
            }
            String id = null;
            while (id == null || id.length() == 0 || this.idInUse(id)) {
                long r = this._random.nextLong();
                if (r < 0L) {
                    r = -r;
                }
                id = Long.toString(r, 30 + (int)(created % 7L));
                String worker = (String)request.getAttribute("org.mortbay.http.ajp.JVMRoute");
                if (worker != null) {
                    id = id + "." + worker;
                    continue;
                }
                if (this._workerName == null) continue;
                id = id + "." + this._workerName;
            }
            request.setAttribute(__NEW_SESSION_ID, (Object)id);
            return id;
        }
    }
}

