/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import org.mortbay.io.Buffer;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpContent;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpGenerator;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpMethods;
import org.mortbay.jetty.HttpParser;
import org.mortbay.jetty.HttpURI;
import org.mortbay.jetty.HttpVersions;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.Server;
import org.mortbay.log.Log;
import org.mortbay.util.URIUtil;

public class HttpConnection {
    private static int UNKNOWN = -2;
    private static ThreadLocal __currentConnection = new ThreadLocal();
    private long _timeStamp = System.currentTimeMillis();
    private int _requests;
    private Connector _connector;
    private EndPoint _endp;
    private Server _server;
    private boolean _expectingContinues;
    private boolean _idle = true;
    private HttpURI _uri = new HttpURI();
    private HttpParser _parser;
    private HttpFields _requestFields;
    private Request _request;
    private HttpParser.Input _in;
    private HttpGenerator _generator;
    private HttpFields _responseFields;
    private Response _response;
    private Output _out;
    private OutputWriter _writer;
    private PrintWriter _printWriter;
    int _include;
    private Object _associatedObject;
    private transient int _connection = UNKNOWN;
    private transient int _expect = UNKNOWN;
    private transient int _version = UNKNOWN;
    private transient boolean _head = false;
    private transient boolean _host = false;

    public static HttpConnection getCurrentConnection() {
        return (HttpConnection)__currentConnection.get();
    }

    protected static void setCurrentConnection(HttpConnection connection) {
        __currentConnection.set(connection);
    }

    public HttpConnection(Connector connector, EndPoint endpoint, Server server) {
        this._connector = connector;
        this._endp = endpoint;
        this._parser = new HttpParser(this._connector, endpoint, new RequestHandler(), this._connector.getHeaderBufferSize(), this._connector.getRequestBufferSize());
        this._requestFields = new HttpFields();
        this._responseFields = new HttpFields();
        this._request = new Request(this);
        this._response = new Response(this);
        this._generator = new HttpGenerator(this._connector, this._endp, this._connector.getHeaderBufferSize(), this._connector.getResponseBufferSize());
        this._generator.setSendServerVersion(server.getSendServerVersion());
        this._server = server;
    }

    public void destroy() {
        if (this._parser != null) {
            this._parser.reset(true);
        }
        if (this._generator != null) {
            this._generator.reset(true);
        }
        if (this._requestFields != null) {
            this._requestFields.destroy();
        }
        if (this._responseFields != null) {
            this._responseFields.destroy();
        }
        this._server = null;
    }

    public int getRequests() {
        return this._requests;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public Object getAssociatedObject() {
        return this._associatedObject;
    }

    public void setAssociatedObject(Object associatedObject) {
        this._associatedObject = associatedObject;
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpFields getRequestFields() {
        return this._requestFields;
    }

    public HttpFields getResponseFields() {
        return this._responseFields;
    }

    public boolean isConfidential(Request request) {
        if (this._connector != null) {
            return this._connector.isConfidential(request);
        }
        return false;
    }

    public boolean isIntegral(Request request) {
        if (this._connector != null) {
            return this._connector.isIntegral(request);
        }
        return false;
    }

    public EndPoint getEndPoint() {
        return this._endp;
    }

    public boolean getResolveNames() {
        return this._connector.getResolveNames();
    }

    public Request getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._response;
    }

    public ServletInputStream getInputStream() {
        if (this._in == null) {
            this._in = new HttpParser.Input(this._parser, this._connector.getMaxIdleTime());
        }
        return this._in;
    }

    public ServletOutputStream getOutputStream() {
        if (this._out == null) {
            this._out = new Output();
        }
        return this._out;
    }

    public PrintWriter getPrintWriter(String encoding) {
        this.getOutputStream();
        if (this._writer == null) {
            this._writer = new OutputWriter();
            this._printWriter = new PrintWriter(this._writer){

                public void close() {
                    try {
                        HttpConnection.this._out.close();
                    }
                    catch (IOException e) {
                        Log.debug((Throwable)e);
                        this.setError();
                    }
                }
            };
        }
        this._writer.setCharacterEncoding(encoding);
        return this._printWriter;
    }

    public boolean isResponseCommitted() {
        return this._generator.isCommitted();
    }

    /*
     * Exception decompiling
     */
    public void handle() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleRequest() throws IOException {
        boolean error;
        block29: {
            if (this._server == null) return;
            boolean retry = false;
            error = false;
            String threadName = null;
            try {
                try {
                    String info = URIUtil.canonicalPath((String)this._uri.getDecodedPath());
                    if (info == null) {
                        throw new HttpException(400);
                    }
                    this._request.setPathInfo(info);
                    if (this._out != null) {
                        this._out.reopen();
                    }
                    if (Log.isDebugEnabled()) {
                        threadName = Thread.currentThread().getName();
                        Thread.currentThread().setName(threadName + " - " + this._uri);
                    }
                    this._connector.customize(this._endp, this._request);
                    this._server.handle(this);
                }
                catch (RetryRequest r) {
                    Log.ignore((Throwable)r);
                    retry = true;
                    Object var6_10 = null;
                    if (threadName != null) {
                        Thread.currentThread().setName(threadName);
                    }
                    if (retry) return;
                    ++this._requests;
                    if (this._request.getContinuation() != null && this._request.getContinuation().isPending()) {
                        Log.debug((String)"continuation still pending {}");
                        this._request.getContinuation().reset();
                    }
                    if (error) return;
                    if (!this._endp.isOpen()) return;
                    if (!this._response.isCommitted() && !this._request.isHandled()) {
                        this._response.sendError(404);
                    }
                    this._response.complete();
                    return;
                }
                catch (EofException e) {
                    Log.ignore((Throwable)e);
                    error = true;
                    Object var6_11 = null;
                    if (threadName != null) {
                        Thread.currentThread().setName(threadName);
                    }
                    if (retry) return;
                    ++this._requests;
                    if (this._request.getContinuation() != null && this._request.getContinuation().isPending()) {
                        Log.debug((String)"continuation still pending {}");
                        this._request.getContinuation().reset();
                    }
                    if (error) return;
                    if (!this._endp.isOpen()) return;
                    if (!this._response.isCommitted() && !this._request.isHandled()) {
                        this._response.sendError(404);
                    }
                    this._response.complete();
                    return;
                }
                catch (ServletException e) {
                    Log.warn((Throwable)e);
                    this._request.setHandled(true);
                    this._generator.sendError(500, null, null, true);
                    Object var6_12 = null;
                    if (threadName != null) {
                        Thread.currentThread().setName(threadName);
                    }
                    if (retry) return;
                    ++this._requests;
                    if (this._request.getContinuation() != null && this._request.getContinuation().isPending()) {
                        Log.debug((String)"continuation still pending {}");
                        this._request.getContinuation().reset();
                    }
                    if (error) return;
                    if (!this._endp.isOpen()) return;
                    if (!this._response.isCommitted() && !this._request.isHandled()) {
                        this._response.sendError(404);
                    }
                    this._response.complete();
                    return;
                }
                catch (HttpException e) {
                    Log.debug((Throwable)e);
                    this._request.setHandled(true);
                    this._response.sendError(e.getStatus(), e.getReason());
                    Object var6_13 = null;
                    if (threadName != null) {
                        Thread.currentThread().setName(threadName);
                    }
                    if (retry) return;
                    ++this._requests;
                    if (this._request.getContinuation() != null && this._request.getContinuation().isPending()) {
                        Log.debug((String)"continuation still pending {}");
                        this._request.getContinuation().reset();
                    }
                    if (error) return;
                    if (!this._endp.isOpen()) return;
                    if (!this._response.isCommitted() && !this._request.isHandled()) {
                        this._response.sendError(404);
                    }
                    this._response.complete();
                    return;
                }
                Object var6_9 = null;
                if (threadName != null) {
                    Thread.currentThread().setName(threadName);
                }
                if (retry) return;
                ++this._requests;
                if (this._request.getContinuation() == null) break block29;
            }
            catch (Throwable throwable) {
                Object var6_14 = null;
                if (threadName != null) {
                    Thread.currentThread().setName(threadName);
                }
                if (retry) throw throwable;
                ++this._requests;
                if (this._request.getContinuation() != null && this._request.getContinuation().isPending()) {
                    Log.debug((String)"continuation still pending {}");
                    this._request.getContinuation().reset();
                }
                if (error) throw throwable;
                if (!this._endp.isOpen()) throw throwable;
                if (!this._response.isCommitted() && !this._request.isHandled()) {
                    this._response.sendError(404);
                }
                this._response.complete();
                throw throwable;
            }
            if (this._request.getContinuation().isPending()) {
                Log.debug((String)"continuation still pending {}");
                this._request.getContinuation().reset();
            }
        }
        if (error) return;
        if (!this._endp.isOpen()) return;
        if (!this._response.isCommitted() && !this._request.isHandled()) {
            this._response.sendError(404);
        }
        this._response.complete();
    }

    public void commitResponse(boolean last) throws IOException {
        if (!this._generator.isCommitted()) {
            this._generator.setResponse(this._response.getStatus(), this._response.getReason());
            this._generator.completeHeader(this._responseFields, last);
        }
        if (last) {
            this._generator.complete();
        }
    }

    public void completeResponse() throws IOException {
        if (!this._generator.isCommitted()) {
            this._generator.setResponse(this._response.getStatus(), this._response.getReason());
            this._generator.completeHeader(this._responseFields, true);
        }
        this._generator.complete();
    }

    public void flushResponse() throws IOException {
        try {
            this.commitResponse(false);
            this._generator.flushBuffers();
        }
        catch (IOException e) {
            throw e instanceof EofException ? e : new EofException(e);
        }
    }

    HttpGenerator getGenerator() {
        return this._generator;
    }

    public boolean isIncluding() {
        return this._include > 0;
    }

    public void include() {
        ++this._include;
    }

    public void included() {
        --this._include;
        if (this._out != null) {
            this._out.reopen();
        }
    }

    public boolean isIdle() {
        return this._idle;
    }

    public class OutputWriter
    extends HttpGenerator.OutputWriter {
        OutputWriter() {
            super(HttpConnection.this._out);
        }
    }

    public class Output
    extends HttpGenerator.Output {
        Output() {
            super(HttpConnection.this._generator, HttpConnection.this._connector.getMaxIdleTime());
        }

        public void close() throws IOException {
            if (this._closed) {
                return;
            }
            if (!HttpConnection.this.isIncluding() && !this._generator.isCommitted()) {
                HttpConnection.this.commitResponse(true);
            } else {
                HttpConnection.this.flushResponse();
            }
            super.close();
        }

        public void flush() throws IOException {
            if (!this._generator.isCommitted()) {
                HttpConnection.this.commitResponse(false);
            }
            super.flush();
        }

        public void print(String s) throws IOException {
            if (this._closed) {
                throw new IOException("Closed");
            }
            PrintWriter writer = HttpConnection.this.getPrintWriter(null);
            writer.print(s);
        }

        public void sendContent(Object content) throws IOException {
            if (this._closed) {
                throw new IOException("Closed");
            }
            if (this._generator.getContentWritten() > 0L) {
                throw new IllegalStateException("!empty");
            }
            if (content instanceof HttpContent) {
                HttpContent c = (HttpContent)content;
                if (c.getContentType() != null && !HttpConnection.this._responseFields.containsKey(HttpHeaders.CONTENT_TYPE_BUFFER)) {
                    HttpConnection.this._responseFields.add(HttpHeaders.CONTENT_TYPE_BUFFER, c.getContentType());
                }
                if (c.getContentLength() > 0L) {
                    HttpConnection.this._responseFields.addLongField(HttpHeaders.CONTENT_LENGTH_BUFFER, c.getContentLength());
                }
                if (c.getLastModified() != null) {
                    HttpConnection.this._responseFields.add(HttpHeaders.LAST_MODIFIED_BUFFER, c.getLastModified());
                }
                if ((content = c.getBuffer()) == null) {
                    content = c.getInputStream();
                }
            }
            if (content instanceof Buffer) {
                this._generator.addContent((Buffer)content, true);
                HttpConnection.this.commitResponse(true);
            } else if (content instanceof InputStream) {
                InputStream in = (InputStream)content;
                int max = this._generator.prepareUncheckedAddContent();
                Buffer buffer = this._generator.getUncheckedBuffer();
                int len = buffer.readFrom(in, max);
                while (len >= 0) {
                    this._generator.completeUncheckedAddContent();
                    HttpConnection.this._out.flush();
                    max = this._generator.prepareUncheckedAddContent();
                    buffer = this._generator.getUncheckedBuffer();
                    len = buffer.readFrom(in, max);
                }
                this._generator.completeUncheckedAddContent();
                HttpConnection.this._out.flush();
            } else {
                throw new IllegalArgumentException("unknown content type?");
            }
        }
    }

    private class RequestHandler
    extends HttpParser.EventHandler {
        boolean _delayedHandling = false;

        private RequestHandler() {
        }

        public void startRequest(Buffer method, Buffer uri, Buffer version) throws IOException {
            HttpConnection.this._host = false;
            HttpConnection.this._expect = UNKNOWN;
            HttpConnection.this._connection = UNKNOWN;
            this._delayedHandling = false;
            HttpConnection.this._request.setTimeStamp(System.currentTimeMillis());
            HttpConnection.this._request.setMethod(method.toString());
            try {
                HttpConnection.this._uri.parse(uri.array(), uri.getIndex(), uri.length());
                HttpConnection.this._request.setUri(HttpConnection.this._uri);
                if (version == null) {
                    HttpConnection.this._request.setProtocol("");
                    HttpConnection.this._version = 9;
                } else {
                    version = HttpVersions.CACHE.get(version);
                    HttpConnection.this._version = HttpVersions.CACHE.getOrdinal(version);
                    if (HttpConnection.this._version <= 0) {
                        HttpConnection.this._version = 10;
                    }
                    HttpConnection.this._request.setProtocol(version.toString());
                }
                HttpConnection.this._head = method == HttpMethods.HEAD_BUFFER;
            }
            catch (Exception e) {
                throw new HttpException(400, null, e);
            }
        }

        public void parsedHeader(Buffer name, Buffer value) {
            int ho = HttpHeaders.CACHE.getOrdinal(name);
            switch (ho) {
                case 27: {
                    HttpConnection.this._host = true;
                    break;
                }
                case 24: {
                    HttpConnection.this._expect = HttpHeaderValues.CACHE.getOrdinal(value);
                    break;
                }
                case 21: {
                    value = HttpHeaderValues.CACHE.lookup(value);
                    break;
                }
                case 1: {
                    HttpConnection.this._connection = HttpHeaderValues.CACHE.getOrdinal(value);
                    if (HttpConnection.this._connection < 0) {
                        HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, value);
                        break;
                    }
                    value = HttpHeaderValues.CACHE.get(HttpConnection.this._connection);
                    HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, value);
                }
            }
            HttpConnection.this._requestFields.add(name, value);
        }

        public void headerComplete() throws IOException {
            HttpConnection.this._generator.setVersion(HttpConnection.this._version);
            switch (HttpConnection.this._version) {
                case 9: {
                    break;
                }
                case 10: {
                    HttpConnection.this._generator.setHead(HttpConnection.this._head);
                    break;
                }
                case 11: {
                    HttpConnection.this._generator.setHead(HttpConnection.this._head);
                    if (!HttpConnection.this._host) {
                        HttpConnection.this._generator.setResponse(400, null);
                        HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                        HttpConnection.this._generator.completeHeader(HttpConnection.this._responseFields, true);
                        HttpConnection.this._generator.complete();
                        return;
                    }
                    if (HttpConnection.this._expect == UNKNOWN) break;
                    if (HttpConnection.this._expect == HttpHeaderValues.CONTINUE_ORDINAL) {
                        HttpConnection.this._expectingContinues = true;
                        if (HttpConnection.this._parser.getHeaderBuffer() != null && HttpConnection.this._parser.getHeaderBuffer().length() >= 2) break;
                        HttpConnection.this._generator.setResponse(100, null);
                        HttpConnection.this._generator.completeHeader(null, true);
                        HttpConnection.this._generator.complete();
                        HttpConnection.this._generator.reset(false);
                        break;
                    }
                    HttpConnection.this._generator.sendError(417, null, null, true);
                    return;
                }
            }
            if (HttpConnection.this._parser.getContentLength() <= 0 && !HttpConnection.this._parser.isChunking()) {
                HttpConnection.this.handleRequest();
            } else {
                this._delayedHandling = true;
            }
        }

        public void content(Buffer ref) throws IOException {
            if (this._delayedHandling) {
                this._delayedHandling = false;
                HttpConnection.this.handleRequest();
            }
        }

        public void messageComplete(int contextLength) throws IOException {
        }

        public void startResponse(Buffer version, int status, Buffer reason) {
            throw new IllegalStateException("response");
        }
    }
}

