/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icon;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icon.IconCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class UploadIconCmd
extends IconCommand {
    private static final int TYPE_ICON_DATA = 1;
    private final Writable iconWritable;
    private final ByteBlock iconData;

    protected UploadIconCmd(SnacPacket snacPacket) {
        super(2);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock);
        Tlv tlv = immutableTlvChain.getLastTlv(1);
        this.iconData = tlv != null ? tlv.getData() : null;
        this.iconWritable = this.iconData;
    }

    public UploadIconCmd(Writable writable) {
        super(2);
        this.iconWritable = writable;
        this.iconData = null;
    }

    public final ByteBlock getIconData() {
        return this.iconData;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.iconWritable != null) {
            new Tlv(1, this.iconWritable).write(outputStream);
        }
    }

    public String toString() {
        return "UploadIconCmd";
    }
}

