/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.acct;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.acct.AcctCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public abstract class AcctResponse
extends AcctCommand {
    public static final int ERRORCODE_CANNOT_DISPLAY_INFO = 18;
    public static final int ERRORCODE_NO_EMAIL = 21;
    public static final int TYPE_DEFAULT = 3;
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_ERROR = 3;
    private static final int TYPE_SN = 1;
    private static final int TYPE_EMAIL = 17;
    private static final int TYPE_ERROR_CODE = 8;
    private static final int TYPE_ERROR_URL = 4;
    private final int type;
    private final int result;
    private final String sn;
    private final String email;
    private final int errorCode;
    private final String errorUrl;

    protected AcctResponse(int n, SnacPacket snacPacket) {
        super(n);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.type = BinaryTools.getUShort(byteBlock, 0);
        this.result = BinaryTools.getUShort(byteBlock, 2);
        ByteBlock byteBlock2 = byteBlock.subBlock(4);
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock2);
        this.sn = immutableTlvChain.getString(1);
        this.email = immutableTlvChain.getString(17);
        this.errorCode = immutableTlvChain.getUShort(8);
        this.errorUrl = immutableTlvChain.getString(4);
    }

    protected AcctResponse(int n, int n2) {
        this(n, 3, n2, null, null, -1, null);
    }

    protected AcctResponse(int n, int n2, String string) {
        this(n, 3, 3, null, null, n2, string);
    }

    protected AcctResponse(int n, int n2, int n3, String string, String string2, int n4, String string3) {
        super(n);
        DefensiveTools.checkRange(n2, "type", 0);
        DefensiveTools.checkRange(n3, "result", 0);
        DefensiveTools.checkRange(n4, "errorCode", -1);
        this.type = n2;
        this.result = n3;
        this.sn = string;
        this.email = string2;
        this.errorCode = n4;
        this.errorUrl = string3;
    }

    public final int getType() {
        return this.type;
    }

    public final int getResult() {
        return this.result;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final String getEmail() {
        return this.email;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final String getErrorUrl() {
        return this.errorUrl;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.type);
        BinaryTools.writeUShort(outputStream, this.result);
        if (this.sn != null) {
            Tlv.getStringInstance(1, this.sn).write(outputStream);
        }
        if (this.email != null) {
            Tlv.getStringInstance(17, this.email).write(outputStream);
        }
        if (this.errorCode != -1) {
            Tlv.getUShortInstance(8, this.errorCode).write(outputStream);
        }
        if (this.errorUrl != null) {
            Tlv.getStringInstance(4, this.errorUrl).write(outputStream);
        }
    }

    public String toString() {
        return MiscTools.getClassName(this) + ": type=" + this.type + ", result=" + this.result + ", sn=" + this.sn + ", email=" + this.email + ", error=" + this.errorCode + ", errurl=" + this.errorUrl;
    }
}

