/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.SnacQueueManager;
import net.kano.joscar.snac.SnacRequest;

public class ImmediateSnacQueueManager
implements SnacQueueManager {
    private final Map queues = new IdentityHashMap();

    public synchronized void attached(ClientSnacProcessor clientSnacProcessor) {
        this.queues.put(clientSnacProcessor, new SnacQueue());
    }

    public synchronized void detached(ClientSnacProcessor clientSnacProcessor) {
        this.queues.remove(clientSnacProcessor);
    }

    private synchronized SnacQueue getQueue(ClientSnacProcessor clientSnacProcessor) {
        return (SnacQueue)this.queues.get(clientSnacProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(ClientSnacProcessor clientSnacProcessor) {
        SnacQueue snacQueue;
        SnacQueue snacQueue2 = snacQueue = this.getQueue(clientSnacProcessor);
        synchronized (snacQueue2) {
            snacQueue.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpause(ClientSnacProcessor clientSnacProcessor) {
        ArrayList arrayList;
        SnacQueue snacQueue = this.getQueue(clientSnacProcessor);
        Object object = snacQueue;
        synchronized (object) {
            snacQueue.paused = false;
            arrayList = new ArrayList(snacQueue.queue);
            snacQueue.queue.clear();
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            SnacRequest snacRequest = (SnacRequest)object.next();
            object.remove();
            ImmediateSnacQueueManager.sendSnac(clientSnacProcessor, snacRequest);
        }
    }

    protected static final void sendSnac(ClientSnacProcessor clientSnacProcessor, SnacRequest snacRequest) {
        clientSnacProcessor.sendSnacImmediately(snacRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueSnac(ClientSnacProcessor clientSnacProcessor, SnacRequest snacRequest) {
        boolean bl;
        SnacQueue snacQueue;
        SnacQueue snacQueue2 = snacQueue = this.getQueue(clientSnacProcessor);
        synchronized (snacQueue2) {
            bl = snacQueue.paused;
            if (bl) {
                snacQueue.queue.addLast(snacRequest);
            }
        }
        if (!bl) {
            ImmediateSnacQueueManager.sendSnac(clientSnacProcessor, snacRequest);
        }
    }

    public synchronized void clearQueue(ClientSnacProcessor clientSnacProcessor) {
        this.queues.remove(clientSnacProcessor);
    }

    private static class SnacQueue {
        private boolean paused = false;
        private final LinkedList queue = new LinkedList();

        private SnacQueue() {
        }
    }
}

