/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.directim;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ImEncodedString;
import net.kano.joscar.ImEncodingParams;
import net.kano.joscar.LiveWritable;

public final class DirectImHeader
implements LiveWritable {
    public static final String DCVERSION_DEFAULT = "ODC2";
    public static final long FLAG_TYPINGPACKET = 2L;
    public static final long FLAG_TYPING = 8L;
    public static final long FLAG_TYPED = 4L;
    public static final long FLAG_AUTORESPONSE = 1L;
    private String dcVersion = null;
    private long messageId = 0L;
    private long dataLength = -1L;
    private ImEncodingParams encoding = null;
    private long flags = -1L;
    private String sn = null;
    private int headerSize = -1;

    public static DirectImHeader createTypingHeader() {
        DirectImHeader directImHeader = new DirectImHeader();
        directImHeader.setDefaults();
        directImHeader.setFlags(10L);
        return directImHeader;
    }

    public static DirectImHeader createTypedHeader() {
        DirectImHeader directImHeader = new DirectImHeader();
        directImHeader.setDefaults();
        directImHeader.setFlags(6L);
        return directImHeader;
    }

    public static DirectImHeader createTypingErasedHeader() {
        DirectImHeader directImHeader = new DirectImHeader();
        directImHeader.setDefaults();
        directImHeader.setFlags(2L);
        return directImHeader;
    }

    public static DirectImHeader createMessageHeader(ImEncodedString imEncodedString) {
        return DirectImHeader.createMessageHeader(imEncodedString, false);
    }

    public static DirectImHeader createMessageHeader(ImEncodedString imEncodedString, boolean bl) {
        DefensiveTools.checkNull(imEncodedString, "message");
        DirectImHeader directImHeader = new DirectImHeader();
        directImHeader.setDefaults();
        directImHeader.setFlags(bl ? 1L : 0L);
        directImHeader.setEncoding(imEncodedString.getEncoding());
        directImHeader.setDataLength(imEncodedString.getBytes().length);
        return directImHeader;
    }

    public DirectImHeader() {
    }

    public DirectImHeader(DirectImHeader directImHeader) {
        DefensiveTools.checkNull(directImHeader, "header");
        this.dcVersion = directImHeader.dcVersion;
        this.messageId = directImHeader.messageId;
        this.dataLength = directImHeader.dataLength;
        this.encoding = directImHeader.encoding;
        this.flags = directImHeader.flags;
        this.sn = directImHeader.sn;
    }

    public static DirectImHeader readDirectIMHeader(InputStream inputStream) throws IOException {
        int n;
        int n2;
        DefensiveTools.checkNull(inputStream, "in");
        byte[] byArray = new byte[6];
        for (int i = 0; i < byArray.length; i += n2) {
            n2 = inputStream.read(byArray, i, byArray.length - i);
            if (n2 != -1) continue;
            return null;
        }
        DirectImHeader directImHeader = new DirectImHeader();
        ByteBlock byteBlock = ByteBlock.wrap(byArray);
        ByteBlock byteBlock2 = byteBlock.subBlock(0, 4);
        directImHeader.setDcVersion(BinaryTools.getAsciiString(byteBlock2));
        int n3 = BinaryTools.getUShort(byteBlock, 4);
        if (n3 < 6) {
            return null;
        }
        directImHeader.setHeaderSize(n3);
        byte[] byArray2 = new byte[n3 - 6];
        for (int i = 0; i < byArray2.length; i += n) {
            n = inputStream.read(byArray2, i, byArray2.length - i);
            if (n != -1) continue;
            return null;
        }
        ByteBlock byteBlock3 = ByteBlock.wrap(byArray2);
        directImHeader.setMessageId(BinaryTools.getLong(byteBlock3, 6));
        directImHeader.setDataLength(BinaryTools.getUInt(byteBlock3, 22));
        n = BinaryTools.getUShort(byteBlock3, 26);
        int n4 = BinaryTools.getUShort(byteBlock3, 28);
        directImHeader.setEncoding(new ImEncodingParams(n, n4));
        directImHeader.setFlags(BinaryTools.getUInt(byteBlock3, 30));
        ByteBlock byteBlock4 = byteBlock3.subBlock(38, 16);
        directImHeader.setScreenname(BinaryTools.getNullPadded(byteBlock4).getString());
        return directImHeader;
    }

    public final synchronized String getDcVersion() {
        return this.dcVersion;
    }

    public final synchronized long getMessageId() {
        return this.messageId;
    }

    public final synchronized long getDataLength() {
        return this.dataLength;
    }

    public final synchronized ImEncodingParams getEncoding() {
        return this.encoding;
    }

    public final synchronized long getFlags() {
        return this.flags;
    }

    public final synchronized String getScreenname() {
        return this.sn;
    }

    public final synchronized int getHeaderSize() {
        return this.headerSize;
    }

    public final synchronized void setDcVersion(String string) {
        this.dcVersion = string;
    }

    public final synchronized void setMessageId(long l) {
        this.messageId = l;
    }

    public final synchronized void setDataLength(long l) {
        this.dataLength = l;
    }

    public final synchronized void setEncoding(ImEncodingParams imEncodingParams) {
        this.encoding = imEncodingParams;
    }

    public final synchronized void setFlags(long l) {
        this.flags = l;
    }

    public final synchronized void setScreenname(String string) {
        this.sn = string;
    }

    private final synchronized void setHeaderSize(int n) {
        this.headerSize = n;
    }

    public final synchronized void setDefaults() {
        this.dcVersion = DCVERSION_DEFAULT;
        this.dataLength = 0L;
        this.encoding = null;
        this.flags = 0L;
        this.sn = "";
    }

    private synchronized void checkValidity() throws IllegalArgumentException {
        DefensiveTools.checkNull(this.dcVersion, "dcVersion");
        DefensiveTools.checkRange(this.dataLength, "dataLength", 0);
        DefensiveTools.checkNull(this.encoding, "encoding");
        DefensiveTools.checkRange(this.flags, "flags", 0);
        DefensiveTools.checkNull(this.sn, "sn");
    }

    public synchronized void write(OutputStream outputStream) throws IOException, IllegalArgumentException {
        DefensiveTools.checkNull(outputStream, "out");
        this.checkValidity();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(76);
        byte[] byArray = BinaryTools.getAsciiBytes(this.dcVersion);
        byteArrayOutputStream.write(byArray);
        BinaryTools.writeUShort(byteArrayOutputStream, 76);
        BinaryTools.writeUShort(byteArrayOutputStream, 1);
        BinaryTools.writeUShort(byteArrayOutputStream, 6);
        BinaryTools.writeUShort(byteArrayOutputStream, 0);
        BinaryTools.writeLong(byteArrayOutputStream, this.messageId);
        byteArrayOutputStream.write(new byte[8]);
        BinaryTools.writeUInt(byteArrayOutputStream, this.dataLength);
        if (this.encoding != null) {
            BinaryTools.writeUShort(byteArrayOutputStream, this.encoding.getCharsetCode());
            BinaryTools.writeUShort(byteArrayOutputStream, this.encoding.getCharsetSubcode());
        } else {
            BinaryTools.writeUShort(byteArrayOutputStream, 0);
            BinaryTools.writeUShort(byteArrayOutputStream, 0);
        }
        BinaryTools.writeUInt(byteArrayOutputStream, this.flags);
        BinaryTools.writeUInt(byteArrayOutputStream, 0L);
        ByteBlock byteBlock = ByteBlock.wrap(BinaryTools.getAsciiBytes(this.sn));
        BinaryTools.writeNullPadded(byteArrayOutputStream, byteBlock, 16);
        byteArrayOutputStream.write(new byte[16]);
        byteArrayOutputStream.writeTo(outputStream);
    }

    public synchronized String toString() {
        return "DirectIMHeader: msgid=" + this.messageId + ", dataLen=" + this.dataLength + ", encoding=" + this.encoding + ", flags=0x" + Long.toHexString(this.flags) + ", sn='" + this.sn + "'" + ", headerSize=" + this.headerSize;
    }
}

