/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft;

import java.util.logging.Logger;
import net.kano.joscar.rv.RecvRvEvent;
import net.kano.joscar.rvcmd.AcceptRvCmd;
import net.kano.joscar.rvcmd.ConnectionRequestRvCmd;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.AbstractRvSessionHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.ConnectionType;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.ControllerRestartConsultant;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.ControllerRestartConsultantImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.NextStateControllerInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.OutgoingRvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionState;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ConnectToProxyForOutgoingController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.OutgoingConnectionController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.RedirectConnectionController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.RedirectToProxyController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.SendOverProxyController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.SendPassivelyController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.StateController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.RvConnectionEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.UnknownErrorEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.FailedStateInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.FailureEventInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StateInfo;
import net.kano.joustsim.oscar.proxy.AimProxyInfo;

public abstract class OutgoingRvConnectionImpl
extends RvConnectionImpl
implements OutgoingRvConnection {
    private static final Logger LOGGER = Logger.getLogger(OutgoingRvConnectionImpl.class.getName());
    private boolean gotAccept = false;
    private ControllerRestartConsultant restarter = new ControllerRestartConsultantImpl();

    public OutgoingRvConnectionImpl(Screenname myScreenname, RvSessionConnectionInfo rvsessioninfo) {
        super(AimProxyInfo.forNoProxy(), myScreenname, rvsessioninfo);
    }

    public OutgoingRvConnectionImpl(AimProxyInfo proxy, Screenname myScreenname, RvSessionConnectionInfo rvsessioninfo) {
        super(proxy, myScreenname, rvsessioninfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NextStateControllerInfo getNextControllerFromError(StateController oldController, StateInfo endState) {
        ControllerRestartConsultant restarter;
        boolean gotAccept;
        RvConnectionEvent event = null;
        if (endState instanceof FailureEventInfo) {
            FailureEventInfo failureEventInfo = (FailureEventInfo)endState;
            event = failureEventInfo.getEvent();
        }
        OutgoingRvConnectionImpl outgoingRvConnectionImpl = this;
        synchronized (outgoingRvConnectionImpl) {
            gotAccept = this.gotAccept;
            restarter = this.restarter;
        }
        if (!gotAccept && this.isOpen() && restarter.shouldRestart()) {
            restarter.handleRestart();
            if (oldController instanceof SendPassivelyController || oldController instanceof RedirectConnectionController) {
                return new NextStateControllerInfo(new RedirectConnectionController());
            }
            if (oldController instanceof RedirectToProxyController || oldController instanceof SendOverProxyController) {
                return new NextStateControllerInfo(new RedirectToProxyController());
            }
        }
        if (OutgoingRvConnectionImpl.isLanController(oldController)) {
            return new NextStateControllerInfo(new OutgoingConnectionController(ConnectionType.INTERNET), event);
        }
        if (oldController instanceof SendPassivelyController || OutgoingRvConnectionImpl.isInternetController(oldController) || oldController instanceof ConnectToProxyForOutgoingController) {
            return new NextStateControllerInfo(new RedirectToProxyController(), event);
        }
        if (oldController instanceof RedirectToProxyController) {
            return new NextStateControllerInfo(RvConnectionState.FAILED, event == null ? new UnknownErrorEvent() : event);
        }
        return this.getNextControllerFromUnknownError(oldController, (FailedStateInfo)endState, event);
    }

    protected abstract NextStateControllerInfo getNextControllerFromUnknownError(StateController var1, FailedStateInfo var2, RvConnectionEvent var3);

    protected boolean isSomeConnectionController(StateController oldController) {
        return oldController instanceof SendPassivelyController || OutgoingRvConnectionImpl.isLanController(oldController) || OutgoingRvConnectionImpl.isInternetController(oldController) || oldController instanceof RedirectToProxyController || oldController instanceof ConnectToProxyForOutgoingController || oldController instanceof SendOverProxyController;
    }

    protected AbstractRvSessionHandler createSessionHandler() {
        return new OutgoingRvSessionHandler();
    }

    public synchronized ControllerRestartConsultant getRestartConsultant() {
        return this.restarter;
    }

    public synchronized void setRestartConsultant(ControllerRestartConsultant restarter) {
        this.restarter = restarter;
    }

    protected class OutgoingRvSessionHandler
    extends AbstractRvSessionHandler {
        public OutgoingRvSessionHandler() {
            super(OutgoingRvConnectionImpl.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleIncomingAccept(RecvRvEvent event, AcceptRvCmd acceptCmd) {
            OutgoingRvSessionHandler outgoingRvSessionHandler = this;
            synchronized (outgoingRvSessionHandler) {
                OutgoingRvConnectionImpl.this.gotAccept = true;
            }
            super.handleIncomingAccept(event, acceptCmd);
        }

        protected void handleIncomingRequest(RecvRvEvent event, ConnectionRequestRvCmd reqCmd) {
            int reqType = reqCmd.getRequestIndex();
            if (reqType > 1) {
                AbstractRvSessionHandler.HowToConnect how = this.processRedirect(reqCmd);
                if (OutgoingRvConnectionImpl.this.isOpen()) {
                    if (how == AbstractRvSessionHandler.HowToConnect.PROXY || how == AbstractRvSessionHandler.HowToConnect.NORMAL) {
                        boolean worked;
                        if (how == AbstractRvSessionHandler.HowToConnect.PROXY) {
                            worked = OutgoingRvConnectionImpl.this.changeStateController(new ConnectToProxyForOutgoingController());
                        } else {
                            assert (how == AbstractRvSessionHandler.HowToConnect.NORMAL);
                            worked = OutgoingRvConnectionImpl.this.changeStateController(new OutgoingConnectionController(ConnectionType.LAN));
                        }
                        if (worked) {
                            OutgoingRvConnectionImpl.this.getRvSessionInfo().getRequestMaker().sendRvAccept();
                        }
                    } else if (how == AbstractRvSessionHandler.HowToConnect.DONT) {
                        OutgoingRvConnectionImpl.this.changeStateController(new RedirectToProxyController());
                    }
                }
            } else {
                LOGGER.warning("got unknown rv connection request type in outgoing transfer: " + reqType);
            }
        }
    }
}

