/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.chat;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.chat.AbstractChatMsgIcbm;
import net.kano.joscar.snaccmd.chat.ChatMsg;
import net.kano.joscar.snaccmd.icbm.RecvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class RecvChatMsgIcbm
extends AbstractChatMsgIcbm
implements RecvIcbm {
    private static final int TYPE_USERINFO = 3;
    private final FullUserInfo senderInfo;

    protected RecvChatMsgIcbm(SnacPacket snacPacket) {
        super(6, snacPacket);
        TlvChain tlvChain = this.getChatTlvs();
        Tlv tlv = tlvChain.getLastTlv(3);
        if (tlv != null) {
            ByteBlock byteBlock = tlv.getData();
            this.senderInfo = FullUserInfo.readUserInfo(byteBlock);
        } else {
            this.senderInfo = null;
        }
    }

    public RecvChatMsgIcbm(long l, FullUserInfo fullUserInfo, ChatMsg chatMsg) {
        super(6, l, chatMsg);
        this.senderInfo = fullUserInfo;
    }

    public final FullUserInfo getSenderInfo() {
        return this.senderInfo;
    }

    protected void writeChatTlvs(OutputStream outputStream) throws IOException {
        if (this.senderInfo != null) {
            ByteBlock byteBlock = ByteBlock.createByteBlock(this.senderInfo);
            new Tlv(3, byteBlock).write(outputStream);
        }
    }

    public String toString() {
        return "RecvChatMsgIcbm: user=<" + this.senderInfo + "> - " + super.toString();
    }
}

