/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.EncodedStringInfo;
import net.kano.joscar.ImEncodingParams;
import net.kano.joscar.MinimalEncoder;
import net.kano.joscar.OscarTools;

public final class ImEncodedString {
    private final ImEncodingParams encoding;
    private final byte[] bytes;
    private final String string;

    public static String readImEncodedString(ImEncodingParams imEncodingParams, ByteBlock byteBlock) {
        DefensiveTools.checkNull(imEncodingParams, "encoding");
        DefensiveTools.checkNull(byteBlock, "block");
        return OscarTools.getString(byteBlock, imEncodingParams.toCharsetName());
    }

    public static ImEncodedString encodeString(String string) {
        DefensiveTools.checkNull(string, "string");
        return new ImEncodedString(string);
    }

    private ImEncodedString(String string) {
        EncodedStringInfo encodedStringInfo = MinimalEncoder.encodeMinimally(string);
        this.bytes = encodedStringInfo.getData();
        this.string = string;
        this.encoding = encodedStringInfo.getImEncoding();
    }

    public final ImEncodingParams getEncoding() {
        return this.encoding;
    }

    public final byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    public final String getString() {
        return this.string;
    }

    public String toString() {
        return "ImEncodedString: encoding=<" + this.encoding + ">, string=" + this.string;
    }
}

