/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.SsiItemObj;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemObj
implements SsiItemObj {
    private final MutableTlvChain extraTlvs = TlvTools.createMutableChain();

    public static List<SsiItem> generateSsiItems(Collection<? extends SsiItemObj> collection) {
        List<? extends SsiItemObj> list = DefensiveTools.getSafeNonnullListCopy(collection, "itemObjs");
        ArrayList<SsiItem> arrayList = new ArrayList<SsiItem>(list.size());
        for (SsiItemObj ssiItemObj : list) {
            arrayList.add(ssiItemObj.toSsiItem());
        }
        return DefensiveTools.getUnmodifiable(arrayList);
    }

    protected AbstractItemObj() {
        this(null);
    }

    protected AbstractItemObj(TlvChain tlvChain) {
        if (tlvChain != null) {
            this.addExtraTlvs(tlvChain);
        }
    }

    protected final TlvChain copyExtraTlvs() {
        return TlvTools.getMutableCopy(this.extraTlvs);
    }

    @Override
    public final MutableTlvChain getExtraTlvs() {
        return this.extraTlvs;
    }

    protected final void addExtraTlvs(TlvChain tlvChain) {
        this.extraTlvs.addAll(tlvChain);
    }

    protected final SsiItem generateItem(String string, int n, int n2, int n3, TlvChain tlvChain) {
        MutableTlvChain mutableTlvChain = TlvTools.getMutableCopy(this.extraTlvs);
        if (tlvChain != null) {
            mutableTlvChain.replaceAll(tlvChain);
        }
        return new SsiItem(string, n, n2, n3, ByteBlock.createByteBlock(mutableTlvChain));
    }
}

