/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.sendbl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rvcmd.AbstractRequestRvCmd;
import net.kano.joscar.rvcmd.sendbl.SendBuddyListGroup;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendBuddyListRvCmd
extends AbstractRequestRvCmd {
    private final List<SendBuddyListGroup> groups;

    public SendBuddyListRvCmd(RecvRvIcbm recvRvIcbm) {
        super(recvRvIcbm);
        ByteBlock byteBlock = this.getServiceData();
        this.groups = byteBlock == null ? null : SendBuddyListGroup.readBuddyListGroups(byteBlock);
    }

    public SendBuddyListRvCmd(Collection<SendBuddyListGroup> collection) {
        super(CapabilityBlock.BLOCK_SENDBUDDYLIST);
        this.groups = DefensiveTools.getSafeNonnullListCopy(collection, "groups");
    }

    public final List<SendBuddyListGroup> getGroups() {
        return this.groups;
    }

    @Override
    protected void writeServiceData(OutputStream outputStream) throws IOException {
        for (SendBuddyListGroup sendBuddyListGroup : this.groups) {
            sendBuddyListGroup.write(outputStream);
        }
    }

    @Override
    protected void writeRvTlvs(OutputStream outputStream) throws IOException {
    }

    public String toString() {
        return "SendBuddyListRvCmd: " + this.groups;
    }
}

