/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snac.CmdType;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateClassInfo
implements Writable {
    private static final int RATECLASSINFO_SIZE = 35;
    private final int rateClass;
    private final long windowSize;
    private final long warnAvg;
    private final long limitedAvg;
    private final long clearAvg;
    private final long disconnectAvg;
    private final long currentAvg;
    private final long max;
    private final long lastTime;
    private final int currentState;
    private List<CmdType> commands = null;

    @Nullable
    public static RateClassInfo readRateClassInfo(ByteBlock byteBlock) {
        if (byteBlock.getLength() < 35) {
            return null;
        }
        return new RateClassInfo(byteBlock);
    }

    private RateClassInfo(ByteBlock byteBlock) {
        this.rateClass = BinaryTools.getUShort(byteBlock, 0);
        this.windowSize = BinaryTools.getUInt(byteBlock, 2);
        this.clearAvg = BinaryTools.getUInt(byteBlock, 6);
        this.warnAvg = BinaryTools.getUInt(byteBlock, 10);
        this.limitedAvg = BinaryTools.getUInt(byteBlock, 14);
        this.disconnectAvg = BinaryTools.getUInt(byteBlock, 18);
        this.currentAvg = BinaryTools.getUInt(byteBlock, 22);
        this.max = BinaryTools.getUInt(byteBlock, 26);
        if (byteBlock.getLength() >= 34) {
            this.lastTime = BinaryTools.getUInt(byteBlock, 30);
            this.currentState = byteBlock.getLength() >= 35 ? (int)BinaryTools.getUByte(byteBlock, 34) : 0;
        } else {
            this.lastTime = 0L;
            this.currentState = 0;
        }
    }

    synchronized void setCommands(Collection<? extends CmdType> collection) {
        this.commands = DefensiveTools.getSafeListCopy(collection, "commands");
    }

    public RateClassInfo(int n, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, int n2) {
        DefensiveTools.checkRange(n, "rateClass", 0);
        DefensiveTools.checkRange(l, "windowSize", 0L);
        DefensiveTools.checkRange(l2, "clearAvg", 0L);
        DefensiveTools.checkRange(l3, "warnAvg", 0L);
        DefensiveTools.checkRange(l4, "limitedAvg", 0L);
        DefensiveTools.checkRange(l5, "disconnectAvg", 0L);
        DefensiveTools.checkRange(l6, "currentAvg", 0L);
        DefensiveTools.checkRange(l7, "max", 0L);
        DefensiveTools.checkRange(l7, "lastTime", 0L);
        DefensiveTools.checkRange(l7, "currentState", 0L);
        this.rateClass = n;
        this.windowSize = l;
        this.clearAvg = l2;
        this.warnAvg = l3;
        this.limitedAvg = l4;
        this.disconnectAvg = l5;
        this.currentAvg = l6;
        this.max = l7;
        this.lastTime = l8;
        this.currentState = n2;
    }

    public RateClassInfo(int n, long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        this(n, l, l2, l3, l4, l5, l6, l7, 0L, 0);
    }

    public RateClassInfo(int n, long l, long l2, long l3, long l4, long l5, long l6, long l7, Collection<? extends CmdType> collection) {
        this(n, l, l2, l3, l4, l5, l6, l7);
        this.setCommands(collection);
    }

    public RateClassInfo(int n, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, int n2, Collection<? extends CmdType> collection) {
        this(n, l, l2, l3, l4, l5, l6, l7, l8, n2);
        this.setCommands(collection);
    }

    public final int getRateClass() {
        return this.rateClass;
    }

    public final long getWindowSize() {
        return this.windowSize;
    }

    public final long getWarnAvg() {
        return this.warnAvg;
    }

    public final long getLimitedAvg() {
        return this.limitedAvg;
    }

    public final long getClearAvg() {
        return this.clearAvg;
    }

    public final long getDisconnectAvg() {
        return this.disconnectAvg;
    }

    public final long getCurrentAvg() {
        return this.currentAvg;
    }

    public final long getMax() {
        return this.max;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public final synchronized List<CmdType> getCommands() {
        return this.commands;
    }

    @Override
    public long getWritableLength() {
        return 35L;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.rateClass);
        BinaryTools.writeUInt(outputStream, this.windowSize);
        BinaryTools.writeUInt(outputStream, this.clearAvg);
        BinaryTools.writeUInt(outputStream, this.warnAvg);
        BinaryTools.writeUInt(outputStream, this.limitedAvg);
        BinaryTools.writeUInt(outputStream, this.disconnectAvg);
        BinaryTools.writeUInt(outputStream, this.currentAvg);
        BinaryTools.writeUInt(outputStream, this.max);
        BinaryTools.writeUInt(outputStream, this.lastTime);
        BinaryTools.writeUByte(outputStream, this.currentState);
    }

    public synchronized String toString() {
        return "RateClassInfo for class " + this.rateClass + ", currentAvg=" + this.currentAvg + ", windowSize=" + this.windowSize + ", clearAvg=" + this.clearAvg + ", warnAvg=" + this.warnAvg + ", limitedAvg=" + this.limitedAvg + ", disconnectAvg=" + this.disconnectAvg + ", max=" + this.max + ", lastTime=" + this.lastTime + ", currentState=" + this.currentState + ", families: " + (this.commands == null ? "none" : "" + this.commands.size());
    }
}

