/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.conn.ConnCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtraInfoCmd
extends ConnCommand {
    private final List<ExtraInfoBlock> extraInfos;

    protected AbstractExtraInfoCmd(int n, SnacPacket snacPacket) {
        super(n);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.extraInfos = ExtraInfoBlock.readExtraInfoBlocks(byteBlock);
    }

    protected AbstractExtraInfoCmd(int n, Collection<ExtraInfoBlock> collection) {
        super(n);
        this.extraInfos = DefensiveTools.getSafeNonnullListCopy(collection, "blocks");
    }

    public final List<ExtraInfoBlock> getExtraInfos() {
        return this.extraInfos;
    }

    @Override
    public void writeData(OutputStream outputStream) throws IOException {
        if (this.extraInfos != null) {
            ByteBlock.createByteBlock(this.extraInfos).write(outputStream);
        }
    }

    public String toString() {
        return MiscTools.getClassName(this) + ": blocks=" + (this.extraInfos == null ? null : this.extraInfos);
    }
}

