/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.SeqNum;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flap.FlapCommandFactory;
import net.kano.joscar.flap.FlapHeader;
import net.kano.joscar.flap.FlapPacket;
import net.kano.joscar.flap.FlapPacketEvent;
import net.kano.joscar.flap.FlapPacketListener;
import net.kano.joscar.flap.VetoableFlapPacketListener;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.net.ConnProcessor;
import net.kano.joscar.net.ConnProcessorExceptionEvent;

public class FlapProcessor
extends ConnProcessor {
    private static final Logger logger = LoggingSystem.getLogger("net.kano.joscar.flap");
    private static final int SEQNUM_MAX = 65535;
    private final CopyOnWriteArrayList<FlapPacketListener> packetListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<VetoableFlapPacketListener> vetoablePacketListeners = new CopyOnWriteArrayList();
    private final Object writeLock = new Object();
    private final Object readLock = new Object();
    private SeqNum seqNum = new SeqNum(0L, 65535L);
    private FlapCommandFactory commandFactory = null;

    public FlapProcessor() {
    }

    public FlapProcessor(Socket socket) throws IOException {
        this.attachToSocket(socket);
    }

    public final void addVetoablePacketListener(VetoableFlapPacketListener vetoableFlapPacketListener) {
        DefensiveTools.checkNull(vetoableFlapPacketListener, "listener");
        this.vetoablePacketListeners.addIfAbsent(vetoableFlapPacketListener);
    }

    public final void removeVetoablePacketListener(VetoableFlapPacketListener vetoableFlapPacketListener) {
        DefensiveTools.checkNull(vetoableFlapPacketListener, "listener");
        this.vetoablePacketListeners.remove(vetoableFlapPacketListener);
    }

    public final void addPacketListener(FlapPacketListener flapPacketListener) {
        DefensiveTools.checkNull(flapPacketListener, "listener");
        this.packetListeners.addIfAbsent(flapPacketListener);
    }

    public final void removePacketListener(FlapPacketListener flapPacketListener) {
        DefensiveTools.checkNull(flapPacketListener, "listener");
        this.packetListeners.remove(flapPacketListener);
    }

    public final synchronized void setFlapCmdFactory(FlapCommandFactory flapCommandFactory) {
        this.commandFactory = flapCommandFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handlePacket(FlapPacket flapPacket) {
        FlapCommandFactory flapCommandFactory;
        DefensiveTools.checkNull(flapPacket, "packet");
        boolean bl = logger.logFineEnabled();
        boolean bl2 = logger.logFinerEnabled();
        if (bl) {
            logger.logFine("FlapProcessor received packet: " + flapPacket);
        }
        Object object = this;
        synchronized (object) {
            flapCommandFactory = this.commandFactory;
        }
        object = null;
        if (flapCommandFactory != null) {
            try {
                object = flapCommandFactory.genFlapCommand(flapPacket);
            }
            catch (Throwable throwable) {
                this.handleException(ConnProcessorExceptionEvent.ERRTYPE_CMD_GEN, throwable, flapPacket);
            }
        }
        if (bl) {
            logger.logFine("Flap command for " + flapPacket + ": " + object);
        }
        FlapPacketEvent flapPacketEvent = new FlapPacketEvent(this, flapPacket, (FlapCommand)object);
        for (VetoableFlapPacketListener object2 : this.vetoablePacketListeners) {
            VetoableFlapPacketListener.VetoResult vetoResult;
            if (bl2) {
                logger.logFiner("Running vetoable flap packet listener: " + object2);
            }
            try {
                vetoResult = object2.handlePacket(flapPacketEvent);
            }
            catch (Throwable throwable) {
                this.handleException(ConnProcessorExceptionEvent.ERRTYPE_PACKET_LISTENER, throwable, object2);
                continue;
            }
            if (vetoResult == VetoableFlapPacketListener.VetoResult.CONTINUE_PROCESSING) continue;
            if (bl2) {
                logger.logFiner("Flap packet listener vetoed further processing: " + object2);
            }
            return;
        }
        for (FlapPacketListener flapPacketListener : this.packetListeners) {
            if (bl2) {
                logger.logFiner("Running Flap packet listener " + flapPacketListener);
            }
            try {
                flapPacketListener.handleFlapPacket(flapPacketEvent);
            }
            catch (Throwable throwable) {
                this.handleException(ConnProcessorExceptionEvent.ERRTYPE_PACKET_LISTENER, throwable, flapPacketListener);
            }
        }
        if (bl2) {
            logger.logFiner("Finished handling Flap packet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendFlap(FlapCommand flapCommand) {
        DefensiveTools.checkNull(flapCommand, "command");
        boolean bl = logger.logFineEnabled();
        boolean bl2 = logger.logFinerEnabled();
        OutputStream outputStream = this.getOutputStream();
        if (outputStream == null) {
            return;
        }
        if (bl2) {
            logger.logFiner("Sending Flap command " + flapCommand);
        }
        Object object = this.writeLock;
        synchronized (object) {
            ByteBlock byteBlock;
            int n = (int)this.seqNum.next();
            FlapPacket flapPacket = new FlapPacket(n, flapCommand);
            try {
                byteBlock = ByteBlock.createByteBlock(flapPacket);
            }
            catch (Throwable throwable) {
                this.handleException(ConnProcessorExceptionEvent.ERRTYPE_CMD_WRITE, throwable, flapCommand);
                return;
            }
            if (bl) {
                logger.logFine("Sending Flap packet " + flapPacket + ": " + byteBlock.getLength() + " total bytes");
            }
            try {
                byteBlock.write(outputStream);
            }
            catch (IOException iOException) {
                this.handleException(ConnProcessorExceptionEvent.ERRTYPE_CONNECTION_ERROR, iOException);
                return;
            }
        }
        if (bl2) {
            logger.logFiner("Finished sending Flap command");
        }
    }

    public final void runFlapLoop() throws IOException {
        while (this.readNextFlap()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean readNextFlap() throws IOException {
        boolean bl = logger.logFinerEnabled();
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            return false;
        }
        Object object = this.readLock;
        synchronized (object) {
            FlapHeader flapHeader = FlapHeader.readFLAPHeader(inputStream);
            if (bl) {
                logger.logFiner("Read flap header " + flapHeader);
            }
            if (flapHeader == null) {
                return false;
            }
            FlapPacket flapPacket = FlapPacket.readRestOfFlap(flapHeader, inputStream);
            if (bl) {
                logger.logFiner("Read flap packet " + flapPacket);
            }
            if (flapPacket == null) {
                return false;
            }
            this.handlePacket(flapPacket);
            return true;
        }
    }

    public String toString() {
        return "FlapProcessor: seqNum=" + this.seqNum;
    }
}

