/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.trust;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joustsim.trust.CertificateHolder;
import net.kano.joustsim.trust.CertificateTrustListener;
import net.kano.joustsim.trust.CertificateTrustManager;
import net.kano.joustsim.trust.DefaultCertificateHolder;
import net.kano.joustsim.trust.SignerInfo;
import net.kano.joustsim.trust.SignerTrustManager;
import net.kano.joustsim.trust.TrustTools;
import net.kano.joustsim.trust.TrustedCertificateInfo;
import net.kano.joustsim.trust.TrustedCertificatesListener;

public class TrustedCertificatesTracker {
    private static final Logger LOGGER = Logger.getLogger(TrustedCertificatesTracker.class.getName());
    private final CertificateTrustManager certTrustMgr;
    private final SignerTrustManager signerTrustMgr;
    private Map<CertificateHolder, TrustedCertificateInfoImpl> trackedCerts = new HashMap<CertificateHolder, TrustedCertificateInfoImpl>();
    private Map<X509Certificate, SignerInfoImpl> signers = new HashMap<X509Certificate, SignerInfoImpl>();
    private CopyOnWriteArrayList<TrustedCertificatesListener> listeners = new CopyOnWriteArrayList();

    public TrustedCertificatesTracker(CertificateTrustManager certificateTrustManager, SignerTrustManager signerTrustManager) {
        this.certTrustMgr = certificateTrustManager;
        this.signerTrustMgr = signerTrustManager;
        if (certificateTrustManager != null) {
            certificateTrustManager.addTrustListener(new CertificateTrustListener(){

                public void trustAdded(CertificateTrustManager certificateTrustManager, X509Certificate x509Certificate) {
                    LOGGER.info("TrustedCertificatesTracker: now trusted: " + x509Certificate.getSubjectDN());
                    TrustedCertificatesTracker.this.certTrustAdded(x509Certificate);
                }

                public void trustRemoved(CertificateTrustManager certificateTrustManager, X509Certificate x509Certificate) {
                    TrustedCertificatesTracker.this.certTrustRemoved(x509Certificate);
                }
            });
        } else {
            LOGGER.fine("Warning: Trusted certificates tracker will not track explicitly trusted certificates since the certificate trust manager is null");
        }
        if (signerTrustManager != null) {
            signerTrustManager.addTrustListener(new CertificateTrustListener(){

                public void trustAdded(CertificateTrustManager certificateTrustManager, X509Certificate x509Certificate) {
                    TrustedCertificatesTracker.this.signerTrustAdded(x509Certificate);
                }

                public void trustRemoved(CertificateTrustManager certificateTrustManager, X509Certificate x509Certificate) {
                    TrustedCertificatesTracker.this.signerTrustRemoved(x509Certificate);
                }
            });
        } else {
            LOGGER.fine("Warning: Trusted certificates tracker will not track signer-trusted certificates since the signer trust manager is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signerTrustAdded(X509Certificate x509Certificate) {
        ArrayList<TrustedCertificateInfoImpl> arrayList = new ArrayList<TrustedCertificateInfoImpl>();
        TrustedCertificatesTracker trustedCertificatesTracker = this;
        synchronized (trustedCertificatesTracker) {
            for (TrustedCertificateInfoImpl trustedCertificateInfoImpl : this.trackedCerts.values()) {
                boolean bl = trustedCertificateInfoImpl.isSomehowTrusted();
                X509Certificate x509Certificate2 = trustedCertificateInfoImpl.getCertificate();
                if (!TrustTools.isSigned(x509Certificate, x509Certificate2)) continue;
                this.registerSignerSignee(trustedCertificateInfoImpl, x509Certificate);
                if (bl || !trustedCertificateInfoImpl.isSomehowTrusted()) continue;
                arrayList.add(trustedCertificateInfoImpl);
            }
        }
        for (TrustedCertificateInfoImpl trustedCertificateInfoImpl : arrayList) {
            this.fireNowTrustedEvent(trustedCertificateInfoImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signerTrustRemoved(X509Certificate x509Certificate) {
        ArrayList<TrustedCertificateInfoImpl> arrayList = new ArrayList<TrustedCertificateInfoImpl>();
        TrustedCertificatesTracker trustedCertificatesTracker = this;
        synchronized (trustedCertificatesTracker) {
            SignerInfo certificateHolder = this.signers.get(x509Certificate);
            if (certificateHolder == null) {
                return;
            }
            List<TrustedCertificateInfo> list = certificateHolder.getSignedCerts();
            for (TrustedCertificateInfo trustedCertificateInfo : list) {
                TrustedCertificateInfoImpl trustedCertificateInfoImpl = (TrustedCertificateInfoImpl)trustedCertificateInfo;
                boolean bl = trustedCertificateInfoImpl.isSomehowTrusted();
                trustedCertificateInfoImpl.removeSigner(certificateHolder);
                if (!bl || trustedCertificateInfoImpl.isSomehowTrusted()) continue;
                arrayList.add(trustedCertificateInfoImpl);
            }
            this.signers.remove(x509Certificate);
        }
        for (TrustedCertificateInfoImpl trustedCertificateInfoImpl : arrayList) {
            this.fireNoLongerTrustedEvent(trustedCertificateInfoImpl);
        }
    }

    private void fireNowTrustedEvent(TrustedCertificateInfo trustedCertificateInfo) {
        assert (!Thread.holdsLock(this));
        for (TrustedCertificatesListener trustedCertificatesListener : this.listeners) {
            trustedCertificatesListener.certificateTrusted(this, trustedCertificateInfo);
        }
    }

    private void fireNoLongerTrustedEvent(TrustedCertificateInfo trustedCertificateInfo) {
        assert (!Thread.holdsLock(this));
        for (TrustedCertificatesListener trustedCertificatesListener : this.listeners) {
            trustedCertificatesListener.certificateNoLongerTrusted(this, trustedCertificateInfo);
        }
    }

    private synchronized void registerSignerSignee(TrustedCertificateInfoImpl trustedCertificateInfoImpl, X509Certificate x509Certificate) {
        trustedCertificateInfoImpl.addSigner(this.registerSigner(x509Certificate, trustedCertificateInfoImpl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void certTrustAdded(X509Certificate x509Certificate) {
        boolean bl;
        TrustedCertificateInfoImpl trustedCertificateInfoImpl;
        TrustedCertificatesTracker trustedCertificatesTracker = this;
        synchronized (trustedCertificatesTracker) {
            DefaultCertificateHolder defaultCertificateHolder = new DefaultCertificateHolder(x509Certificate);
            trustedCertificateInfoImpl = this.trackedCerts.get(defaultCertificateHolder);
            if (trustedCertificateInfoImpl == null) {
                return;
            }
            boolean bl2 = trustedCertificateInfoImpl.isSomehowTrusted();
            trustedCertificateInfoImpl.setExplicitlyTrusted(true);
            bl = !bl2 && trustedCertificateInfoImpl.isSomehowTrusted();
        }
        if (bl) {
            LOGGER.info("TrustedCertificatesTracker: cert is now trusted, firing events: " + x509Certificate.getSubjectDN());
            this.fireNowTrustedEvent(trustedCertificateInfoImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void certTrustRemoved(X509Certificate x509Certificate) {
        boolean bl;
        TrustedCertificateInfoImpl trustedCertificateInfoImpl;
        TrustedCertificatesTracker trustedCertificatesTracker = this;
        synchronized (trustedCertificatesTracker) {
            DefaultCertificateHolder defaultCertificateHolder = new DefaultCertificateHolder(x509Certificate);
            trustedCertificateInfoImpl = this.trackedCerts.get(defaultCertificateHolder);
            if (trustedCertificateInfoImpl == null) {
                return;
            }
            boolean bl2 = trustedCertificateInfoImpl.isSomehowTrusted();
            trustedCertificateInfoImpl.setExplicitlyTrusted(false);
            bl = bl2 && !trustedCertificateInfoImpl.isSomehowTrusted();
        }
        if (bl) {
            this.fireNoLongerTrustedEvent(trustedCertificateInfoImpl);
        }
    }

    public void addTrustedCertsListener(TrustedCertificatesListener trustedCertificatesListener) {
        this.listeners.addIfAbsent((Object)trustedCertificatesListener);
    }

    public void removeTrustedCertsListener(TrustedCertificatesListener trustedCertificatesListener) {
        this.listeners.remove((Object)trustedCertificatesListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTrackedCertificate(X509Certificate x509Certificate) {
        boolean bl;
        TrustedCertificateInfoImpl trustedCertificateInfoImpl;
        DefensiveTools.checkNull((Object)x509Certificate, (String)"cert");
        TrustedCertificatesTracker trustedCertificatesTracker = this;
        synchronized (trustedCertificatesTracker) {
            DefaultCertificateHolder defaultCertificateHolder = new DefaultCertificateHolder(x509Certificate);
            if (this.trackedCerts.containsKey(defaultCertificateHolder)) {
                return false;
            }
            trustedCertificateInfoImpl = new TrustedCertificateInfoImpl(x509Certificate);
            CertificateTrustManager certificateTrustManager = this.certTrustMgr;
            boolean bl2 = certificateTrustManager != null ? certificateTrustManager.isTrusted(x509Certificate) : false;
            trustedCertificateInfoImpl.setExplicitlyTrusted(bl2);
            SignerTrustManager signerTrustManager = this.signerTrustMgr;
            if (signerTrustManager != null) {
                List<X509Certificate> list = signerTrustManager.getTrustedSigners(x509Certificate);
                for (X509Certificate x509Certificate2 : list) {
                    if (x509Certificate2 == null) continue;
                    this.registerSignerSignee(trustedCertificateInfoImpl, x509Certificate2);
                }
            }
            this.trackedCerts.put(defaultCertificateHolder, trustedCertificateInfoImpl);
            bl = trustedCertificateInfoImpl.isSomehowTrusted();
        }
        if (bl) {
            LOGGER.info("TrustedCertificatesTracker: cert " + x509Certificate.getSubjectDN() + " is now trusted");
            this.fireNowTrustedEvent(trustedCertificateInfoImpl);
        }
        return true;
    }

    private synchronized SignerInfo registerSigner(X509Certificate x509Certificate, TrustedCertificateInfoImpl trustedCertificateInfoImpl) {
        DefensiveTools.checkNull((Object)x509Certificate, (String)"signer");
        DefensiveTools.checkNull((Object)trustedCertificateInfoImpl, (String)"signee");
        SignerInfoImpl signerInfoImpl = this.getSignerInfoInstance(x509Certificate);
        signerInfoImpl.addSignee(trustedCertificateInfoImpl);
        return signerInfoImpl;
    }

    private SignerInfoImpl getSignerInfoInstance(X509Certificate x509Certificate) {
        assert (Thread.holdsLock(this));
        SignerInfoImpl signerInfoImpl = this.signers.get(x509Certificate);
        if (signerInfoImpl == null) {
            signerInfoImpl = new SignerInfoImpl(x509Certificate);
            this.signers.put(x509Certificate, signerInfoImpl);
        }
        return signerInfoImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTrackedCertificate(X509Certificate x509Certificate) {
        boolean bl;
        TrustedCertificateInfo trustedCertificateInfo;
        DefensiveTools.checkNull((Object)x509Certificate, (String)"cert");
        TrustedCertificatesTracker trustedCertificatesTracker = this;
        synchronized (trustedCertificatesTracker) {
            trustedCertificateInfo = this.trackedCerts.remove(new DefaultCertificateHolder(x509Certificate));
            if (trustedCertificateInfo == null) {
                return false;
            }
            bl = trustedCertificateInfo.isSomehowTrusted();
            List<SignerInfo> list = trustedCertificateInfo.getSigners();
            for (SignerInfo signerInfo : list) {
                SignerInfoImpl signerInfoImpl = (SignerInfoImpl)signerInfo;
                signerInfoImpl.removeSignee(trustedCertificateInfo);
            }
        }
        if (bl) {
            this.fireNoLongerTrustedEvent(trustedCertificateInfo);
        }
        return true;
    }

    public synchronized boolean isTrusted(X509Certificate x509Certificate) {
        DefaultCertificateHolder defaultCertificateHolder = new DefaultCertificateHolder(x509Certificate);
        TrustedCertificateInfo trustedCertificateInfo = this.trackedCerts.get(defaultCertificateHolder);
        if (trustedCertificateInfo == null) {
            return false;
        }
        return trustedCertificateInfo.isSomehowTrusted();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SignerInfoImpl
    extends DefaultCertificateHolder
    implements SignerInfo {
        private final Set<TrustedCertificateInfo> signees = new HashSet<TrustedCertificateInfo>(10);

        private SignerInfoImpl(X509Certificate x509Certificate) {
            super(x509Certificate);
        }

        private synchronized void addSignee(TrustedCertificateInfoImpl trustedCertificateInfoImpl) {
            DefensiveTools.checkNull((Object)trustedCertificateInfoImpl, (String)"signee");
            assert (TrustTools.isSigned(this.getCertificate(), trustedCertificateInfoImpl.getCertificate()));
            this.signees.add(trustedCertificateInfoImpl);
        }

        @Override
        public synchronized List<TrustedCertificateInfo> getSignedCerts() {
            return DefensiveTools.getUnmodifiableCopy(this.signees);
        }

        private synchronized void removeSignee(TrustedCertificateInfo trustedCertificateInfo) {
            DefensiveTools.checkNull((Object)trustedCertificateInfo, (String)"signee");
            this.signees.remove(trustedCertificateInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TrustedCertificateInfoImpl
    extends DefaultCertificateHolder
    implements TrustedCertificateInfo {
        private boolean explicitlyTrusted = false;
        private final Set<SignerInfo> signers = new HashSet<SignerInfo>(5);

        private TrustedCertificateInfoImpl(X509Certificate x509Certificate) {
            super(x509Certificate);
        }

        @Override
        public synchronized boolean isSomehowTrusted() {
            return this.explicitlyTrusted || !this.signers.isEmpty();
        }

        @Override
        public synchronized boolean isExplicitlyTrusted() {
            return this.explicitlyTrusted;
        }

        private synchronized void setExplicitlyTrusted(boolean bl) {
            this.explicitlyTrusted = bl;
        }

        private synchronized boolean addSigner(SignerInfo signerInfo) {
            DefensiveTools.checkNull((Object)signerInfo, (String)"signer");
            return this.signers.add(signerInfo);
        }

        @Override
        public synchronized List<SignerInfo> getSigners() {
            return DefensiveTools.getUnmodifiableCopy(this.signers);
        }

        @Override
        public synchronized boolean isSignedBy(SignerInfo signerInfo) {
            DefensiveTools.checkNull((Object)signerInfo, (String)"signer");
            return this.signers.contains(signerInfo);
        }

        private synchronized boolean removeSigner(SignerInfo signerInfo) {
            DefensiveTools.checkNull((Object)signerInfo, (String)"signer");
            return this.signers.remove(signerInfo);
        }
    }
}

