/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.out;

import java.util.Random;
import pl.mn.communicator.Gender;
import pl.mn.communicator.PersonalInfo;
import pl.mn.communicator.PublicDirSearchQuery;
import pl.mn.communicator.packet.GGPubdirConsts;
import pl.mn.communicator.packet.GGUtils;
import pl.mn.communicator.packet.out.GGOutgoingPackage;

public class GGPubdirRequest
implements GGOutgoingPackage,
GGPubdirConsts {
    public static final int GG_PUBDIR50_REQUEST = 20;
    private static final Random SEQUENCER = new Random();
    private byte m_requestType = (byte)-1;
    private int m_seq = SEQUENCER.nextInt(99999);
    private String m_request = "";

    private GGPubdirRequest() {
    }

    public int getSequenceID() {
        return this.m_seq;
    }

    public int getPacketType() {
        return 20;
    }

    public int getLength() {
        return 5 + GGUtils.stringToBytes(this.m_request).length;
    }

    public byte[] getContents() {
        byte[] toSend = new byte[this.getLength()];
        toSend[0] = this.m_requestType;
        toSend[1] = (byte)(this.m_seq & 0xFF);
        toSend[2] = (byte)(this.m_seq >> 8 & 0xFF);
        toSend[3] = (byte)(this.m_seq >> 16 & 0xFF);
        toSend[4] = (byte)(this.m_seq >> 24 & 0xFF);
        byte[] requestBytes = GGUtils.stringToBytes(this.m_request);
        for (int i = 0; i < requestBytes.length; ++i) {
            toSend[5 + i] = requestBytes[i];
        }
        return toSend;
    }

    public static GGPubdirRequest createSearchPubdirRequest(PublicDirSearchQuery publicDirQuery) {
        GGPubdirRequest pubdirRequest = new GGPubdirRequest();
        pubdirRequest.m_requestType = (byte)3;
        StringBuffer buffer = new StringBuffer();
        if (publicDirQuery.getUin() != null) {
            Integer uin = publicDirQuery.getUin();
            String uinEntry = GGPubdirRequest.getEntry("FmNumber", String.valueOf(uin));
            buffer.append(uinEntry);
        }
        if (publicDirQuery.getFirstName() != null) {
            String firstNameEntry = GGPubdirRequest.getEntry("firstname", publicDirQuery.getFirstName());
            buffer.append(firstNameEntry);
        }
        if (publicDirQuery.getLastName() != null) {
            String lastNameEntry = GGPubdirRequest.getEntry("lastname", publicDirQuery.getLastName());
            buffer.append(lastNameEntry);
        }
        if (publicDirQuery.getCity() != null) {
            String cityEntry = GGPubdirRequest.getEntry("city", publicDirQuery.getCity());
            buffer.append(cityEntry);
        }
        if (publicDirQuery.getNickName() != null) {
            String nickNameEntry = GGPubdirRequest.getEntry("nickname", publicDirQuery.getNickName());
            buffer.append(nickNameEntry);
        }
        if (publicDirQuery.getBirthYear() != null) {
            String birthEntry = GGPubdirRequest.getEntry("birthyear", publicDirQuery.getBirthYear());
            buffer.append(birthEntry);
        }
        if (publicDirQuery.getGender() != null) {
            Gender gender = publicDirQuery.getGender();
            String genderEntry = GGPubdirRequest.getEntry("gender", gender == Gender.MALE ? "2" : "1");
            buffer.append(genderEntry);
        }
        if (publicDirQuery.getFamilyName() != null) {
            String familyNameEntry = GGPubdirRequest.getEntry("familyname", publicDirQuery.getFamilyName());
            buffer.append(familyNameEntry);
        }
        if (publicDirQuery.getFamilyCity() != null) {
            String familyCityEntry = GGPubdirRequest.getEntry("familycity", publicDirQuery.getFamilyCity());
            buffer.append(familyCityEntry);
        }
        if (publicDirQuery.getStart() != null) {
            Integer startInteger = publicDirQuery.getStart();
            String startEntry = GGPubdirRequest.getEntry("fmstart", String.valueOf(startInteger));
            buffer.append(startEntry);
        }
        pubdirRequest.m_request = buffer.toString();
        return pubdirRequest;
    }

    public static GGPubdirRequest createReadPubdirRequest() {
        GGPubdirRequest pubdirRequest = new GGPubdirRequest();
        pubdirRequest.m_requestType = (byte)2;
        pubdirRequest.m_request = "";
        return pubdirRequest;
    }

    public static GGPubdirRequest createWritePubdirRequest(PersonalInfo publicDirInfo) {
        if (publicDirInfo == null) {
            throw new NullPointerException("publicDirInfo cannot be null");
        }
        GGPubdirRequest pubdirRequest = new GGPubdirRequest();
        pubdirRequest.m_requestType = 1;
        pubdirRequest.m_request = GGPubdirRequest.prepareWriteRequest(publicDirInfo);
        return pubdirRequest;
    }

    private static String prepareWriteRequest(PersonalInfo publicDirInfo) {
        StringBuffer buffer = new StringBuffer();
        if (publicDirInfo.getFirstName() != null) {
            String firstNameEntry = GGPubdirRequest.getEntry("firstname", publicDirInfo.getFirstName());
            buffer.append(firstNameEntry);
        }
        if (publicDirInfo.getLastName() != null) {
            String lastNameEntry = GGPubdirRequest.getEntry("lastname", publicDirInfo.getLastName());
            buffer.append(lastNameEntry);
        }
        if (publicDirInfo.getCity() != null) {
            String cityEntry = GGPubdirRequest.getEntry("city", publicDirInfo.getCity());
            buffer.append(cityEntry);
        }
        if (publicDirInfo.getNickName() != null) {
            String nickNameEntry = GGPubdirRequest.getEntry("nickname", publicDirInfo.getNickName());
            buffer.append(nickNameEntry);
        }
        if (publicDirInfo.getGender() != null) {
            Gender gender = publicDirInfo.getGender();
            String genderEntry = GGPubdirRequest.getEntry("gender", gender == Gender.MALE ? "1" : "2");
            buffer.append(genderEntry);
        }
        if (publicDirInfo.getFamilyName() != null) {
            String familyNameEntry = GGPubdirRequest.getEntry("familyname", publicDirInfo.getFamilyName());
            buffer.append(familyNameEntry);
        }
        if (publicDirInfo.getFamilyCity() != null) {
            String familyCityEntry = GGPubdirRequest.getEntry("familycity", publicDirInfo.getFamilyCity());
            buffer.append(familyCityEntry);
        }
        if (publicDirInfo.getBirthDate() != null) {
            String birthDateEntry = GGPubdirRequest.getEntry("birthyear", publicDirInfo.getBirthDate());
            buffer.append(birthDateEntry);
        }
        return buffer.toString();
    }

    private static String getEntry(String key, String value) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(key);
        buffer.append('\u0000');
        buffer.append(value);
        buffer.append('\u0000');
        return buffer.toString();
    }
}

