/*
 * Decompiled with CFR 0.152.
 */
package org.hn.sleek.jmml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import org.hn.sleek.jmml.IncomingMessage;
import org.hn.sleek.jmml.MSNPListener;
import org.hn.sleek.jmml.NotificationServerConnector;
import org.hn.sleek.jmml.OutgoingMessage;
import org.hn.sleek.jmml.ServerConnection;

class SwitchboardSessionConnector
implements MSNPListener {
    static final String MIME_HEADER = "MIME-Version: 1.0\r\nContent-Type: text/plain; charset=UTF-8\r\n\r\n";
    String userName;
    String buddyName;
    String challengeHash;
    String sessionID;
    String serverIP;
    Integer serverPort;
    ServerConnection sc;
    int participants = 0;
    LinkedList queuedMessages;
    boolean calling = false;
    boolean joined = false;
    int transactionID = 0;
    NotificationServerConnector notificationServer;
    protected static LinkedList queuedSessions = new LinkedList();

    public SwitchboardSessionConnector(String userName, String buddyName, NotificationServerConnector notificationServer) {
        this.userName = userName;
        this.buddyName = buddyName;
        this.queuedMessages = new LinkedList();
        this.notificationServer = notificationServer;
    }

    public void setSessionInfo(String serverIP, int serverPort, String sessionID, String challengeHash) {
        this.serverIP = serverIP;
        this.serverPort = new Integer(serverPort);
        this.sessionID = sessionID;
        this.challengeHash = challengeHash;
        this.joined = false;
    }

    public void setCalling(boolean calling) {
        this.calling = calling;
    }

    public void connectSession() {
        this.sc = new ServerConnection(this.serverIP, this.serverPort, this);
        if (this.calling) {
            OutgoingMessage msg = new OutgoingMessage(31, this.getTransactionID());
            msg.addArgument(this.userName);
            msg.addArgument(this.challengeHash);
            this.sc.sendMSNPMessage(msg);
        } else {
            OutgoingMessage msg = new OutgoingMessage(4, this.getTransactionID());
            msg.addArgument(this.userName);
            msg.addArgument(this.challengeHash);
            msg.addArgument(this.sessionID);
            this.sc.sendMSNPMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String message) {
        if (this.joined) {
            OutgoingMessage msg = new OutgoingMessage(19, this.getTransactionID());
            String body = MIME_HEADER + message;
            msg.addArgument("U");
            msg.addArgument(new Integer(body.length()).toString());
            msg.setBody(body);
            this.sc.sendMSNPMessage(msg);
        } else {
            LinkedList linkedList = this.queuedMessages;
            synchronized (linkedList) {
                this.queuedMessages.add(message);
            }
            linkedList = queuedSessions;
            synchronized (linkedList) {
                queuedSessions.add(this);
            }
            this.notificationServer.requestSwitchboardSession();
        }
    }

    public void incomingMSNPMessage(IncomingMessage incomingMessage) {
        switch (incomingMessage.getType()) {
            case 7: {
                this.receivedBYE(incomingMessage);
                break;
            }
            case 31: {
                this.receivedUSR(incomingMessage);
                break;
            }
            case 8: {
                this.receivedCAL(incomingMessage);
                break;
            }
            case 16: {
                this.receivedJOI(incomingMessage);
                break;
            }
            case 15: {
                this.receivedIRO(incomingMessage);
                break;
            }
            case 4: {
                this.receivedANS(incomingMessage);
                break;
            }
            case 19: {
                this.receivedMSG(incomingMessage);
            }
        }
    }

    public void serverDisconnected() {
        System.err.println("SwitchboardSessionConnector.serverDisconnected() - Switchboard server disconnected...");
        this.joined = false;
        this.sc = null;
    }

    private void receivedBYE(IncomingMessage incomingMessage) {
        this.joined = false;
        --this.participants;
        if (this.participants == 0) {
            OutgoingMessage msg = new OutgoingMessage(22, -1);
            this.sc.sendMSNPMessage(msg);
            this.sc = null;
        }
    }

    private void receivedUSR(IncomingMessage incomingMessage) {
        OutgoingMessage msg = new OutgoingMessage(8, this.getTransactionID());
        msg.addArgument(this.buddyName);
        this.sc.sendMSNPMessage(msg);
    }

    private void receivedCAL(IncomingMessage incomingMessage) {
        try {
            this.sessionID = incomingMessage.getSessionID();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private void receivedJOI(IncomingMessage incomingMessage) {
        this.joined = true;
        this.sendQueuedMessages();
        ++this.participants;
    }

    private void receivedIRO(IncomingMessage incomingMessage) {
        ++this.participants;
    }

    private void receivedANS(IncomingMessage incomingMessage) {
        this.joined = true;
    }

    private void receivedMSG(IncomingMessage incomingMessage) {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(incomingMessage.getBody()));
            reader.readLine();
            String type = reader.readLine();
            if (type.indexOf("plain") != -1) {
                StringBuffer bodyBuffer = new StringBuffer();
                String parameters = reader.readLine();
                String line = reader.readLine();
                while (line != null) {
                    bodyBuffer.append(line);
                    line = reader.readLine();
                }
                this.notificationServer.fireIncomingMessageEvent(this.buddyName, incomingMessage.getFriendlyName(), bodyBuffer.toString());
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQueuedMessages() {
        LinkedList linkedList = this.queuedMessages;
        synchronized (linkedList) {
            int messageCount = this.queuedMessages.size();
            for (int i = 0; i < messageCount; ++i) {
                this.sendMessage((String)this.queuedMessages.removeFirst());
            }
        }
    }

    private int getTransactionID() {
        ++this.transactionID;
        return this.transactionID;
    }
}

