/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceLocation;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JAXPUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XMLCatalog
extends DataType
implements Cloneable,
EntityResolver,
URIResolver {
    private static FileUtils fileUtils = FileUtils.newFileUtils();
    public static final String APACHE_RESOLVER = "org.apache.tools.ant.types.resolver.ApacheCatalogResolver";
    public static final String CATALOG_RESOLVER = "org.apache.xml.resolver.tools.CatalogResolver";
    private Vector elements;
    private Path classpath;
    private Path catalogPath;
    private CatalogResolver catalogResolver;
    static /* synthetic */ Class class$org$apache$tools$ant$types$XMLCatalog;
    static /* synthetic */ Class class$java$lang$String;

    private final Vector getElements() {
        return this.getRef().elements;
    }

    private final Path getClasspath() {
        return this.getRef().classpath;
    }

    private final void setElements(Vector vector) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.elements = vector;
    }

    public Path createClasspath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        this.setChecked(false);
        return this.classpath.createPath();
    }

    public void setClasspath(Path path) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
        this.setChecked(false);
    }

    public void setClasspathRef(Reference reference) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createClasspath().setRefid(reference);
        this.setChecked(false);
    }

    public Path createCatalogPath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.catalogPath == null) {
            this.catalogPath = new Path(this.getProject());
        }
        this.setChecked(false);
        return this.catalogPath.createPath();
    }

    public void setCatalogPathRef(Reference reference) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createCatalogPath().setRefid(reference);
        this.setChecked(false);
    }

    public Path getCatalogPath() {
        return this.getRef().catalogPath;
    }

    public void addDTD(ResourceLocation resourceLocation) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.getElements().addElement(resourceLocation);
        this.setChecked(false);
    }

    public void addEntity(ResourceLocation resourceLocation) throws BuildException {
        this.addDTD(resourceLocation);
    }

    public void addConfiguredXMLCatalog(XMLCatalog xMLCatalog) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        Vector vector = xMLCatalog.getElements();
        Vector vector2 = this.getElements();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement(enumeration.nextElement());
        }
        Path path = xMLCatalog.getClasspath();
        this.createClasspath().append(path);
        Path path2 = xMLCatalog.getCatalogPath();
        this.createCatalogPath().append(path2);
        this.setChecked(false);
    }

    public void setRefid(Reference reference) throws BuildException {
        if (!this.elements.isEmpty()) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        Object object;
        if (this.isReference()) {
            return this.getRef().resolveEntity(string, string2);
        }
        if (!this.isChecked()) {
            object = new Stack<XMLCatalog>();
            ((Stack)object).push(this);
            this.dieOnCircularReference((Stack)object, this.getProject());
        }
        this.log("resolveEntity: '" + string + "': '" + string2 + '\'', 4);
        object = this.getCatalogResolver().resolveEntity(string, string2);
        if (object == null) {
            this.log("No matching catalog entry found, parser will use: '" + string2 + '\'', 4);
        }
        return object;
    }

    public Source resolve(String string, String string2) throws TransformerException {
        Object object;
        if (this.isReference()) {
            return this.getRef().resolve(string, string2);
        }
        if (!this.isChecked()) {
            object = new Stack<XMLCatalog>();
            ((Stack)object).push(this);
            this.dieOnCircularReference((Stack)object, this.getProject());
        }
        object = null;
        String string3 = this.removeFragment(string);
        this.log("resolve: '" + string3 + "' with base: '" + string2 + '\'', 4);
        object = (SAXSource)this.getCatalogResolver().resolve(string3, string2);
        if (object == null) {
            this.log("No matching catalog entry found, parser will use: '" + string + '\'', 4);
            object = new SAXSource();
            URL uRL = null;
            try {
                uRL = string2 == null ? fileUtils.getFileURL(this.getProject().getBaseDir()) : new URL(string2);
                URL uRL2 = string3.length() == 0 ? uRL : new URL(uRL, string3);
                ((SAXSource)object).setInputSource(new InputSource(uRL2.toString()));
            }
            catch (MalformedURLException malformedURLException) {
                ((SAXSource)object).setInputSource(new InputSource(string3));
            }
        }
        this.setEntityResolver((SAXSource)object);
        return object;
    }

    private final XMLCatalog getRef() {
        if (!this.isReference()) {
            return this;
        }
        Class clazz = class$org$apache$tools$ant$types$XMLCatalog;
        if (clazz == null) {
            clazz = class$org$apache$tools$ant$types$XMLCatalog = XMLCatalog.class("[Lorg.apache.tools.ant.types.XMLCatalog;", false);
        }
        return (XMLCatalog)this.getCheckedRef(clazz, "xmlcatalog");
    }

    private final CatalogResolver getCatalogResolver() {
        if (this.catalogResolver == null) {
            AntClassLoader antClassLoader = null;
            antClassLoader = this.getProject().createClassLoader(Path.systemClasspath);
            try {
                Class<?> clazz = Class.forName(APACHE_RESOLVER, true, antClassLoader);
                ClassLoader classLoader = clazz.getClassLoader();
                Class<?> clazz2 = Class.forName(CATALOG_RESOLVER, true, classLoader);
                ClassLoader classLoader2 = clazz2.getClassLoader();
                clazz = Class.forName(APACHE_RESOLVER, true, classLoader2);
                Object obj = clazz.newInstance();
                this.catalogResolver = new ExternalResolver(clazz, obj);
            }
            catch (Throwable throwable) {
                this.catalogResolver = new InternalResolver();
                if (this.getCatalogPath() != null && this.getCatalogPath().list().length != 0) {
                    this.log("Warning: catalogpath listing external catalogs will be ignored", 1);
                }
                this.log("Failed to load Apache resolver: " + throwable, 4);
            }
        }
        return this.catalogResolver;
    }

    private final void setEntityResolver(SAXSource sAXSource) throws TransformerException {
        XMLReader xMLReader = sAXSource.getXMLReader();
        if (xMLReader == null) {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            try {
                xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new TransformerException(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(sAXException);
            }
        }
        xMLReader.setEntityResolver(this);
        sAXSource.setXMLReader(xMLReader);
    }

    private final ResourceLocation findMatchingEntry(String string) {
        Enumeration enumeration = this.getElements().elements();
        ResourceLocation resourceLocation = null;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof ResourceLocation) || !(resourceLocation = (ResourceLocation)e).getPublicId().equals(string)) continue;
            return resourceLocation;
        }
        return null;
    }

    private final String removeFragment(String string) {
        String string2 = string;
        int n = string.indexOf("#");
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private final InputSource filesystemLookup(ResourceLocation resourceLocation) {
        String string;
        File file;
        String string2 = resourceLocation.getLocation();
        string2 = string2.replace(File.separatorChar, '/');
        URL uRL = null;
        if (resourceLocation.getBase() != null) {
            uRL = resourceLocation.getBase();
        } else {
            try {
                uRL = fileUtils.getFileURL(this.getProject().getBaseDir());
            }
            catch (MalformedURLException malformedURLException) {
                throw new BuildException("Project basedir cannot be converted to a URL");
            }
        }
        InputSource inputSource = null;
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string2);
        }
        catch (MalformedURLException malformedURLException) {
            file = new File(string2);
            if (file.exists() && file.canRead()) {
                this.log("uri : '" + string2 + "' matches a readable file", 4);
                try {
                    uRL2 = fileUtils.getFileURL(file);
                }
                catch (MalformedURLException malformedURLException2) {
                    throw new BuildException("could not find an URL for :" + file.getAbsolutePath());
                }
            }
            this.log("uri : '" + string2 + "' does not match a readable file", 4);
        }
        if (uRL2 != null && (string = uRL2.getFile()) != null) {
            this.log("fileName " + string, 4);
            file = new File(string);
            if (file.exists() && file.canRead()) {
                try {
                    inputSource = new InputSource(new FileInputStream(file));
                    String string3 = JAXPUtils.getSystemId(file);
                    inputSource.setSystemId(string3);
                    this.log("catalog entry matched a readable file: '" + string3 + '\'', 4);
                }
                catch (IOException iOException) {}
            }
        }
        return inputSource;
    }

    private final InputSource classpathLookup(ResourceLocation resourceLocation) {
        InputSource inputSource = null;
        AntClassLoader antClassLoader = null;
        Path path = this.classpath;
        path = path != null ? this.classpath.concatSystemClasspath("ignore") : new Path(this.getProject()).concatSystemClasspath("last");
        antClassLoader = this.getProject().createClassLoader(path);
        InputStream inputStream = antClassLoader.getResourceAsStream(resourceLocation.getLocation());
        if (inputStream != null) {
            inputSource = new InputSource(inputStream);
            URL uRL = antClassLoader.getResource(resourceLocation.getLocation());
            String string = uRL.toExternalForm();
            inputSource.setSystemId(string);
            this.log("catalog entry matched a resource in the classpath: '" + string + '\'', 4);
        }
        return inputSource;
    }

    private final InputSource urlLookup(ResourceLocation resourceLocation) {
        String string = resourceLocation.getLocation();
        URL uRL = null;
        if (resourceLocation.getBase() != null) {
            uRL = resourceLocation.getBase();
        } else {
            try {
                uRL = fileUtils.getFileURL(this.getProject().getBaseDir());
            }
            catch (MalformedURLException malformedURLException) {
                throw new BuildException("Project basedir cannot be converted to a URL");
            }
        }
        InputSource inputSource = null;
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {}
        if (uRL2 != null) {
            try {
                InputStream inputStream = uRL2.openStream();
                if (inputStream != null) {
                    inputSource = new InputSource(inputStream);
                    String string2 = uRL2.toExternalForm();
                    inputSource.setSystemId(string2);
                    this.log("catalog entry matched as a URL: '" + string2 + '\'', 4);
                }
            }
            catch (IOException iOException) {}
        }
        return inputSource;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.elements = new Vector();
        this.catalogResolver = null;
    }

    public XMLCatalog() {
        this.this();
        this.setChecked(false);
    }

    private static interface CatalogResolver
    extends URIResolver,
    EntityResolver {
        public InputSource resolveEntity(String var1, String var2);

        public Source resolve(String var1, String var2) throws TransformerException;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ExternalResolver
    implements CatalogResolver {
        private Method setXMLCatalog;
        private Method parseCatalog;
        private Method resolveEntity;
        private Method resolve;
        private Object resolverImpl;
        private boolean externalCatalogsProcessed;

        public InputSource resolveEntity(String string, String string2) {
            InputSource inputSource = null;
            this.processExternalCatalogs();
            ResourceLocation resourceLocation = XMLCatalog.this.findMatchingEntry(string);
            if (resourceLocation != null) {
                XMLCatalog.this.log("Matching catalog entry found for publicId: '" + resourceLocation.getPublicId() + "' location: '" + resourceLocation.getLocation() + '\'', 4);
                inputSource = XMLCatalog.this.filesystemLookup(resourceLocation);
                if (inputSource == null) {
                    inputSource = XMLCatalog.this.classpathLookup(resourceLocation);
                }
                if (inputSource == null) {
                    try {
                        inputSource = (InputSource)this.resolveEntity.invoke(this.resolverImpl, string, string2);
                    }
                    catch (Exception exception) {
                        throw new BuildException(exception);
                    }
                }
            } else {
                try {
                    inputSource = (InputSource)this.resolveEntity.invoke(this.resolverImpl, string, string2);
                }
                catch (Exception exception) {
                    throw new BuildException(exception);
                }
            }
            return inputSource;
        }

        public Source resolve(String string, String string2) throws TransformerException {
            SAXSource sAXSource = null;
            InputSource inputSource = null;
            this.processExternalCatalogs();
            ResourceLocation resourceLocation = XMLCatalog.this.findMatchingEntry(string);
            if (resourceLocation != null) {
                XMLCatalog.this.log("Matching catalog entry found for uri: '" + resourceLocation.getPublicId() + "' location: '" + resourceLocation.getLocation() + '\'', 4);
                ResourceLocation resourceLocation2 = resourceLocation;
                if (string2 != null) {
                    try {
                        URL uRL = new URL(string2);
                        resourceLocation2 = new ResourceLocation();
                        resourceLocation2.setBase(uRL);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                resourceLocation2.setPublicId(resourceLocation.getPublicId());
                resourceLocation2.setLocation(resourceLocation.getLocation());
                inputSource = XMLCatalog.this.filesystemLookup(resourceLocation2);
                if (inputSource == null) {
                    inputSource = XMLCatalog.this.classpathLookup(resourceLocation2);
                }
                if (inputSource != null) {
                    sAXSource = new SAXSource(inputSource);
                } else {
                    try {
                        sAXSource = (SAXSource)this.resolve.invoke(this.resolverImpl, string, string2);
                    }
                    catch (Exception exception) {
                        throw new BuildException(exception);
                    }
                }
            } else {
                try {
                    sAXSource = (SAXSource)this.resolve.invoke(this.resolverImpl, string, string2);
                }
                catch (Exception exception) {
                    throw new BuildException(exception);
                }
            }
            return sAXSource;
        }

        private final void processExternalCatalogs() {
            if (!this.externalCatalogsProcessed) {
                try {
                    this.setXMLCatalog.invoke(this.resolverImpl, XMLCatalog.this);
                }
                catch (Exception exception) {
                    throw new BuildException(exception);
                }
                Path path = XMLCatalog.this.getCatalogPath();
                if (path != null) {
                    XMLCatalog.this.log("Using catalogpath '" + XMLCatalog.this.getCatalogPath() + '\'', 4);
                    String[] stringArray = XMLCatalog.this.getCatalogPath().list();
                    int n = 0;
                    while (n < stringArray.length) {
                        File file = new File(stringArray[n]);
                        XMLCatalog.this.log("Parsing " + file, 4);
                        try {
                            this.parseCatalog.invoke(this.resolverImpl, file.getPath());
                        }
                        catch (Exception exception) {
                            throw new BuildException(exception);
                        }
                        ++n;
                    }
                }
            }
            this.externalCatalogsProcessed = true;
        }

        private final /* synthetic */ void this() {
            this.setXMLCatalog = null;
            this.parseCatalog = null;
            this.resolveEntity = null;
            this.resolve = null;
            this.resolverImpl = null;
            this.externalCatalogsProcessed = false;
        }

        public ExternalResolver(Class clazz, Object object) {
            this.this();
            this.resolverImpl = object;
            try {
                Class clazz2;
                Class clazz3;
                Class[] classArray = new Class[1];
                Class clazz4 = class$org$apache$tools$ant$types$XMLCatalog;
                if (clazz4 == null) {
                    clazz4 = class$org$apache$tools$ant$types$XMLCatalog = XMLCatalog.class("[Lorg.apache.tools.ant.types.XMLCatalog;", false);
                }
                classArray[0] = clazz4;
                this.setXMLCatalog = clazz.getMethod("setXMLCatalog", classArray);
                Class[] classArray2 = new Class[1];
                Class clazz5 = class$java$lang$String;
                if (clazz5 == null) {
                    clazz5 = class$java$lang$String = XMLCatalog.class("[Ljava.lang.String;", false);
                }
                classArray2[0] = clazz5;
                this.parseCatalog = clazz.getMethod("parseCatalog", classArray2);
                Class[] classArray3 = new Class[2];
                Class clazz6 = class$java$lang$String;
                if (clazz6 == null) {
                    clazz6 = classArray3[0] = (class$java$lang$String = XMLCatalog.class("[Ljava.lang.String;", false));
                }
                if ((clazz3 = class$java$lang$String) == null) {
                    clazz3 = class$java$lang$String = XMLCatalog.class("[Ljava.lang.String;", false);
                }
                classArray3[1] = clazz3;
                this.resolveEntity = clazz.getMethod("resolveEntity", classArray3);
                Class[] classArray4 = new Class[2];
                Class clazz7 = class$java$lang$String;
                if (clazz7 == null) {
                    clazz7 = classArray4[0] = (class$java$lang$String = XMLCatalog.class("[Ljava.lang.String;", false));
                }
                if ((clazz2 = class$java$lang$String) == null) {
                    clazz2 = class$java$lang$String = XMLCatalog.class("[Ljava.lang.String;", false);
                }
                classArray4[1] = clazz2;
                this.resolve = clazz.getMethod("resolve", classArray4);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new BuildException(noSuchMethodException);
            }
            XMLCatalog.this.log("Apache resolver library found, xml-commons resolver will be used", 3);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class InternalResolver
    implements CatalogResolver {
        public InputSource resolveEntity(String string, String string2) {
            InputSource inputSource = null;
            ResourceLocation resourceLocation = XMLCatalog.this.findMatchingEntry(string);
            if (resourceLocation != null) {
                XMLCatalog.this.log("Matching catalog entry found for publicId: '" + resourceLocation.getPublicId() + "' location: '" + resourceLocation.getLocation() + '\'', 4);
                inputSource = XMLCatalog.this.filesystemLookup(resourceLocation);
                if (inputSource == null) {
                    inputSource = XMLCatalog.this.classpathLookup(resourceLocation);
                }
                if (inputSource == null) {
                    inputSource = XMLCatalog.this.urlLookup(resourceLocation);
                }
            }
            return inputSource;
        }

        public Source resolve(String string, String string2) throws TransformerException {
            SAXSource sAXSource = null;
            InputSource inputSource = null;
            ResourceLocation resourceLocation = XMLCatalog.this.findMatchingEntry(string);
            if (resourceLocation != null) {
                XMLCatalog.this.log("Matching catalog entry found for uri: '" + resourceLocation.getPublicId() + "' location: '" + resourceLocation.getLocation() + '\'', 4);
                ResourceLocation resourceLocation2 = resourceLocation;
                if (string2 != null) {
                    try {
                        URL uRL = new URL(string2);
                        resourceLocation2 = new ResourceLocation();
                        resourceLocation2.setBase(uRL);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                resourceLocation2.setPublicId(resourceLocation.getPublicId());
                resourceLocation2.setLocation(resourceLocation.getLocation());
                inputSource = XMLCatalog.this.filesystemLookup(resourceLocation2);
                if (inputSource == null) {
                    inputSource = XMLCatalog.this.classpathLookup(resourceLocation2);
                }
                if (inputSource == null) {
                    inputSource = XMLCatalog.this.urlLookup(resourceLocation2);
                }
                if (inputSource != null) {
                    sAXSource = new SAXSource(inputSource);
                }
            }
            return sAXSource;
        }

        public InternalResolver() {
            XMLCatalog.this.log("Apache resolver library not found, internal resolver will be used", 3);
        }
    }
}

